/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.mixin.accessor.BeeDataAccessor;
import com.cobblemon.mod.common.mixin.accessor.BeehiveBlockEntityAccessor;
import com.cobblemon.mod.common.mixin.accessor.BlockEntityAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BeehiveBlockEntity.class})
public abstract class BeehiveBlockEntityMixin {
    @Accessor(value="stored")
    public abstract List<BeeDataAccessor> getStored();

    @Inject(method={"emptyAllLivingFromHive(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity$BeeReleaseStatus;)V"}, at={@At(value="HEAD")})
    private void cobblemon$emptyAllLivingFromHive(@Nullable Player player, BlockState state, BeehiveBlockEntity.BeeReleaseStatus releaseStatus, CallbackInfo ci) {
        if (player != null) {
            BeehiveBlockEntity blockEntity = (BeehiveBlockEntity)this;
            if (blockEntity.isSedated() || player.position().distanceToSqr(blockEntity.getBlockPos().getCenter()) > 16.0) {
                return;
            }
            BeehiveBlockEntityAccessor blockEntityAccessor = (BeehiveBlockEntityAccessor)((Object)this);
            List<Object> storedList = blockEntityAccessor.getStored();
            ArrayList list = Lists.newArrayList();
            storedList.removeIf(beeData -> {
                BeehiveBlockEntity.Occupant occupant = ((BeeDataAccessor)beeData).invokeToOccupant();
                boolean isPokemon = false;
                if (occupant.entityData().contains("id")) {
                    isPokemon = "cobblemon:pokemon".equals(occupant.entityData().getUnsafe().getString("id"));
                }
                if (isPokemon) {
                    return BeehiveBlockEntityAccessor.releaseOccupant(((BlockEntityAccessor)((Object)blockEntityAccessor)).getLevel(), ((BlockEntityAccessor)((Object)blockEntityAccessor)).getWorldPosition(), state, occupant, list, releaseStatus, blockEntityAccessor.savedFlowerPos());
                }
                return false;
            });
            for (Entity entity : list) {
                if (!(entity instanceof PokemonEntity)) continue;
                ((PokemonEntity)entity).getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)player);
            }
        }
    }

    @Redirect(method={"releaseOccupant(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity$Occupant;Ljava/util/List;Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity$BeeReleaseStatus;Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private static boolean cobblemon$captureReleasedEntity(Level level, Entity entity, Level lvl, BlockPos pos, BlockState state, BeehiveBlockEntity.Occupant occupant, @Nullable List<Entity> bees, BeehiveBlockEntity.BeeReleaseStatus releaseStatus, @Nullable BlockPos flowerPos) {
        if (bees != null && !bees.contains(entity)) {
            bees.add(entity);
        }
        return level.addFreshEntity(entity);
    }
}

