/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010#\u001a\u0004\b$\u0010%R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b*\u0010+R\u001c\u0010-\u001a\u0004\u0018\u00010,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/item/interactive/HyperTrainingItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "", "ivIncreaseAmount", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "targetStats", "Lkotlin/ranges/IntRange;", "validRange", "<init>", "(ILjava/util/Set;Lkotlin/ranges/IntRange;)V", "stat", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "canChangeIV", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/world/item/ItemStack;", "stack", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/InteractionResultHolder;", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "I", "getIvIncreaseAmount", "()I", "Ljava/util/Set;", "getTargetStats", "()Ljava/util/Set;", "Lkotlin/ranges/IntRange;", "getValidRange", "()Lkotlin/ranges/IntRange;", "", "bagItem", "Ljava/lang/Void;", "getBagItem", "()Ljava/lang/Void;", "common"})
@SourceDebugExtension(value={"SMAP\nHyperTrainingItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HyperTrainingItem.kt\ncom/cobblemon/mod/common/item/interactive/HyperTrainingItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1761#2,3:69\n1869#2,2:72\n*S KotlinDebug\n*F\n+ 1 HyperTrainingItem.kt\ncom/cobblemon/mod/common/item/interactive/HyperTrainingItem\n*L\n37#1:69,3\n49#1:72,2\n*E\n"})
public final class HyperTrainingItem
extends CobblemonItem
implements PokemonSelectingItem {
    private final int ivIncreaseAmount;
    @NotNull
    private final Set<Stat> targetStats;
    @NotNull
    private final IntRange validRange;
    @Nullable
    private final Void bagItem;

    public HyperTrainingItem(int ivIncreaseAmount, @NotNull Set<? extends Stat> targetStats, @NotNull IntRange validRange) {
        Intrinsics.checkNotNullParameter(targetStats, (String)"targetStats");
        Intrinsics.checkNotNullParameter((Object)validRange, (String)"validRange");
        super(new Item.Properties());
        this.ivIncreaseAmount = ivIncreaseAmount;
        this.targetStats = targetStats;
        this.validRange = validRange;
    }

    public final int getIvIncreaseAmount() {
        return this.ivIncreaseAmount;
    }

    @NotNull
    public final Set<Stat> getTargetStats() {
        return this.targetStats;
    }

    @NotNull
    public final IntRange getValidRange() {
        return this.validRange;
    }

    @Nullable
    public Void getBagItem() {
        return this.bagItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canChangeIV(Stat stat, Pokemon pokemon) {
        int effectiveIV = pokemon.getIvs().getEffectiveBattleIV(stat);
        IntRange intRange = this.validRange;
        int n = intRange.getFirst();
        if (effectiveIV > intRange.getLast()) return false;
        if (n > effectiveIV) return false;
        boolean bl = true;
        if (!bl) return false;
        int n2 = effectiveIV + this.ivIncreaseAmount;
        if (0 > n2) return false;
        if (n2 >= 32) return false;
        return true;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Iterable $this$any$iv = this.targetStats;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Stat stat = (Stat)element$iv;
                    boolean bl2 = false;
                    if (!this.canChangeIV(stat, pokemon)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (!this.canUseOnPokemon(stack, pokemon)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        Iterable $this$forEach$iv = this.targetStats;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stat stat = (Stat)element$iv;
            boolean bl = false;
            if (!this.canChangeIV(stat, pokemon)) continue;
            int effectiveIV = pokemon.getIvs().getEffectiveBattleIV(stat);
            pokemon.hyperTrainIV(stat, effectiveIV + this.ivIncreaseAmount);
        }
        stack.consume(1, (LivingEntity)player);
        PokemonEntity pokemonEntity = pokemon.getEntity();
        if (pokemonEntity != null) {
            pokemonEntity.playSound(CobblemonSounds.MEDICINE_PILLS_USE, 1.0f, 1.0f);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            return this.use(serverPlayer, itemStack);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }
}

