/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.item.PokemonAndMoveSelectingItem;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J/\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J-\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070 2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010#\u001a\u0004\b$\u0010%R\u001a\u0010'\u001a\u00020&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/item/interactive/EtherItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/PokemonAndMoveSelectingItem;", "", "max", "<init>", "(Z)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/api/moves/Move;", "move", "canUseOnMove", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/api/moves/Move;)Z", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/moves/Move;)V", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "applyToBattlePokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lcom/cobblemon/mod/common/api/moves/Move;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Z", "getMax", "()Z", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nEtherItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EtherItem.kt\ncom/cobblemon/mod/common/item/interactive/EtherItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1761#2,3:76\n1#3:79\n*S KotlinDebug\n*F\n+ 1 EtherItem.kt\ncom/cobblemon/mod/common/item/interactive/EtherItem\n*L\n51#1:76,3\n*E\n"})
public final class EtherItem
extends CobblemonItem
implements PokemonAndMoveSelectingItem {
    private final boolean max;
    @NotNull
    private final BagItem bagItem;

    /*
     * WARNING - void declaration
     */
    public EtherItem(boolean max) {
        Item.Properties properties;
        Item.Properties properties2 = properties = new Item.Properties();
        EtherItem etherItem = this;
        boolean bl = false;
        if (max) {
            void $this$_init__u24lambda_u240;
            $this$_init__u24lambda_u240.rarity(Rarity.UNCOMMON);
        }
        super(properties);
        this.max = max;
        this.bagItem = new BagItem(this){
            private final String itemName;
            private final Item returnItem;
            final /* synthetic */ EtherItem this$0;
            {
                this.this$0 = $receiver;
                this.itemName = "item.cobblemon." + ($receiver.getMax() ? "max_ether" : "ether");
                this.returnItem = Items.GLASS_BOTTLE;
            }

            public String getItemName() {
                return this.itemName;
            }

            public Item getReturnItem() {
                return this.returnItem;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                if (target.getHealth() <= 0) return false;
                Iterable $this$any$iv = target.getMoveSet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (it.getCurrentPp() < it.getMaxPp()) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                return "ether " + data + (this.this$0.getMax() ? "" : " 10");
            }
        };
    }

    public final boolean getMax() {
        return this.max;
    }

    @Override
    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnMove(@NotNull ItemStack stack, @NotNull Move move) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return move.getCurrentPp() < move.getMaxPp();
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Iterable $this$any$iv = pokemon.getMoveSet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (!this.canUseOnMove(stack, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon, @NotNull Move move) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Intrinsics.checkNotNullParameter((Object)move, (String)"move");
            Iterable iterable = pokemon.getMoveSet();
            for (Object t : iterable) {
                Move it = (Move)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTemplate(), (Object)move.getTemplate())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Move moveToRecover = v0;
        if (moveToRecover != null && moveToRecover.getCurrentPp() < moveToRecover.getMaxPp()) {
            moveToRecover.setCurrentPp(this.max ? moveToRecover.getMaxPp() : Math.min(moveToRecover.getMaxPp(), moveToRecover.getCurrentPp() + 10));
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity != null) {
                pokemonEntity.playSound(CobblemonSounds.MEDICINE_LIQUID_USE, 1.0f, 1.0f);
            }
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
                PlayerExtensionsKt.giveOrDropItemStack$default((Player)player, new ItemStack((ItemLike)Items.GLASS_BOTTLE), false, 2, null);
            }
        }
    }

    @Override
    public void applyToBattlePokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon, @NotNull Move move) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            Intrinsics.checkNotNullParameter((Object)move, (String)"move");
            PokemonAndMoveSelectingItem.super.applyToBattlePokemon(player, stack, battlePokemon, move);
            PokemonEntity pokemonEntity = battlePokemon.getEntity();
            if (pokemonEntity == null) break block0;
            pokemonEntity.playSound(CobblemonSounds.MEDICINE_LIQUID_USE, 1.0f, 1.0f);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world instanceof ServerLevel && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            InteractionResultHolder interactionResultHolder = this.use(serverPlayer, itemStack);
            if (interactionResultHolder == null) {
                InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)user.getItemInHand(hand));
                interactionResultHolder = interactionResultHolder2;
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"pass(...)");
            }
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }
}

