/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.interactive;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010#\u001a\u00020\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/item/interactive/ElixirItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "", "max", "<init>", "(Z)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/InteractionResultHolder;", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "applyToBattlePokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Z", "getMax", "()Z", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nElixirItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElixirItem.kt\ncom/cobblemon/mod/common/item/interactive/ElixirItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1761#2,3:91\n1869#2,2:94\n*S KotlinDebug\n*F\n+ 1 ElixirItem.kt\ncom/cobblemon/mod/common/item/interactive/ElixirItem\n*L\n49#1:91,3\n53#1:94,2\n*E\n"})
public final class ElixirItem
extends CobblemonItem
implements PokemonSelectingItem {
    private final boolean max;
    @NotNull
    private final BagItem bagItem;

    /*
     * WARNING - void declaration
     */
    public ElixirItem(boolean max) {
        Item.Properties properties;
        Item.Properties properties2 = properties = new Item.Properties();
        ElixirItem elixirItem = this;
        boolean bl = false;
        if (max) {
            void $this$_init__u24lambda_u240;
            $this$_init__u24lambda_u240.rarity(Rarity.UNCOMMON);
        }
        super(properties);
        this.max = max;
        this.bagItem = new BagItem(this){
            private final String itemName;
            private final Item returnItem;
            final /* synthetic */ ElixirItem this$0;
            {
                this.this$0 = $receiver;
                this.itemName = "item.cobblemon." + ($receiver.getMax() ? "max_elixir" : "elixir");
                this.returnItem = Items.GLASS_BOTTLE;
            }

            public String getItemName() {
                return this.itemName;
            }

            public Item getReturnItem() {
                return this.returnItem;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                if (target.getHealth() <= 0) return false;
                Iterable $this$any$iv = target.getMoveSet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    T element$iv = iterator.next();
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (it.getCurrentPp() < it.getMaxPp()) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                String string = "elixir";
                ElixirItem elixirItem = this.this$0;
                String it = string;
                boolean bl = false;
                return !elixirItem.getMax() ? it + " 10" : it;
            }
        };
    }

    public final boolean getMax() {
        return this.max;
    }

    @Override
    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Iterable $this$any$iv = pokemon.getMoveSet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Move it = (Move)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCurrentPp() < it.getMaxPp())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Ref.BooleanRef changed = new Ref.BooleanRef();
        pokemon.getMoveSet().doWithoutEmitting((Function0<Unit>)((Function0)() -> ElixirItem.applyToPokemon$lambda$0(pokemon, this, changed)));
        if (changed.element) {
            pokemon.getMoveSet().update();
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
                PlayerExtensionsKt.giveOrDropItemStack$default((Player)player, new ItemStack((ItemLike)this.getBagItem().getReturnItem()), false, 2, null);
            }
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity != null) {
                pokemonEntity.playSound(CobblemonSounds.MEDICINE_LIQUID_USE, 1.0f, 1.0f);
            }
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder2);
            interactionResultHolder = interactionResultHolder2;
        } else {
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        }
        return interactionResultHolder;
    }

    @Override
    public void applyToBattlePokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            PokemonSelectingItem.super.applyToBattlePokemon(player, stack, battlePokemon);
            PokemonEntity pokemonEntity = battlePokemon.getEntity();
            if (pokemonEntity == null) break block0;
            pokemonEntity.playSound(CobblemonSounds.MEDICINE_LIQUID_USE, 1.0f, 1.0f);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world instanceof ServerLevel && user instanceof ServerPlayer) {
            ItemStack stack = user.getItemInHand(hand);
            ServerPlayer serverPlayer = (ServerPlayer)user;
            Intrinsics.checkNotNull((Object)stack);
            return this.use(serverPlayer, stack);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)user.getItemInHand(hand));
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    private static final Unit applyToPokemon$lambda$0(Pokemon $pokemon, ElixirItem this$0, Ref.BooleanRef $changed) {
        Iterable $this$forEach$iv = $pokemon.getMoveSet().getMoves();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Move it = (Move)element$iv;
            boolean bl = false;
            if (it.getCurrentPp() >= it.getMaxPp()) continue;
            if (this$0.max) {
                it.setCurrentPp(it.getMaxPp());
            } else {
                it.setCurrentPp(Math.min(it.getCurrentPp() + 10, it.getMaxPp()));
            }
            $changed.element = true;
        }
        return Unit.INSTANCE;
    }
}

