/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.berry;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.berry.BerryItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/cobblemon/mod/common/item/berry/PortionHealingBerryItem;", "Lcom/cobblemon/mod/common/item/berry/BerryItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lcom/cobblemon/mod/common/api/item/HealingSource;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "block", "", "canCauseConfusion", "Lkotlin/Function0;", "Lcom/cobblemon/mod/common/api/molang/ExpressionLike;", "portion", "<init>", "(Lcom/cobblemon/mod/common/block/BerryBlock;ZLkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/InteractionResultHolder;", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "applyToBattlePokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Z", "getCanCauseConfusion", "()Z", "Lkotlin/jvm/functions/Function0;", "getPortion", "()Lkotlin/jvm/functions/Function0;", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "common"})
@SourceDebugExtension(value={"SMAP\nPortionHealingBerryItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortionHealingBerryItem.kt\ncom/cobblemon/mod/common/item/berry/PortionHealingBerryItem\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n40#2:86\n41#2,6:90\n47#2:98\n17#3,2:87\n19#3:97\n13805#4:89\n13806#4:96\n*S KotlinDebug\n*F\n+ 1 PortionHealingBerryItem.kt\ncom/cobblemon/mod/common/item/berry/PortionHealingBerryItem\n*L\n65#1:86\n65#1:90,6\n65#1:98\n65#1:87,2\n65#1:97\n65#1:89\n65#1:96\n*E\n"})
public final class PortionHealingBerryItem
extends BerryItem
implements PokemonSelectingItem,
HealingSource {
    private final boolean canCauseConfusion;
    @NotNull
    private final Function0<ExpressionLike> portion;
    @NotNull
    private final BagItem bagItem;

    public PortionHealingBerryItem(@NotNull BerryBlock block, boolean canCauseConfusion, @NotNull Function0<? extends ExpressionLike> portion) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(portion, (String)"portion");
        super(block);
        this.canCauseConfusion = canCauseConfusion;
        this.portion = portion;
        this.bagItem = new BagItem(this){
            private final Item returnItem;
            final /* synthetic */ PortionHealingBerryItem this$0;
            {
                this.this$0 = $receiver;
                this.returnItem = Items.AIR;
            }

            public String getItemName() {
                Berry berry = this.this$0.berry();
                Intrinsics.checkNotNull((Object)berry);
                return "item.cobblemon." + berry.getIdentifier().getPath();
            }

            public Item getReturnItem() {
                return this.returnItem;
            }

            public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                if (this.this$0.getCanCauseConfusion()) {
                    Berry berry = this.this$0.berry();
                    Intrinsics.checkNotNull((Object)berry);
                    bl = berry.dislikedBy(battlePokemon.getNature());
                } else {
                    bl = false;
                }
                boolean confuse = bl;
                return "potion_by_portion " + MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getGenericRuntime(), (ExpressionLike)this.this$0.getPortion().invoke(), battlePokemon, null, 4, null) + " " + confuse;
            }

            public boolean canUse(ItemStack stack, PokemonBattle battle, BattlePokemon target) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return target.getHealth() < target.getMaxHealth() && target.getHealth() > 0;
            }
        };
    }

    public final boolean getCanCauseConfusion() {
        return this.canCauseConfusion;
    }

    @NotNull
    public final Function0<ExpressionLike> getPortion() {
        return this.portion;
    }

    @Override
    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return !pokemon.isFainted() && !pokemon.isFullHealth() && PokemonSelectingItem.super.canUseOnPokemon(stack, pokemon);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (!this.canUseOnPokemon(stack, pokemon)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        Pokemon.feedPokemon$default(pokemon, 5, false, 2, null);
        int amount = 0;
        amount = Integer.min(pokemon.getCurrentHealth() + (int)(MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getGenericRuntime(), (ExpressionLike)this.portion.invoke(), pokemon, null, 4, null) * (float)pokemon.getMaxHealth()), pokemon.getMaxHealth());
        CancelableObservable<PokemonHealedEvent> cancelableObservable = CobblemonEvents.POKEMON_HEALED;
        Cancelable event$iv = new PokemonHealedEvent(pokemon, amount, this);
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                PokemonHealedEvent cancelledEvent = (PokemonHealedEvent)it$iv;
                boolean bl2 = false;
                return InteractionResultHolder.fail((Object)stack);
            }
            PokemonHealedEvent event = (PokemonHealedEvent)it$iv;
            boolean bl3 = false;
            amount = event.getAmount();
        }
        pokemon.setCurrentHealth(amount);
        stack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public void applyToBattlePokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        PokemonSelectingItem.super.applyToBattlePokemon(player, stack, battlePokemon);
        Pokemon.feedPokemon$default(battlePokemon.getOriginalPokemon(), 5, false, 2, null);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            return this.use(serverPlayer, itemStack);
        }
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }
}

