/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.pokedex.PokedexType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.pokedex.scanner.PokedexUsageContext;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/item/PokedexItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/client/pokedex/PokedexType;", "type", "<init>", "(Lcom/cobblemon/mod/common/client/pokedex/PokedexType;)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "Lnet/minecraft/world/item/UseAnim;", "getUseAnimation", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;", "stack", "Lnet/minecraft/world/entity/LivingEntity;", "user", "", "getUseDuration", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "usedHand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "remainingUseTicks", "", "onUseTick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;I)V", "releaseUsing", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V", "Lcom/cobblemon/mod/common/client/pokedex/PokedexType;", "getType", "()Lcom/cobblemon/mod/common/client/pokedex/PokedexType;", "common"})
@SourceDebugExtension(value={"SMAP\nPokedexItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokedexItem.kt\ncom/cobblemon/mod/common/item/PokedexItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n774#2:104\n865#2,2:105\n2423#2,14:107\n*S KotlinDebug\n*F\n+ 1 PokedexItem.kt\ncom/cobblemon/mod/common/item/PokedexItem\n*L\n91#1:104\n91#1:105,2\n92#1:107,14\n*E\n"})
public final class PokedexItem
extends CobblemonItem {
    @NotNull
    private final PokedexType type;

    public PokedexItem(@NotNull PokedexType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        super(properties);
        this.type = type;
    }

    @NotNull
    public final PokedexType getType() {
        return this.type;
    }

    @Nullable
    public UseAnim getUseAnimation(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return UseAnim.TOOT_HORN;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player.isCrouching()) {
            Class<PokemonEntity> clazz = PokemonEntity.class;
            float f = (float)player.entityInteractionRange();
            PokemonEntity hitPokemon = (PokemonEntity)PlayerExtensionsKt.traceFirstEntityCollision$default((LivingEntity)player, f, 0.0f, clazz, null, null, 26, null);
            if (hitPokemon != null && hitPokemon.isOwnedBy((LivingEntity)player)) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
        }
        if (world.isClientSide && player instanceof LocalPlayer) {
            CobblemonClient.INSTANCE.getPokedexUsageContext().setType(this.type);
        }
        if (!(player instanceof ServerPlayer)) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
            return interactionResultHolder;
        }
        player.startUsingItem(usedHand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
        return interactionResultHolder;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (DistributionUtilsKt.isServerSide(world) && user instanceof ServerPlayer && ((ServerPlayer)user).isChangingDimension()) {
            user.stopUsingItem();
            return;
        }
        if (world.isClientSide && user instanceof LocalPlayer) {
            PokedexUsageContext usageContext = CobblemonClient.INSTANCE.getPokedexUsageContext();
            int ticksInUse = this.getUseDuration(stack, user) - remainingUseTicks;
            usageContext.useTick((LocalPlayer)user, ticksInUse, true);
        }
        super.onUseTick(world, user, stack, remainingUseTicks);
    }

    /*
     * WARNING - void declaration
     */
    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user, int remainingUseTicks) {
        PokemonEntity entity;
        Object v2;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        double range = user instanceof Player ? ((Player)user).entityInteractionRange() : 5.0;
        List list = world.getEntities((Entity)user, AABB.ofSize((Vec3)user.position(), (double)range, (double)range, (double)range));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var11_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            Entity entity2 = (Entity)user;
            Intrinsics.checkNotNull((Object)it);
            if (!PlayerExtensionsKt.isLookingAt$default(entity2, it, 0.0f, 0.1f, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                Entity it = (Entity)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.distanceTo((Entity)user);
                do {
                    Object e$iv = iterator$iv.next();
                    Entity it2 = (Entity)e$iv;
                    $i$a$-minByOrNull-PokedexItem$releaseUsing$entity$2 = false;
                    float v$iv = it2.distanceTo((Entity)user);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        Object var8_22 = v2;
        PokemonEntity pokemonEntity = entity = var8_22 instanceof PokemonEntity ? (PokemonEntity)var8_22 : null;
        if (world.isClientSide && user instanceof LocalPlayer) {
            PokedexUsageContext usageContext = CobblemonClient.INSTANCE.getPokedexUsageContext();
            int ticksInUse = this.getUseDuration(stack, user) - remainingUseTicks;
            Object object = entity;
            usageContext.stopUsing(ticksInUse, object != null && (object = ((PokemonEntity)object).getExposedSpecies()) != null ? ((Species)object).getResourceIdentifier() : null);
        }
        super.releaseUsing(stack, world, user, remainingUseTicks);
    }
}

