/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.entity.boat.CobblemonBoatEntity;
import com.cobblemon.mod.common.entity.boat.CobblemonBoatType;
import com.cobblemon.mod.common.entity.boat.CobblemonChestBoatEntity;
import com.cobblemon.mod.common.item.CobblemonBoatItem;
import com.cobblemon.mod.common.item.CobblemonItem;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/item/CobblemonBoatItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "boatType", "", "hasChest", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;ZLnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/phys/HitResult;", "hitResult", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;", "createBoat", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/HitResult;)Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "getBoatType", "()Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "Z", "getHasChest", "()Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonBoatItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonBoatItem.kt\ncom/cobblemon/mod/common/item/CobblemonBoatItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1869#2,2:74\n*S KotlinDebug\n*F\n+ 1 CobblemonBoatItem.kt\ncom/cobblemon/mod/common/item/CobblemonBoatItem\n*L\n36#1:74,2\n*E\n"})
public final class CobblemonBoatItem
extends CobblemonItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CobblemonBoatType boatType;
    private final boolean hasChest;
    private static final Predicate<Entity> RIDERS = EntitySelector.NO_SPECTATORS.and(arg_0 -> CobblemonBoatItem.RIDERS$lambda$0(Companion.RIDERS.1.INSTANCE, arg_0));

    public CobblemonBoatItem(@NotNull CobblemonBoatType boatType, boolean hasChest, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)boatType), (String)"boatType");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.boatType = boatType;
        this.hasChest = hasChest;
    }

    @NotNull
    public final CobblemonBoatType getBoatType() {
        return this.boatType;
    }

    public final boolean getHasChest() {
        return this.hasChest;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = user.getItemInHand(hand);
        BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        Vec3 vec3d = user.getViewVector(1.0f);
        Vec3 eyePos = user.getEyePosition();
        List list = world.getEntities((Entity)user, user.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), RIDERS);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            AABB box = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            if (!box.contains(eyePos)) continue;
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        Intrinsics.checkNotNull((Object)hitResult);
        CobblemonBoatEntity boatEntity = this.createBoat(world, (HitResult)hitResult);
        boatEntity.setBoatType(this.boatType);
        boatEntity.setYRot(user.getYRot());
        if (!world.noCollision((Entity)boatEntity, boatEntity.getBoundingBox())) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        if (!world.isClientSide) {
            world.addFreshEntity((Entity)boatEntity);
            world.gameEvent((Entity)user, (Holder)GameEvent.ENTITY_PLACE, hitResult.getBlockPos());
            stack.consume(1, (LivingEntity)user);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    private final CobblemonBoatEntity createBoat(Level world, HitResult hitResult) {
        if (this.hasChest) {
            return new CobblemonChestBoatEntity(world, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
        }
        return new CobblemonBoatEntity(world, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
    }

    private static final boolean RIDERS$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/item/CobblemonBoatItem$Companion;", "", "<init>", "()V", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/Entity;", "kotlin.jvm.PlatformType", "RIDERS", "Ljava/util/function/Predicate;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

