/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.block.campfirepot.CampfirePotColor;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/item/CampfirePotItem;", "Lnet/minecraft/world/item/BlockItem;", "Lnet/minecraft/world/level/block/Block;", "block", "Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotColor;", "color", "<init>", "(Lnet/minecraft/world/level/block/Block;Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotColor;)V", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotColor;", "getColor", "()Lcom/cobblemon/mod/common/block/campfirepot/CampfirePotColor;", "common"})
public final class CampfirePotItem
extends BlockItem {
    @NotNull
    private final CampfirePotColor color;

    public CampfirePotItem(@NotNull Block block, @NotNull CampfirePotColor color) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        super(block, new Item.Properties());
        this.color = color;
    }

    @NotNull
    public final CampfirePotColor getColor() {
        return this.color;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        block4: {
            Player player;
            block5: {
                BlockEntity newBlockEntity;
                BlockPos blockPos;
                Level world;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    world = context.getLevel();
                    blockPos = context.getClickedPos();
                    BlockState blockState = world.getBlockState(blockPos);
                    BlockEntity blockEntity = world.getBlockEntity(blockPos);
                    player = context.getPlayer();
                    if (player == null || !(blockState.getBlock() instanceof CampfireBlock) || !(blockEntity instanceof CampfireBlockEntity)) break block4;
                    if (!((Boolean)blockState.getValue((Property)CampfireBlock.LIT)).booleanValue()) break block5;
                    Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
                    Direction itemFacing = Direction.fromYRot((double)player.getYHeadRot());
                    boolean isSoul = Intrinsics.areEqual((Object)blockState.getBlock().asItem().toString(), (Object)"minecraft:soul_campfire");
                    Iterator iterator = ((CampfireBlockEntity)blockEntity).getItems().iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        ItemStack item = (ItemStack)iterator2.next();
                        if (item.isEmpty()) continue;
                        ItemEntity itemEntity = new ItemEntity(world, (double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, item);
                        itemEntity.setDefaultPickUpDelay();
                        world.addFreshEntity((Entity)itemEntity);
                    }
                    ((CampfireBlockEntity)blockEntity).setRemoved();
                    BlockState newBlockState = (BlockState)((BlockState)(isSoul ? CobblemonBlocks.SOUL_CAMPFIRE : CobblemonBlocks.CAMPFIRE).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing)).setValue((Property)com.cobblemon.mod.common.block.campfirepot.CampfireBlock.Companion.getITEM_DIRECTION(), (Comparable)itemFacing.getOpposite());
                    world.setBlockAndUpdate(blockPos, newBlockState);
                    newBlockEntity = world.getBlockEntity(blockPos);
                    if (!(newBlockEntity instanceof com.cobblemon.mod.common.block.entity.CampfireBlockEntity)) break block4;
                    if (((com.cobblemon.mod.common.block.entity.CampfireBlockEntity)newBlockEntity).getPotItem() == null) break block6;
                    ItemStack itemStack = ((com.cobblemon.mod.common.block.entity.CampfireBlockEntity)newBlockEntity).getPotItem();
                    Intrinsics.checkNotNull((Object)itemStack);
                    if (!itemStack.isEmpty()) break block4;
                }
                ((com.cobblemon.mod.common.block.entity.CampfireBlockEntity)newBlockEntity).setPotItem(new ItemStack((ItemLike)this).split(1));
                context.getItemInHand().consume(1, (LivingEntity)player);
                world.playSound(null, blockPos, CobblemonSounds.CAMPFIRE_POT_SET, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
                break block4;
            }
            if (!player.isCrouching()) {
                return InteractionResult.FAIL;
            }
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

