/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.apricorn.Apricorn;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.client.pot.CookingQuality;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.item.components.RideBoostsComponent;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b#\u0010$J'\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010,\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010+\u001a\u00020%H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020.H\u0016\u00a2\u0006\u0004\b1\u00100R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00102\u001a\u0004\b3\u00104R\u001c\u00106\u001a\u0004\u0018\u0001058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lcom/cobblemon/mod/common/item/AprijuiceItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "type", "<init>", "(Lcom/cobblemon/mod/common/api/apricorn/Apricorn;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "hasRideBoosts", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/network/chat/Component;", "getName", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/Component;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "", "Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;", "", "getBoosts", "(Lnet/minecraft/world/item/ItemStack;)Ljava/util/Map;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/LivingEntity;", "finishUsingItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/UseAnim;", "getUseAnimation", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;", "entity", "getUseDuration", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I", "Lnet/minecraft/sounds/SoundEvent;", "getDrinkingSound", "()Lnet/minecraft/sounds/SoundEvent;", "getEatingSound", "Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "getType", "()Lcom/cobblemon/mod/common/api/apricorn/Apricorn;", "", "bagItem", "Ljava/lang/Void;", "getBagItem", "()Ljava/lang/Void;", "common"})
@SourceDebugExtension(value={"SMAP\nAprijuiceItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AprijuiceItem.kt\ncom/cobblemon/mod/common/item/AprijuiceItem\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n188#2,3:131\n463#3:134\n413#3:135\n1252#4,4:136\n*S KotlinDebug\n*F\n+ 1 AprijuiceItem.kt\ncom/cobblemon/mod/common/item/AprijuiceItem\n*L\n78#1:131,3\n97#1:134\n97#1:135\n97#1:136,4\n*E\n"})
public final class AprijuiceItem
extends CobblemonItem
implements PokemonSelectingItem {
    @NotNull
    private final Apricorn type;
    @Nullable
    private final Void bagItem;

    public AprijuiceItem(@NotNull Apricorn type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Item.Properties properties = new Item.Properties().stacksTo(16);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        super(properties);
        this.type = type;
    }

    @NotNull
    public final Apricorn getType() {
        return this.type;
    }

    @Nullable
    public Void getBagItem() {
        return this.bagItem;
    }

    public final boolean hasRideBoosts(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        RideBoostsComponent rideBoostComponent = (RideBoostsComponent)stack.get(CobblemonItemComponents.RIDE_BOOST);
        Object object = rideBoostComponent;
        return object != null && (object = ((RideBoostsComponent)object).getBoosts()) != null ? !object.isEmpty() : false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = user.getItemInHand(hand);
        Intrinsics.checkNotNull((Object)stack);
        if (!this.hasRideBoosts(stack)) {
            user.startUsingItem(hand);
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.consume((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder2);
            interactionResultHolder = interactionResultHolder2;
        } else {
            if (world instanceof ServerLevel && user instanceof ServerPlayer) {
                return PokemonSelectingItem.super.use((ServerPlayer)user, stack);
            }
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        }
        return interactionResultHolder;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Component component;
        String prefixKey;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        RideBoostsComponent rideBoostsComponent = (RideBoostsComponent)stack.get(CobblemonItemComponents.RIDE_BOOST);
        Object object = rideBoostsComponent;
        boolean hasBoosts = object != null && (object = ((RideBoostsComponent)object).getBoosts()) != null ? !object.isEmpty() : false;
        RideBoostsComponent rideBoostsComponent2 = rideBoostsComponent;
        CookingQuality quality = rideBoostsComponent2 != null ? rideBoostsComponent2.getQuality() : null;
        String string = this.type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String baseNameKey = "item.cobblemon.aprijuice_" + string;
        String string2 = hasBoosts && quality == CookingQuality.HIGH ? "item.cobblemon.aprijuice.prefix.delicious" : (hasBoosts && quality == CookingQuality.MEDIUM ? "item.cobblemon.aprijuice.prefix.tasty" : (prefixKey = !hasBoosts ? "item.cobblemon.aprijuice.prefix.plain" : null));
        if (prefixKey != null) {
            Object[] objectArray = new Object[]{Component.translatable((String)prefixKey), Component.translatable((String)baseNameKey)};
            MutableComponent mutableComponent = Component.translatable((String)"item.cobblemon.aprijuice.quality_format", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        } else {
            MutableComponent mutableComponent = Component.translatable((String)baseNameKey);
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        }
        return component;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Map.Entry<RidingStat, Integer> it;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Map<RidingStat, Integer> boosts = this.getBoosts(stack);
        if (boosts.isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Map<RidingStat, Integer> $this$any$iv = boosts;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<RidingStat, Integer>> iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<RidingStat, Integer> element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl2 = false;
        } while (!pokemon.canAddRideBoost(it.getKey()));
        boolean bl3 = true;
        if (!bl3) return false;
        if (!PokemonSelectingItem.super.canUseOnPokemon(stack, pokemon)) return false;
        return true;
    }

    @NotNull
    public final Map<RidingStat, Integer> getBoosts(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Object object = (RideBoostsComponent)stack.get(CobblemonItemComponents.RIDE_BOOST);
        if (object == null || (object = ((RideBoostsComponent)object).getBoosts()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<RidingStat, Integer> boosts;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (!this.canUseOnPokemon(stack, pokemon)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        Pokemon.feedPokemon$default(pokemon, 1, false, 2, null);
        Map<RidingStat, Integer> map = boosts = this.getBoosts(stack);
        Pokemon pokemon2 = pokemon;
        boolean $i$f$mapValues = false;
        void var7_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Float f = Float.valueOf(((Number)it.getValue()).intValue());
            map3.put(k, f);
        }
        pokemon2.addRideBoosts(destination$iv$iv$iv);
        stack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.success((Object)stack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!this.hasRideBoosts(stack) && user instanceof Player && !world.isClientSide) {
            ((Player)user).getFoodData().eat(4, 1.2f);
            stack.consume(1, user);
        }
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.hasRideBoosts(stack) ? UseAnim.NONE : UseAnim.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.hasRideBoosts(stack) ? 0 : 32;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }
}

