/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/PlaceHoneyInHiveTask;", "", "<init>", "()V", "Lnet/minecraft/world/entity/ai/behavior/OneShot;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "create", "()Lnet/minecraft/world/entity/ai/behavior/OneShot;", "entity", "", "wantsToEnterHive", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "common"})
public final class PlaceHoneyInHiveTask {
    @NotNull
    public static final PlaceHoneyInHiveTask INSTANCE = new PlaceHoneyInHiveTask();

    private PlaceHoneyInHiveTask() {
    }

    @NotNull
    public final OneShot<PokemonEntity> create() {
        OneShot oneShot = BehaviorBuilder.create(PlaceHoneyInHiveTask::create$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"create(...)");
        return oneShot;
    }

    public final boolean wantsToEnterHive(@NotNull PokemonEntity entity) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = result = !entity.getBrain().checkMemory(CobblemonMemories.HIVE_COOLDOWN, MemoryStatus.VALUE_PRESENT) && (entity.level().isRaining() || entity.level().isNight() || entity.getBrain().getMemory(CobblemonMemories.HAS_NECTAR).orElse(false) != false);
        if (result) {
            BlockPos blockPos = BrainExtensionsKt.getMemorySafely(entity.getBrain(), CobblemonMemories.HIVE_LOCATION).orElse(null);
            BlockEntity blockEntity = entity.level().getBlockEntity(blockPos);
            return blockEntity instanceof BeehiveBlockEntity && !((BeehiveBlockEntity)blockEntity).isFireNearby();
        }
        return false;
    }

    private static final App create$lambda$0(BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.registered(CobblemonMemories.HAS_NECTAR), (App)it.present(CobblemonMemories.HIVE_LOCATION), (App)it.absent(CobblemonMemories.HIVE_COOLDOWN)).apply((Applicative)it, (arg_0, arg_1, arg_2, arg_3) -> PlaceHoneyInHiveTask.create$lambda$0$0(it, arg_0, arg_1, arg_2, arg_3));
    }

    private static final Trigger create$lambda$0$0(BehaviorBuilder.Instance $it, MemoryAccessor walkTarget, MemoryAccessor pollinated, MemoryAccessor hiveMemory, MemoryAccessor hiveCooldown) {
        return (arg_0, arg_1, arg_2) -> PlaceHoneyInHiveTask.create$lambda$0$0$0($it, hiveMemory, arg_0, arg_1, arg_2);
    }

    private static final boolean create$lambda$0$0$0(BehaviorBuilder.Instance $it, MemoryAccessor $hiveMemory, ServerLevel world, PokemonEntity entity, long time) {
        if (!(entity instanceof PathfinderMob) || !INSTANCE.wantsToEnterHive(entity)) {
            return false;
        }
        BlockPos hiveLocation = (BlockPos)$it.get($hiveMemory);
        Vec3 targetVec = Vec3.atCenterOf((Vec3i)((Vec3i)hiveLocation));
        if (entity.distanceToSqr(targetVec) > 2.0) {
            return false;
        }
        BlockState state = world.getBlockState(hiveLocation);
        Block block = state.getBlock();
        if (block instanceof BeehiveBlock) {
            BlockEntity blockEntity = world.getBlockEntity(hiveLocation);
            if (!(blockEntity instanceof BeehiveBlockEntity)) {
                return false;
            }
            if (((BeehiveBlockEntity)blockEntity).isFull()) {
                entity.getBrain().eraseMemory(CobblemonMemories.HIVE_LOCATION);
            } else {
                ((BeehiveBlockEntity)blockEntity).addOccupant((Entity)entity);
            }
        }
        return true;
    }
}

