/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/PickUpItemTask;", "", "<init>", "()V", "Lcom/bedrockk/molang/Expression;", "condition", "maxReach", "Lnet/minecraft/world/entity/ai/behavior/OneShot;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "create", "(Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;)Lnet/minecraft/world/entity/ai/behavior/OneShot;", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "dropItem", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V", "common"})
public final class PickUpItemTask {
    @NotNull
    public static final PickUpItemTask INSTANCE = new PickUpItemTask();

    private PickUpItemTask() {
    }

    @NotNull
    public final OneShot<PokemonEntity> create(@NotNull Expression condition, @NotNull Expression maxReach) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)maxReach, (String)"maxReach");
        OneShot oneShot = BehaviorBuilder.create(arg_0 -> PickUpItemTask.create$lambda$0(condition, maxReach, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"create(...)");
        return oneShot;
    }

    public final void dropItem(@NotNull Entity entity, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemEntity itemEntity = new ItemEntity(entity.level(), entity.getX() + entity.getLookAngle().x, entity.getY() + 1.0, entity.getZ() + entity.getLookAngle().z, stack);
        itemEntity.setPickUpDelay(40);
        itemEntity.setThrower(entity);
        entity.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
        entity.level().addFreshEntity((Entity)itemEntity);
    }

    private static final App create$lambda$0(Expression $condition, Expression $maxReach, BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.absent(CobblemonMemories.IS_CONSUMING_ITEM), (App)it.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), (App)it.registered(CobblemonMemories.TIME_TRYING_TO_REACH_WANTED_ITEM)).apply((Applicative)it, (arg_0, arg_1, arg_2, arg_3) -> PickUpItemTask.create$lambda$0$0(it, $condition, $maxReach, arg_0, arg_1, arg_2, arg_3));
    }

    private static final Trigger create$lambda$0$0(BehaviorBuilder.Instance $it, Expression $condition, Expression $maxReach, MemoryAccessor walkTarget, MemoryAccessor isConsumingItem, MemoryAccessor nearbyItem, MemoryAccessor timeSpentReachingItem) {
        return (arg_0, arg_1, arg_2) -> PickUpItemTask.create$lambda$0$0$0($it, nearbyItem, $condition, $maxReach, arg_0, arg_1, arg_2);
    }

    private static final boolean create$lambda$0$0$0(BehaviorBuilder.Instance $it, MemoryAccessor $nearbyItem, Expression $condition, Expression $maxReach, ServerLevel serverLevel, PokemonEntity entity, long l) {
        ItemEntity itemEntity = (ItemEntity)$it.get($nearbyItem);
        if (itemEntity == null || !itemEntity.isAlive() || entity != null && !entity.getPokemon().getCanDropHeldItem$common()) {
            return false;
        }
        MoLangRuntime moLangRuntime = MoLangExtensionsKt.getMainThreadRuntime();
        Intrinsics.checkNotNull((Object)entity);
        MoLangExtensionsKt.withQueryValue(moLangRuntime, "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
        boolean condition = MoLangExtensionsKt.resolveBoolean$default(MoLangExtensionsKt.getMainThreadRuntime(), $condition, null, 2, null);
        if (!condition) {
            return false;
        }
        double maxReach = MoLangExtensionsKt.resolveDouble$default(MoLangExtensionsKt.getMainThreadRuntime(), $maxReach, null, 2, null);
        if ((double)itemEntity.distanceTo((Entity)entity) > maxReach) {
            return false;
        }
        entity.take((Entity)itemEntity, 1);
        Pokemon pokemon = entity.getPokemon();
        ItemStack itemStack = itemEntity.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack stack = Pokemon.swapHeldItem$default(pokemon, itemStack, false, false, 6, null);
        if (!stack.isEmpty() && !entity.level().isClientSide) {
            INSTANCE.dropItem((Entity)entity, stack);
        }
        entity.getBrain().eraseMemory(CobblemonMemories.TIME_TRYING_TO_REACH_WANTED_ITEM);
        return true;
    }
}

