/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\"\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/MoveToOwnerTask;", "", "<init>", "()V", "Lcom/bedrockk/molang/Expression;", "condition", "completionRange", "maxDistance", "teleportDistance", "speedMultiplier", "Lnet/minecraft/world/entity/ai/behavior/OneShot;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "create", "(Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;)Lnet/minecraft/world/entity/ai/behavior/OneShot;", "entity", "Lnet/minecraft/world/entity/Entity;", "owner", "", "tryTeleport", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/Entity;)Z", "", "x", "y", "z", "tryTeleportTo", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/Entity;III)Z", "Lnet/minecraft/core/BlockPos;", "pos", "canTeleportTo", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/util/RandomSource;", "random", "min", "max", "getRandomInt", "(Lnet/minecraft/util/RandomSource;II)I", "common"})
public final class MoveToOwnerTask {
    @NotNull
    public static final MoveToOwnerTask INSTANCE = new MoveToOwnerTask();

    private MoveToOwnerTask() {
    }

    @NotNull
    public final OneShot<PokemonEntity> create(@NotNull Expression condition, @NotNull Expression completionRange, @NotNull Expression maxDistance, @NotNull Expression teleportDistance, @NotNull Expression speedMultiplier) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)completionRange, (String)"completionRange");
        Intrinsics.checkNotNullParameter((Object)maxDistance, (String)"maxDistance");
        Intrinsics.checkNotNullParameter((Object)teleportDistance, (String)"teleportDistance");
        Intrinsics.checkNotNullParameter((Object)speedMultiplier, (String)"speedMultiplier");
        OneShot oneShot = BehaviorBuilder.create(arg_0 -> MoveToOwnerTask.create$lambda$0(condition, teleportDistance, maxDistance, speedMultiplier, completionRange, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"create(...)");
        return oneShot;
    }

    private final boolean tryTeleport(PokemonEntity entity, Entity owner) {
        BlockPos blockPos = owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            RandomSource randomSource = entity.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
            int j = this.getRandomInt(randomSource, -3, 3);
            RandomSource randomSource2 = entity.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"getRandom(...)");
            int k = this.getRandomInt(randomSource2, -1, 1);
            RandomSource randomSource3 = entity.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"getRandom(...)");
            int l = this.getRandomInt(randomSource3, -3, 3);
            boolean succeeded = this.tryTeleportTo(entity, owner, blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!succeeded) continue;
            return true;
        }
        return false;
    }

    private final boolean tryTeleportTo(PokemonEntity entity, Entity owner, int x, int y, int z) {
        if (Math.abs((double)x - owner.getX()) < 2.0 && Math.abs((double)z - owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.moveTo((double)x + 0.5, y, (double)z + 0.5, entity.getYRot(), entity.getXRot());
        entity.getNavigation().stop();
        return true;
    }

    private final boolean canTeleportTo(PokemonEntity entity, BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)((Mob)entity), (BlockPos)((BlockPos)pos.mutable()));
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        BlockPos blockPos = pos.subtract((Vec3i)entity.blockPosition());
        return entity.level().noCollision((Entity)entity, entity.getBoundingBox().move(blockPos));
    }

    private final int getRandomInt(RandomSource random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    private static final App create$lambda$0(Expression $condition, Expression $teleportDistance, Expression $maxDistance, Expression $speedMultiplier, Expression $completionRange, BehaviorBuilder.Instance it) {
        return it.group((App)it.registered(MemoryModuleType.WALK_TARGET)).apply((Applicative)it, arg_0 -> MoveToOwnerTask.create$lambda$0$0($condition, $teleportDistance, $maxDistance, $speedMultiplier, $completionRange, it, arg_0));
    }

    private static final Trigger create$lambda$0$0(Expression $condition, Expression $teleportDistance, Expression $maxDistance, Expression $speedMultiplier, Expression $completionRange, BehaviorBuilder.Instance $it, MemoryAccessor walkTarget) {
        return (arg_0, arg_1, arg_2) -> MoveToOwnerTask.create$lambda$0$0$0($condition, $teleportDistance, $maxDistance, $speedMultiplier, $completionRange, $it, walkTarget, arg_0, arg_1, arg_2);
    }

    private static final boolean create$lambda$0$0$0(Expression $condition, Expression $teleportDistance, Expression $maxDistance, Expression $speedMultiplier, Expression $completionRange, BehaviorBuilder.Instance $it, MemoryAccessor $walkTarget, ServerLevel serverLevel, PokemonEntity entity, long l) {
        LivingEntity livingEntity = entity.getOwner();
        if (livingEntity == null) {
            return false;
        }
        LivingEntity owner = livingEntity;
        if (!Intrinsics.areEqual((Object)owner.level(), (Object)entity.level())) {
            return false;
        }
        MoLangRuntime moLangRuntime = MoLangExtensionsKt.getMainThreadRuntime();
        Intrinsics.checkNotNull((Object)entity);
        MoLangExtensionsKt.withQueryValue(moLangRuntime, "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((Entity)entity));
        boolean condition = MoLangExtensionsKt.resolveBoolean$default(MoLangExtensionsKt.getMainThreadRuntime(), $condition, null, 2, null);
        if (!condition) {
            return false;
        }
        float teleportDistance = MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), $teleportDistance, null, 2, null);
        float maxDistance = MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), $maxDistance, null, 2, null);
        float speedMultiplier = MoLangExtensionsKt.resolveFloat$default(MoLangExtensionsKt.getMainThreadRuntime(), $speedMultiplier, null, 2, null);
        int completionRange = MoLangExtensionsKt.resolveInt$default(MoLangExtensionsKt.getMainThreadRuntime(), $completionRange, null, 2, null);
        double horizontalHitboxRadius = Math.max(entity.getBoundingBox().getXsize(), entity.getBoundingBox().getZsize()) / (double)2;
        if ((double)entity.distanceTo((Entity)owner) - horizontalHitboxRadius > (double)teleportDistance) {
            if (INSTANCE.tryTeleport(entity, (Entity)owner)) {
                entity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
                entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            }
            return true;
        }
        if ((double)entity.distanceTo((Entity)owner) - horizontalHitboxRadius > (double)maxDistance && $it.tryGet($walkTarget).isEmpty() && !entity.getBrain().hasMemoryValue(CobblemonMemories.PATH_COOLDOWN)) {
            entity.getBrain().setMemoryWithExpiry(CobblemonMemories.PATH_COOLDOWN, (Object)true, 60L);
            entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)owner, true));
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)owner, speedMultiplier, Math.max(completionRange, (int)Math.ceil(horizontalHitboxRadius)) - 1));
            return true;
        }
        return false;
    }
}

