/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0013R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/HarvestSweetBerryBushTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lnet/minecraft/world/entity/LivingEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "l", "", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)Z", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)Z", "level", "gameTime", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V", "start", "", "startTime", "I", "getStartTime", "()I", "setStartTime", "(I)V", "Companion", "common"})
public final class HarvestSweetBerryBushTask
extends Behavior<LivingEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int startTime;
    public static final int WAIT_TIME = 40;

    public HarvestSweetBerryBushTask() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH, (Object)MemoryStatus.VALUE_PRESENT)};
        super(MapsKt.mapOf((Pair[])pairArray));
    }

    public final int getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(int n) {
        this.startTime = n;
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull LivingEntity entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.startTime > 40) {
            return false;
        }
        Brain brain = entity.getBrain();
        Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"getBrain(...)");
        BlockPos blockPos = BrainExtensionsKt.getMemorySafely(brain, CobblemonMemories.NEARBY_SWEET_BERRY_BUSH).orElse(null);
        if (blockPos == null) {
            return false;
        }
        BlockState blockState = world.getBlockState(blockPos);
        return Intrinsics.areEqual((Object)blockState.getBlock(), (Object)Blocks.SWEET_BERRY_BUSH) && ((Number)((Object)blockState.getValue((Property)SweetBerryBushBlock.AGE))).intValue() >= 2 || CaveVines.hasGlowBerries((BlockState)blockState);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Object t = entity.getBrain().getMemory(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        BlockPos blockPos = (BlockPos)t;
        BlockPos entityPos = entity.blockPosition();
        if (!entityPos.equals((Object)blockPos)) {
            return false;
        }
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(Blocks.SWEET_BERRY_BUSH) && ((Number)((Object)blockState.getValue((Property)SweetBerryBushBlock.AGE))).intValue() >= 2) {
            return true;
        }
        return CaveVines.hasGlowBerries((BlockState)blockState);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ++this.startTime;
        if (this.startTime == 40) {
            PokemonEntity cfr_ignored_0 = (PokemonEntity)entity;
            Level world = ((PokemonEntity)entity).level();
            if (!((GameRules.BooleanValue)world.getGameRules().getRule(GameRules.RULE_MOBGRIEFING)).get()) {
                return;
            }
            Object t = ((PokemonEntity)entity).getBrain().getMemory(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            BlockPos blockPos = (BlockPos)t;
            BlockState blockState = world.getBlockState(blockPos);
            if (CaveVines.hasGlowBerries((BlockState)blockState)) {
                CaveVines.use((Entity)((Entity)entity), (BlockState)blockState, (Level)world, (BlockPos)blockPos);
            } else if (blockState.is(Blocks.SWEET_BERRY_BUSH)) {
                blockState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
                Integer n = (Integer)blockState.getValue((Property)SweetBerryBushBlock.AGE);
                int n2 = 3;
                int j = 1 + ((PokemonEntity)entity).level().random.nextInt(2) + (n != null && n == n2 ? 1 : 0);
                ItemStack itemStack = ((PokemonEntity)entity).getPokemon().getHeldItem$common();
                if (itemStack.isEmpty()) {
                    Pokemon.swapHeldItem$default(((PokemonEntity)entity).getPokemon(), new ItemStack((ItemLike)Items.SWEET_BERRIES), false, false, 6, null);
                    --j;
                }
                if (j > 0) {
                    Block.popResource((Level)((PokemonEntity)entity).level(), (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)Items.SWEET_BERRIES, j));
                }
                entity.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
                Level level2 = ((PokemonEntity)entity).level();
                Object object = blockState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
                level2.setBlock(blockPos, (BlockState)object, 2);
                ((PokemonEntity)entity).level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)((Entity)entity)));
            }
            ((PokemonEntity)entity).getBrain().eraseMemory(CobblemonMemories.TIME_TRYING_TO_REACH_BERRY_BUSH);
            ((PokemonEntity)entity).getBrain().eraseMemory(CobblemonMemories.NEARBY_SWEET_BERRY_BUSH);
        }
    }

    protected void start(@NotNull ServerLevel world, @NotNull LivingEntity entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.startTime = 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/HarvestSweetBerryBushTask$Companion;", "", "<init>", "()V", "", "WAIT_TIME", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

