/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/FindRestingPlaceTask;", "", "<init>", "()V", "", "horizontalSearchDistance", "verticalSearchDistance", "Lnet/minecraft/world/entity/ai/behavior/OneShot;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "create", "(II)Lnet/minecraft/world/entity/ai/behavior/OneShot;", "common"})
@SourceDebugExtension(value={"SMAP\nFindRestingPlaceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindRestingPlaceTask.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/tasks/FindRestingPlaceTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n774#2:50\n865#2,2:51\n2423#2,14:53\n*S KotlinDebug\n*F\n+ 1 FindRestingPlaceTask.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/tasks/FindRestingPlaceTask\n*L\n35#1:50\n35#1:51,2\n37#1:53,14\n*E\n"})
public final class FindRestingPlaceTask {
    @NotNull
    public static final FindRestingPlaceTask INSTANCE = new FindRestingPlaceTask();

    private FindRestingPlaceTask() {
    }

    @NotNull
    public final OneShot<PokemonEntity> create(int horizontalSearchDistance, int verticalSearchDistance) {
        OneShot oneShot = BehaviorBuilder.create(arg_0 -> FindRestingPlaceTask.create$lambda$0(horizontalSearchDistance, verticalSearchDistance, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"create(...)");
        return oneShot;
    }

    private static final App create$lambda$0(int $horizontalSearchDistance, int $verticalSearchDistance, BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.present(CobblemonMemories.POKEMON_DROWSY), (App)it.absent(CobblemonMemories.PATH_COOLDOWN)).apply((Applicative)it, (arg_0, arg_1, arg_2) -> FindRestingPlaceTask.create$lambda$0$0(it, $horizontalSearchDistance, $verticalSearchDistance, arg_0, arg_1, arg_2));
    }

    private static final Trigger create$lambda$0$0(BehaviorBuilder.Instance $it, int $horizontalSearchDistance, int $verticalSearchDistance, MemoryAccessor walkTarget, MemoryAccessor pokemonDrowsy, MemoryAccessor restPathCooldown) {
        return (arg_0, arg_1, arg_2) -> FindRestingPlaceTask.create$lambda$0$0$0($it, pokemonDrowsy, $horizontalSearchDistance, $verticalSearchDistance, walkTarget, arg_0, arg_1, arg_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean create$lambda$0$0$0(BehaviorBuilder.Instance $it, MemoryAccessor $pokemonDrowsy, int $horizontalSearchDistance, int $verticalSearchDistance, MemoryAccessor $walkTarget, ServerLevel world, PokemonEntity entity, long l) {
        Object v4;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if ((Boolean)$it.get($pokemonDrowsy) == false) return false;
        PersistentStatusContainer persistentStatusContainer = entity.getPokemon().getStatus();
        if (Intrinsics.areEqual((Object)(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null), (Object)Statuses.SLEEP)) return false;
        entity.getBrain().setMemoryWithExpiry(CobblemonMemories.PATH_COOLDOWN, (Object)true, 80L);
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        BlockGetter blockGetter = (BlockGetter)level;
        AABB aABB = AABB.ofSize((Vec3)entity.position(), (double)$horizontalSearchDistance, (double)$verticalSearchDistance, (double)$horizontalSearchDistance);
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"ofSize(...)");
        Iterable<BlockPos> iterable = WorldExtensionsKt.getBlockPositions(blockGetter, aABB);
        Intrinsics.checkNotNull((Object)entity);
        PokemonEntity pokemonEntity = entity;
        boolean $i$f$filter = false;
        void var13_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BlockPos p0 = (BlockPos)element$iv$iv;
            boolean bl = false;
            if (!pokemonEntity.canSleepAt(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                BlockPos it = (BlockPos)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.distToCenterSqr((Position)entity.position());
                do {
                    Object e$iv = iterator$iv.next();
                    BlockPos it2 = (BlockPos)e$iv;
                    $i$a$-minByOrNull-FindRestingPlaceTask$create$1$1$1$position$2 = false;
                    double v$iv = it2.distToCenterSqr((Position)entity.position());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        BlockPos position = v4;
        if (position == null) return true;
        $walkTarget.set((Object)new WalkTarget(position.below(), 0.3f, 1));
        return true;
    }
}

