/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.entity.PosableEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001f\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatGrassTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "", "eatingChance", "", "cooldownTicks", "<init>", "(FJ)V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "time", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "F", "getEatingChance", "()F", "J", "getCooldownTicks", "()J", "Lnet/minecraft/world/level/block/state/predicate/BlockStatePredicate;", "kotlin.jvm.PlatformType", "grassPredicate", "Lnet/minecraft/world/level/block/state/predicate/BlockStatePredicate;", "getGrassPredicate", "()Lnet/minecraft/world/level/block/state/predicate/BlockStatePredicate;", "", "timer", "I", "getTimer", "()I", "setTimer", "(I)V", "common"})
@SourceDebugExtension(value={"SMAP\nEatGrassTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EatGrassTask.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatGrassTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class EatGrassTask
extends Behavior<PokemonEntity> {
    private final float eatingChance;
    private final long cooldownTicks;
    private final BlockStatePredicate grassPredicate;
    private int timer;

    public EatGrassTask(float eatingChance, long cooldownTicks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, CobblemonMemories.RECENTLY_ATE_GRASS, (Object)MemoryStatus.VALUE_ABSENT));
        this.eatingChance = eatingChance;
        this.cooldownTicks = cooldownTicks;
        this.grassPredicate = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);
        this.timer = -1;
    }

    public final float getEatingChance() {
        return this.eatingChance;
    }

    public final long getCooldownTicks() {
        return this.cooldownTicks;
    }

    public final BlockStatePredicate getGrassPredicate() {
        return this.grassPredicate;
    }

    public final int getTimer() {
        return this.timer;
    }

    public final void setTimer(int n) {
        this.timer = n;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (world.random.nextFloat() > this.eatingChance) {
                    return false;
                }
                object = (FlagSpeciesFeature)entity.getPokemon().getFeature("sheared");
                if (object == null) break block5;
                Boolean bl = ((FlagSpeciesFeature)object).getEnabled();
                boolean it = bl;
                boolean bl2 = false;
                object = it ? bl : null;
                if (object != null) break block6;
            }
            EatGrassTask $this$checkExtraStartConditions_u24lambda_u241 = this;
            boolean bl = false;
            return false;
        }
        ((Boolean)object).booleanValue();
        BlockPos blockPos = entity.blockPosition();
        if (this.grassPredicate.test(world.getBlockState(blockPos))) {
            return true;
        }
        return world.getBlockState(blockPos.below()).is(Blocks.GRASS_BLOCK);
    }

    protected void start(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.timer = 40;
        entity.getBrain().setMemoryWithExpiry(CobblemonMemories.PATH_COOLDOWN, (Object)true, 40L);
        PosableEntity.playAnimation$default(entity, "eat", null, 2, null);
        world.broadcastEntityEvent((Entity)entity, (byte)10);
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int n = this.timer;
        this.timer = n + -1;
        if (this.timer < 0) {
            BlockPos blockPos2;
            BlockPos blockPos = entity.blockPosition();
            if (this.grassPredicate.test(world.getBlockState(blockPos))) {
                if (world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    world.destroyBlock(blockPos, false);
                }
                entity.ate();
                entity.getBrain().setMemoryWithExpiry(CobblemonMemories.RECENTLY_ATE_GRASS, (Object)true, this.cooldownTicks);
            } else if (world.getBlockState(blockPos.below()).is(Blocks.GRASS_BLOCK) && world.getBlockState(blockPos2 = blockPos.below()).is(Blocks.GRASS_BLOCK)) {
                if (world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    world.levelEvent(2001, blockPos2, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                    world.setBlock(blockPos2, Blocks.DIRT.defaultBlockState(), 2);
                }
                entity.getBrain().setMemoryWithExpiry(CobblemonMemories.RECENTLY_ATE_GRASS, (Object)true, this.cooldownTicks);
                entity.ate();
            }
            return false;
        }
        return true;
    }
}

