/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.RestBehaviour;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00060\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/DrowsySensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "", "kotlin.jvm.PlatformType", "requires", "()Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Companion", "common"})
public final class DrowsySensor
extends Sensor<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DrowsySensor() {
        super(20);
    }

    @NotNull
    public Set<MemoryModuleType<Boolean>> requires() {
        return SetsKt.setOf(CobblemonMemories.POKEMON_DROWSY);
    }

    protected void doTick(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Companion.drowsyLogic(entity);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/DrowsySensor$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "", "drowsyLogic", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final void drowsyLogic(@NotNull PokemonEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Level world = entity.level();
            RestBehaviour rest = entity.getBehaviour().getResting();
            Boolean isDrowsy = BrainExtensionsKt.getMemorySafely(entity.getBrain(), CobblemonMemories.POKEMON_DROWSY).orElse(false);
            boolean hurtLately = entity.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
            boolean shouldBeDrowsy = rest.getCanSleep() && !hurtLately && rest.getTimes().contains((int)world.getDayTime() % 24000) && !entity.getBrain().hasMemoryValue(MemoryModuleType.ANGRY_AT);
            PersistentStatusContainer persistentStatusContainer = entity.getPokemon().getStatus();
            boolean forcedAsleep = Intrinsics.areEqual((Object)(persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null), (Object)Statuses.SLEEP);
            if (entity.isBattling()) {
                if (!isDrowsy.booleanValue() && forcedAsleep) {
                    entity.getBrain().setMemory(CobblemonMemories.POKEMON_DROWSY, (Object)true);
                } else if (isDrowsy.booleanValue() && !forcedAsleep) {
                    entity.getBrain().eraseMemory(CobblemonMemories.POKEMON_DROWSY);
                }
            } else if (!isDrowsy.booleanValue() && shouldBeDrowsy && entity.getRandom().nextFloat() < rest.getDrowsyChance()) {
                entity.getBrain().setMemory(CobblemonMemories.POKEMON_DROWSY, (Object)true);
            } else if (isDrowsy.booleanValue() && !shouldBeDrowsy) {
                entity.getBrain().eraseMemory(CobblemonMemories.POKEMON_DROWSY);
            } else if (isDrowsy.booleanValue() && entity.getRandom().nextFloat() < rest.getRouseChance()) {
                entity.getBrain().eraseMemory(CobblemonMemories.POKEMON_DROWSY);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

