/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.sensors.BeeHiveSensor;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/BeeHiveSensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "", "requires", "()Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "isValidHive", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "isHiveBlock", "Lnet/minecraft/core/BlockPos;", "pos", "hasReachableAdjacentSide", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Z", "", "findNearbyHivesWithSpace", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Ljava/util/List;", "hivePos", "Lnet/minecraft/world/level/Level;", "doesHiveHaveSpace", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Level;)Z", "common"})
public final class BeeHiveSensor
extends Sensor<PokemonEntity> {
    public BeeHiveSensor() {
        super(300);
    }

    @NotNull
    public Set<MemoryModuleType<? extends Object>> requires() {
        Object[] objectArray = new MemoryModuleType[]{CobblemonMemories.HIVE_LOCATION, CobblemonMemories.HIVE_BLACKLIST};
        return SetsKt.setOf((Object[])objectArray);
    }

    protected void doTick(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Brain<PokemonEntity> brain = entity.getBrain();
        BlockPos currentHive = brain.getMemory(CobblemonMemories.HIVE_LOCATION).orElse(null);
        if (currentHive != null) {
            BlockState state = world.getBlockState(currentHive);
            Intrinsics.checkNotNull((Object)state);
            if (!this.isValidHive(state) || !this.hasReachableAdjacentSide(world, currentHive)) {
                brain.eraseMemory(CobblemonMemories.HIVE_LOCATION);
            } else {
                return;
            }
        }
        BlockPos closestHivePos = null;
        List<BlockPos> list = this.findNearbyHivesWithSpace(entity);
        if (!list.isEmpty()) {
            List blackList = brain.getMemory(CobblemonMemories.HIVE_BLACKLIST).orElse(CollectionsKt.emptyList());
            for (BlockPos blockPos : list) {
                if (blackList.contains(blockPos) || !this.hasReachableAdjacentSide(world, blockPos)) continue;
                closestHivePos = blockPos;
                break;
            }
            if (closestHivePos == null) {
                brain.eraseMemory(CobblemonMemories.HIVE_BLACKLIST);
                closestHivePos = (BlockPos)CollectionsKt.first(list);
            }
        }
        if (closestHivePos != null) {
            brain.setMemory(CobblemonMemories.HIVE_LOCATION, closestHivePos);
        }
    }

    private final boolean isValidHive(BlockState state) {
        return this.isHiveBlock(state);
    }

    private final boolean isHiveBlock(BlockState state) {
        return state.is(Blocks.BEEHIVE) || state.is(Blocks.BEE_NEST);
    }

    private final boolean hasReachableAdjacentSide(ServerLevel world, BlockPos pos) {
        for (Direction dir : EntriesMappings.entries$0) {
            BlockPos adjacentPos = pos.relative(dir);
            if (!world.isEmptyBlock(adjacentPos)) continue;
            return true;
        }
        return false;
    }

    private final List<BlockPos> findNearbyHivesWithSpace(PokemonEntity entity) {
        BlockPos blockPos = entity.blockPosition();
        Level level = entity.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        PoiManager poiManager = ((ServerLevel)level).getPoiManager();
        Stream stream = poiManager.getInRange(BeeHiveSensor::findNearbyHivesWithSpace$lambda$0, blockPos, 20, PoiManager.Occupancy.ANY);
        List<Object> list = stream.map(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$1(findNearbyHivesWithSpace.1.INSTANCE, arg_0)).filter(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$3(arg_0 -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$2(this, entity, arg_0), arg_0)).sorted((arg_0, arg_1) -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$5((arg_0, arg_1) -> BeeHiveSensor.findNearbyHivesWithSpace$lambda$4(blockPos, arg_0, arg_1), arg_0, arg_1)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private final boolean doesHiveHaveSpace(BlockPos hivePos, Level world) {
        BlockEntity blockEntity = world.getBlockEntity(hivePos);
        if (blockEntity instanceof BeehiveBlockEntity) {
            return !((BeehiveBlockEntity)blockEntity).isFull();
        }
        return false;
    }

    private static final boolean findNearbyHivesWithSpace$lambda$0(Holder holder) {
        return holder.is(PoiTypeTags.BEE_HOME);
    }

    private static final BlockPos findNearbyHivesWithSpace$lambda$1(Function1 $tmp0, Object p0) {
        return (BlockPos)$tmp0.invoke(p0);
    }

    private static final boolean findNearbyHivesWithSpace$lambda$2(BeeHiveSensor this$0, PokemonEntity $entity, BlockPos pos) {
        Intrinsics.checkNotNull((Object)pos);
        Level level = $entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return this$0.doesHiveHaveSpace(pos, level);
    }

    private static final boolean findNearbyHivesWithSpace$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int findNearbyHivesWithSpace$lambda$4(BlockPos $blockPos, BlockPos pos1, BlockPos pos2) {
        return (int)pos1.distSqr((Vec3i)$blockPos) - (int)pos2.distSqr((Vec3i)$blockPos);
    }

    private static final int findNearbyHivesWithSpace$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

