/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.npc.ai;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.storage.party.NPCPartyStore;
import com.cobblemon.mod.common.block.entity.HealingMachineBlockEntity;
import com.cobblemon.mod.common.entity.PosableEntity;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0018\u0010\u0017R\"\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/entity/npc/ai/HealUsingHealingMachineTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lnet/minecraft/world/entity/LivingEntity;", "Lcom/bedrockk/molang/Expression;", "horizontalUseRange", "verticalUseRange", "<init>", "(Lcom/bedrockk/molang/Expression;Lcom/bedrockk/molang/Expression;)V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "l", "", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)Z", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)Z", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;J)V", "Lcom/bedrockk/molang/Expression;", "getHorizontalUseRange", "()Lcom/bedrockk/molang/Expression;", "getVerticalUseRange", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "setBlockPos", "(Lnet/minecraft/core/BlockPos;)V", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "nearestHealer", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "getNearestHealer", "()Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "setNearestHealer", "(Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;)V", "common"})
@SourceDebugExtension(value={"SMAP\nHealUsingHealingMachineTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealUsingHealingMachineTask.kt\ncom/cobblemon/mod/common/entity/npc/ai/HealUsingHealingMachineTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n827#2:79\n855#2,2:80\n2423#2,14:82\n*S KotlinDebug\n*F\n+ 1 HealUsingHealingMachineTask.kt\ncom/cobblemon/mod/common/entity/npc/ai/HealUsingHealingMachineTask\n*L\n63#1:79\n63#1:80,2\n64#1:82,14\n*E\n"})
public final class HealUsingHealingMachineTask
extends Behavior<LivingEntity> {
    @NotNull
    private final Expression horizontalUseRange;
    @NotNull
    private final Expression verticalUseRange;
    @NotNull
    private BlockPos blockPos;
    @Nullable
    private HealingMachineBlockEntity nearestHealer;

    public HealUsingHealingMachineTask(@NotNull Expression horizontalUseRange, @NotNull Expression verticalUseRange) {
        Intrinsics.checkNotNullParameter((Object)horizontalUseRange, (String)"horizontalUseRange");
        Intrinsics.checkNotNullParameter((Object)verticalUseRange, (String)"verticalUseRange");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to(CobblemonMemories.NPC_BATTLING, (Object)MemoryStatus.VALUE_ABSENT)};
        super(MapsKt.mapOf((Pair[])pairArray));
        this.horizontalUseRange = horizontalUseRange;
        this.verticalUseRange = verticalUseRange;
        this.blockPos = new BlockPos(0, 0, 0);
    }

    public /* synthetic */ HealUsingHealingMachineTask(Expression expression, Expression expression2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Expression expression3 = MoLangExtensionsKt.asExpression("3");
            Intrinsics.checkNotNullExpressionValue((Object)expression3, (String)"asExpression(...)");
            expression = expression3;
        }
        if ((n & 2) != 0) {
            Expression expression4 = MoLangExtensionsKt.asExpression("2");
            Intrinsics.checkNotNullExpressionValue((Object)expression4, (String)"asExpression(...)");
            expression2 = expression4;
        }
        this(expression, expression2);
    }

    @NotNull
    public final Expression getHorizontalUseRange() {
        return this.horizontalUseRange;
    }

    @NotNull
    public final Expression getVerticalUseRange() {
        return this.verticalUseRange;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    public final void setBlockPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.blockPos = blockPos;
    }

    @Nullable
    public final HealingMachineBlockEntity getNearestHealer() {
        return this.nearestHealer;
    }

    public final void setNearestHealer(@Nullable HealingMachineBlockEntity healingMachineBlockEntity) {
        this.nearestHealer = healingMachineBlockEntity;
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull LivingEntity entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        HealingMachineBlockEntity healer = this.nearestHealer;
        return healer != null && Intrinsics.areEqual((Object)healer.getCurrentUser(), (Object)entity.getUUID()) && Intrinsics.areEqual((Object)world.getBlockEntity(this.blockPos), (Object)((Object)healer));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        block8: {
            Object v4;
            void $this$minByOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            boolean partyNeedsHealing;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (!(entity instanceof NPCEntity)) {
                return false;
            }
            NPCPartyStore nPCPartyStore = ((NPCEntity)entity).getParty();
            boolean bl = partyNeedsHealing = (nPCPartyStore != null ? nPCPartyStore.getHealingRemainderPercent() : 0.0f) > 0.0f;
            if (!partyNeedsHealing) {
                return false;
            }
            BlockPos npcPos = entity.blockPosition();
            MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", ((NPCEntity)entity).getStruct());
            double horizRange = MoLangExtensionsKt.resolveDouble$default(MoLangExtensionsKt.getMainThreadRuntime(), this.horizontalUseRange, null, 2, null);
            double vertRange = MoLangExtensionsKt.resolveDouble$default(MoLangExtensionsKt.getMainThreadRuntime(), this.verticalUseRange, null, 2, null);
            BlockGetter blockGetter = (BlockGetter)world;
            AABB aABB = AABB.ofSize((Vec3)entity.position(), (double)horizRange, (double)vertRange, (double)horizRange);
            Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"ofSize(...)");
            Iterable iterable = WorldExtensionsKt.getNearbyBlockEntities(blockGetter, aABB, CobblemonBlockEntities.HEALING_MACHINE);
            boolean $i$f$filterNot = false;
            void var12_10 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (((HealingMachineBlockEntity)((Object)it.getSecond())).isInUse()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    Pair it = (Pair)minElem$iv;
                    boolean bl3 = false;
                    double minValue$iv = ((BlockPos)it.getFirst()).distSqr((Vec3i)npcPos);
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it2 = (Pair)e$iv;
                        $i$a$-minByOrNull-HealUsingHealingMachineTask$checkExtraStartConditions$2 = false;
                        double v$iv = ((BlockPos)it2.getFirst()).distSqr((Vec3i)npcPos);
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = minElem$iv;
                }
            }
            Pair pair = v4;
            if (pair == null) break block8;
            Pair it = pair;
            boolean bl4 = false;
            this.blockPos = (BlockPos)it.getFirst();
            this.nearestHealer = (HealingMachineBlockEntity)((Object)it.getSecond());
        }
        return this.nearestHealer != null;
    }

    protected void start(@NotNull ServerLevel world, @NotNull LivingEntity entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NPCEntity cfr_ignored_0 = (NPCEntity)entity;
        HealingMachineBlockEntity healingMachineBlockEntity = this.nearestHealer;
        if (healingMachineBlockEntity != null) {
            UUID uUID = ((NPCEntity)entity).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            NPCPartyStore nPCPartyStore = ((NPCEntity)entity).getParty();
            if (nPCPartyStore == null) {
                return;
            }
            healingMachineBlockEntity.activate(uUID, nPCPartyStore);
        }
        PosableEntity.playAnimation$default((PosableEntity)entity, "punch_right", null, 2, null);
    }

    public HealUsingHealingMachineTask() {
        this(null, null, 3, null);
    }
}

