/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.boat;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.entity.boat.CobblemonBoatType;
import com.cobblemon.mod.common.mixin.accessor.BoatEntityAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bB)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b \u0010\u001fJ\u0017\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020!H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0014\u00a2\u0006\u0004\b(\u0010)J/\u00101\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\t2\u0006\u0010,\u001a\u00020+2\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0014\u00a2\u0006\u0004\b1\u00102J\u000f\u00104\u001a\u000203H\u0004\u00a2\u0006\u0004\b4\u00105R$\u0010<\u001a\u0002062\u0006\u00107\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010@\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010D\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006F"}, d2={"Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;", "Lnet/minecraft/world/entity/vehicle/Boat;", "Lnet/minecraft/world/entity/EntityType;", "entityType", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "", "x", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "Lnet/minecraft/world/item/Item;", "getDropItem", "()Lnet/minecraft/world/item/Item;", "Lnet/minecraft/server/level/ServerEntity;", "entityTrackerEntry", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getAddEntityPacket", "(Lnet/minecraft/server/level/ServerEntity;)Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "builder", "", "defineSynchedData", "(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "readAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "addAdditionalSaveData", "Lnet/minecraft/world/entity/vehicle/Boat$Type;", "type", "setVariant", "(Lnet/minecraft/world/entity/vehicle/Boat$Type;)V", "getVariant", "()Lnet/minecraft/world/entity/vehicle/Boat$Type;", "", "getSinglePassengerXOffset", "()F", "heightDifference", "", "onGround", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "landedPosition", "checkFallDamage", "(DZLnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)V", "Lcom/cobblemon/mod/common/mixin/accessor/BoatEntityAccessor;", "accessor", "()Lcom/cobblemon/mod/common/mixin/accessor/BoatEntityAccessor;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "value", "getBoatType", "()Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "setBoatType", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;)V", "boatType", "Lnet/minecraft/world/level/block/state/properties/WoodType;", "getWoodType", "()Lnet/minecraft/world/level/block/state/properties/WoodType;", "woodType", "Lnet/minecraft/world/level/block/Block;", "getBaseBlock", "()Lnet/minecraft/world/level/block/Block;", "baseBlock", "Companion", "common"})
public class CobblemonBoatEntity
extends Boat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE_KEY = "type";
    private static final EntityDataAccessor<Integer> TYPE_TRACKED_DATA = SynchedEntityData.defineId(CobblemonBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CobblemonBoatEntity(@NotNull EntityType<? extends Boat> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
    }

    public CobblemonBoatEntity(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(CobblemonEntities.BOAT, world);
    }

    public CobblemonBoatEntity(@NotNull Level world, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(CobblemonEntities.BOAT, world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @NotNull
    public final CobblemonBoatType getBoatType() {
        Object object = this.entityData.get(TYPE_TRACKED_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return CobblemonBoatType.Companion.ofOrdinal$common(((Number)object).intValue());
    }

    public final void setBoatType(@NotNull CobblemonBoatType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.entityData.set(TYPE_TRACKED_DATA, (Object)value.ordinal());
    }

    @NotNull
    public final WoodType getWoodType() {
        return this.getBoatType().getWoodType();
    }

    @NotNull
    public final Block getBaseBlock() {
        return this.getBoatType().getBaseBlock();
    }

    @NotNull
    public Item getDropItem() {
        return this.getBoatType().getBoatItem();
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity entityTrackerEntry) {
        Intrinsics.checkNotNullParameter((Object)entityTrackerEntry, (String)"entityTrackerEntry");
        return (Packet)new ClientboundAddEntityPacket((Entity)this, entityTrackerEntry);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(TYPE_TRACKED_DATA, (Object)CobblemonBoatType.APRICORN.ordinal());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.contains(TYPE_KEY, 8)) {
            String string = nbt.getString(TYPE_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.setBoatType(CobblemonBoatType.valueOf(string));
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.put(TYPE_KEY, (Tag)StringTag.valueOf((String)this.getBoatType().name()));
    }

    public void setVariant(@NotNull Boat.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)TYPE_KEY);
        throw new UnsupportedOperationException("The vanilla boat type is not present in the Cobblemon implementation use the boatType property");
    }

    @NotNull
    public Boat.Type getVariant() {
        return Boat.Type.BAMBOO;
    }

    protected float getSinglePassengerXOffset() {
        return this.getBoatType().getMountedOffset();
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, @NotNull BlockState state, @NotNull BlockPos landedPosition) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)landedPosition, (String)"landedPosition");
        BoatEntityAccessor accessor = this.accessor();
        accessor.setFallVelocity(this.getDeltaMovement().y);
        if (!this.isPassenger()) {
            return;
        }
        if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && heightDifference < 0.0) {
            this.fallDistance -= (float)heightDifference;
        }
        if (!onGround) {
            return;
        }
        if (this.fallDistance < 3.0f || accessor.getLocation() != Boat.Status.ON_LAND) {
            this.resetFallDistance();
            return;
        }
        this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
        if (this.level().isClientSide || this.isRemoved()) {
            return;
        }
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            int it;
            int n = 3;
            int n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                this.spawnAtLocation((ItemLike)this.getBoatType().getBaseBlock());
            }
            n = 2;
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                this.spawnAtLocation((ItemLike)Items.STICK);
            }
        }
    }

    @NotNull
    protected final BoatEntityAccessor accessor() {
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type com.cobblemon.mod.common.mixin.accessor.BoatEntityAccessor");
        return (BoatEntityAccessor)((Object)this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R8\u0010\n\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity$Companion;", "", "<init>", "()V", "", "TYPE_KEY", "Ljava/lang/String;", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "TYPE_TRACKED_DATA", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

