/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.cobblemon.mod.common.entity.ai.CobblemonWalkTarget;
import com.cobblemon.mod.common.pokemon.ai.OmniPathNodeMaker;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00018B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u0019J'\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u0019J3\u0010\"\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0 H\u0002\u00a2\u0006\u0004\b\"\u0010#J'\u0010&\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b&\u0010'J)\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010-\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0018\u00101\u001a\u0004\u0018\u00010*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0018\u00103\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u00069"}, d2={"Lcom/cobblemon/mod/common/entity/ai/FollowWalkTargetTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lnet/minecraft/world/entity/PathfinderMob;", "", "minRunTime", "maxRunTime", "<init>", "(II)V", "Lnet/minecraft/server/level/ServerLevel;", "level", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/PathfinderMob;)Z", "", "resetPathUpdateCountdownTicks", "(Lnet/minecraft/world/entity/PathfinderMob;)V", "arg", "arg2", "", "l", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/PathfinderMob;J)Z", "world", "stop", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/PathfinderMob;J)V", "time", "start", "tick", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/level/pathfinder/PathType;", "nodeFilter", "Lkotlin/Function0;", "block", "withNodeFilter", "(Lnet/minecraft/world/entity/PathfinderMob;Ljava/util/function/Predicate;Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/world/entity/ai/memory/WalkTarget;", "walkTarget", "hasFinishedPath", "(Lnet/minecraft/world/entity/PathfinderMob;Lnet/minecraft/world/entity/ai/memory/WalkTarget;J)Z", "Lnet/minecraft/core/BlockPos;", "target", "Lnet/minecraft/world/level/pathfinder/Path;", "generatePath", "(Lnet/minecraft/world/entity/PathfinderMob;Lnet/minecraft/world/entity/ai/memory/WalkTarget;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/pathfinder/Path;", "hasReached", "(Lnet/minecraft/world/entity/PathfinderMob;Lnet/minecraft/world/entity/ai/memory/WalkTarget;)Z", "pathUpdateCountdownTicks", "I", "path", "Lnet/minecraft/world/level/pathfinder/Path;", "lookTargetPos", "Lnet/minecraft/core/BlockPos;", "", "speed", "F", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nFollowWalkTargetTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowWalkTargetTask.kt\ncom/cobblemon/mod/common/entity/ai/FollowWalkTargetTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class FollowWalkTargetTask
extends Behavior<PathfinderMob> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int pathUpdateCountdownTicks;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lookTargetPos;
    private float speed;

    public FollowWalkTargetTask(int minRunTime, int maxRunTime) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), TuplesKt.to((Object)MemoryModuleType.PATH, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to((Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryStatus.REGISTERED)};
        super(MapsKt.mapOf((Pair[])pairArray), minRunTime, maxRunTime);
    }

    public /* synthetic */ FollowWalkTargetTask(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 150;
        }
        if ((n3 & 2) != 0) {
            n2 = 250;
        }
        this(n, n2);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PathfinderMob entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.pathUpdateCountdownTicks > 0) {
            this.pathUpdateCountdownTicks += -1;
            return false;
        }
        Brain brain = entity.getBrain();
        Object t = brain.getMemory(MemoryModuleType.WALK_TARGET).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        WalkTarget walkTarget = (WalkTarget)t;
        boolean hasReached = this.hasReached(entity, walkTarget);
        this.resetPathUpdateCountdownTicks(entity);
        if (!hasReached && this.hasFinishedPath(entity, walkTarget, level.getGameTime())) {
            this.lookTargetPos = walkTarget.getTarget().currentBlockPosition();
            return true;
        }
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        if (hasReached) {
            brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        }
        return false;
    }

    public final void resetPathUpdateCountdownTicks(@NotNull PathfinderMob entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.pathUpdateCountdownTicks = entity.getRandom().nextInt(20) + 20;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canStillUse(@NotNull ServerLevel arg, @NotNull PathfinderMob arg2, long l) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        if (this.path == null) return false;
        if (this.lookTargetPos == null) return false;
        Optional optional = arg2.getBrain().getMemory(MemoryModuleType.WALK_TARGET);
        Boolean isTargetSpectator2 = optional.map(arg_0 -> FollowWalkTargetTask.canStillUse$lambda$0((Function1)new Function1<WalkTarget, Boolean>((Object)Companion){

            public final Boolean invoke(WalkTarget p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return com.cobblemon.mod.common.entity.ai.FollowWalkTargetTask$Companion.access$isTargetSpectator((Companion)this.receiver, p0);
            }
        }, arg_0)).orElse(false);
        PathNavigation entityNavigation = arg2.getNavigation();
        if (entityNavigation.isDone()) return false;
        if (!optional.isPresent()) return false;
        Object t = optional.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        if (this.hasReached(arg2, (WalkTarget)t)) return false;
        if (isTargetSpectator2 != false) return false;
        return true;
    }

    protected void stop(@NotNull ServerLevel world, @NotNull PathfinderMob entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        WalkTarget walkTarget = entity.getBrain().getMemory(MemoryModuleType.WALK_TARGET).orElse(null);
        if (walkTarget != null && !this.hasReached(entity, walkTarget) && entity.getNavigation().isStuck()) {
            this.resetPathUpdateCountdownTicks(entity);
        }
        entity.getNavigation().stop();
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getBrain().eraseMemory(MemoryModuleType.PATH);
        this.path = null;
    }

    protected void start(@NotNull ServerLevel arg, @NotNull PathfinderMob entity, long time) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.getBrain().setMemory(MemoryModuleType.PATH, (Object)this.path);
        entity.getNavigation().moveTo(this.path, (double)this.speed);
    }

    protected void tick(@NotNull ServerLevel world, @NotNull PathfinderMob entity, long l) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Path path = entity.getNavigation().getPath();
        Brain brain = entity.getBrain();
        if (this.path != path) {
            this.path = path;
            brain.setMemory(MemoryModuleType.PATH, (Object)path);
        }
        if (path != null && this.lookTargetPos != null) {
            Object t = brain.getMemory(MemoryModuleType.WALK_TARGET).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            WalkTarget walkTarget = (WalkTarget)t;
            BlockPos blockPos = walkTarget.getTarget().currentBlockPosition();
            BlockPos blockPos2 = this.lookTargetPos;
            Intrinsics.checkNotNull((Object)blockPos2);
            if (blockPos.distSqr((Vec3i)blockPos2) > 4.0 && this.hasFinishedPath(entity, walkTarget, world.getGameTime())) {
                this.lookTargetPos = walkTarget.getTarget().currentBlockPosition();
                this.start(world, entity, l);
            }
        }
    }

    private final void withNodeFilter(PathfinderMob entity, Predicate<PathType> nodeFilter, Function0<Unit> block) {
        NodeEvaluator nodeEvaluator = entity.getNavigation().getNodeEvaluator();
        if (nodeEvaluator instanceof OmniPathNodeMaker) {
            ((OmniPathNodeMaker)nodeEvaluator).setNodeFilter(nodeFilter);
            block.invoke();
            ((OmniPathNodeMaker)nodeEvaluator).setNodeFilter(FollowWalkTargetTask::withNodeFilter$lambda$0);
        } else {
            block.invoke();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasFinishedPath(PathfinderMob entity, WalkTarget walkTarget, long time) {
        block8: {
            block7: {
                blockPos = walkTarget.getTarget().currentBlockPosition();
                Intrinsics.checkNotNull((Object)blockPos);
                this.path = this.generatePath(entity, walkTarget, blockPos);
                this.speed = walkTarget.getSpeedModifier();
                brain = entity.getBrain();
                if (!this.hasReached(entity, walkTarget)) break block7;
                brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
                break block8;
            }
            if (this.path == null) ** GOTO lbl-1000
            v0 = this.path;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.canReach()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = bl = false;
            }
            if (bl) {
                brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            } else if (!brain.hasMemoryValue(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)) {
                brain.setMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)time);
            }
            if (this.path != null) {
                return true;
            }
            vec3d = DefaultRandomPos.getPosTowards((PathfinderMob)entity, (int)10, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)((Vec3i)blockPos)), (double)1.5707963267948966);
            if (vec3d != null) {
                v2 = BlockPos.containing((Position)((Position)vec3d));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"containing(...)");
                this.path = this.generatePath(entity, walkTarget, v2);
                return this.path != null;
            }
        }
        return false;
    }

    private final Path generatePath(PathfinderMob entity, WalkTarget walkTarget, BlockPos target) {
        Ref.ObjectRef path = new Ref.ObjectRef();
        if (walkTarget instanceof CobblemonWalkTarget) {
            this.withNodeFilter(entity, arg_0 -> FollowWalkTargetTask.generatePath$lambda$0(((CobblemonWalkTarget)walkTarget).getNodeTypeFilter(), arg_0), (Function0<Unit>)((Function0)() -> FollowWalkTargetTask.generatePath$lambda$1(entity, walkTarget, path)));
        } else {
            path.element = entity.getNavigation().createPath(target, 0);
        }
        return (Path)path.element;
    }

    private final boolean hasReached(PathfinderMob entity, WalkTarget walkTarget) {
        return walkTarget.getTarget().currentBlockPosition().distManhattan((Vec3i)entity.blockPosition()) <= walkTarget.getCloseEnoughDist();
    }

    private static final Boolean canStillUse$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean withNodeFilter$lambda$0(PathType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean generatePath$lambda$0(Function1 $tmp0, PathType p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }

    private static final Unit generatePath$lambda$1(PathfinderMob $entity, WalkTarget $walkTarget, Ref.ObjectRef $path) {
        Path resolvedPath = $entity.getNavigation().createPath(((CobblemonWalkTarget)$walkTarget).getTarget().currentBlockPosition(), 0);
        if (resolvedPath != null) {
            while (true) {
                boolean bl;
                Node node;
                if ((node = resolvedPath.getEndNode()) != null && (node = node.type) != null) {
                    Node it = node;
                    boolean bl2 = false;
                    bl = !((Boolean)((CobblemonWalkTarget)$walkTarget).getDestinationNodeTypeFilter().invoke((Object)it)).booleanValue();
                } else {
                    bl = false;
                }
                if (!bl) break;
                MiscUtilsKt.deleteNode(resolvedPath, resolvedPath.getNodeCount() - 1);
            }
            if (resolvedPath.getNodeCount() == 0) {
                resolvedPath = null;
            }
        }
        $path.element = resolvedPath;
        return Unit.INSTANCE;
    }

    public FollowWalkTargetTask() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/entity/ai/FollowWalkTargetTask$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/ai/memory/WalkTarget;", "target", "", "isTargetSpectator", "(Lnet/minecraft/world/entity/ai/memory/WalkTarget;)Z", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTargetSpectator(WalkTarget target) {
            PositionTracker lookTarget = target.getTarget();
            return lookTarget instanceof EntityTracker ? ((EntityTracker)lookTarget).getEntity().isSpectator() : false;
        }

        public static final /* synthetic */ boolean access$isTargetSpectator(Companion $this, WalkTarget target) {
            return $this.isTargetSpectator(target);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

