/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.ai.CobblemonWalkTarget;
import com.cobblemon.mod.common.entity.ai.FollowHerdLeaderTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.PokemonMoveControl;
import com.cobblemon.mod.common.pokemon.ai.ToleratedHerdLeader;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017R$\u0010\u0019\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u0017R\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u0017\u0010(\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b(\u0010 \u001a\u0004\b)\u0010\"\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/entity/ai/FollowHerdLeaderTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "level", "owner", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "entity", "", "gameTime", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "", "tick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "Lnet/minecraft/world/phys/Vec3;", "getRandomOffset", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/server/level/ServerLevel;)Lnet/minecraft/world/phys/Vec3;", "applySleep", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "removeSleep", "leader", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getLeader", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "setLeader", "", "tooFar", "F", "getTooFar", "()F", "setTooFar", "(F)V", "closeEnough", "getCloseEnough", "setCloseEnough", "chance", "getChance", "common"})
@SourceDebugExtension(value={"SMAP\nFollowHerdLeaderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowHerdLeaderTask.kt\ncom/cobblemon/mod/common/entity/ai/FollowHerdLeaderTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class FollowHerdLeaderTask
extends Behavior<PokemonEntity> {
    @Nullable
    private PokemonEntity leader;
    private float tooFar = 8.0f;
    private float closeEnough = 4.0f;
    private final float chance;

    public FollowHerdLeaderTask() {
        super((Map)ImmutableMap.of(CobblemonMemories.HERD_LEADER, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.chance = 0.016666668f;
    }

    @Nullable
    public final PokemonEntity getLeader() {
        return this.leader;
    }

    public final void setLeader(@Nullable PokemonEntity pokemonEntity) {
        this.leader = pokemonEntity;
    }

    public final float getTooFar() {
        return this.tooFar;
    }

    public final void setTooFar(float f) {
        this.tooFar = f;
    }

    public final float getCloseEnough() {
        return this.closeEnough;
    }

    public final void setCloseEnough(float f) {
        this.closeEnough = f;
    }

    public final float getChance() {
        return this.chance;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PokemonEntity owner) {
        block3: {
            ToleratedHerdLeader definition;
            ToleratedHerdLeader toleratedHerdLeader;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            UUID uUID = owner.getBrain().getMemory(CobblemonMemories.HERD_LEADER).map(arg_0 -> FollowHerdLeaderTask.checkExtraStartConditions$lambda$0(checkExtraStartConditions.1.INSTANCE, arg_0)).orElse(null);
            if (uUID == null) {
                return false;
            }
            Entity entity = level.getEntity(uUID);
            PokemonEntity pokemonEntity = this.leader = entity instanceof PokemonEntity ? (PokemonEntity)entity : null;
            if (pokemonEntity != null) {
                PokemonEntity leader = pokemonEntity;
                boolean bl = false;
                toleratedHerdLeader = owner.getBehaviour().getHerd().bestMatchLeader(owner, leader);
            } else {
                toleratedHerdLeader = null;
            }
            ToleratedHerdLeader toleratedHerdLeader2 = definition = toleratedHerdLeader;
            if (toleratedHerdLeader2 == null) break block3;
            ToleratedHerdLeader it = toleratedHerdLeader2;
            boolean bl = false;
            IntRange intRange = it.getFollowDistance();
            this.tooFar = intRange != null ? intRange.getEndInclusive().intValue() : owner.getBehaviour().getHerd().getFollowDistance().getEndInclusive().intValue();
            IntRange intRange2 = it.getFollowDistance();
            this.closeEnough = intRange2 != null ? intRange2.getStart().intValue() : owner.getBehaviour().getHerd().getFollowDistance().getStart().intValue();
        }
        return this.leader != null;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PokemonEntity entity, long gameTime) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PokemonEntity pokemonEntity = this.leader;
        return (pokemonEntity != null ? pokemonEntity.isAlive() : false) && Intrinsics.areEqual((Object)((object = this.leader) != null && (object = object.getUUID()) != null ? ((UUID)object).toString() : null), entity.getBrain().getMemory(CobblemonMemories.HERD_LEADER).orElse(null));
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PokemonEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PokemonEntity pokemonEntity = this.leader;
        if (pokemonEntity == null) {
            return;
        }
        PokemonEntity leader = pokemonEntity;
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            return;
        }
        MoveControl moveControl = entity.getMoveControl();
        PokemonMoveControl pokemonMoveControl = moveControl instanceof PokemonMoveControl ? (PokemonMoveControl)moveControl : null;
        if (pokemonMoveControl == null) {
            return;
        }
        PokemonMoveControl moveControl2 = pokemonMoveControl;
        MoveControl moveControl3 = leader.getMoveControl();
        PokemonMoveControl pokemonMoveControl2 = moveControl3 instanceof PokemonMoveControl ? (PokemonMoveControl)moveControl3 : null;
        if (pokemonMoveControl2 == null) {
            return;
        }
        PokemonMoveControl leaderMoveControl = pokemonMoveControl2;
        if (leader.distanceTo((Entity)entity) > this.tooFar) {
            this.removeSleep(entity);
            Brain<PokemonEntity> brain = entity.getBrain();
            Vec3 vec3 = leader.position().add(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(vec3), 0.4f, (int)this.closeEnough, null, null, 24, null));
        } else if (leader.isFlying() && !entity.isFlying()) {
            if (!entity.canFly()) {
                entity.getBrain().eraseMemory(CobblemonMemories.HERD_LEADER);
                return;
            }
            this.removeSleep(entity);
            Brain<PokemonEntity> brain = entity.getBrain();
            Vec3 vec3 = leader.position().add(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(vec3), 0.3f, (int)this.closeEnough, null, null, 24, null));
        } else if (leaderMoveControl.getBanking()) {
            this.removeSleep(entity);
            if (leader.isInLiquid() && !entity.isInLiquid()) {
                Brain<PokemonEntity> brain = entity.getBrain();
                Vec3 vec3 = leader.position().add(this.getRandomOffset(entity, level));
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(vec3), 0.4f, 1, null, null, 24, null));
            } else {
                entity.setYRot(leader.getYRot());
                float f = leaderMoveControl.getBankForwardBlocksPerTick();
                float f2 = leaderMoveControl.getBankUpwardsBlocksPerTick();
                moveControl2.startBanking(f, f2, 0.0f, 2);
            }
        } else if (leader.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            if (entity.getRandom().nextFloat() > this.chance) {
                return;
            }
            this.removeSleep(entity);
            WalkTarget walkTarget = leader.getBrain().getMemory(MemoryModuleType.WALK_TARGET).orElse(null);
            if (walkTarget == null) {
                return;
            }
            WalkTarget walkTarget2 = walkTarget;
            if (entity.distanceToSqr(walkTarget2.getTarget().currentPosition()) + (double)this.closeEnough < leader.distanceToSqr(walkTarget2.getTarget().currentPosition())) {
                return;
            }
            Brain<PokemonEntity> brain = entity.getBrain();
            Vec3 vec3 = walkTarget2.getTarget().currentPosition().add(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            moveControl3 = Vec3ExtensionsKt.toBlockPos(vec3);
            float f = walkTarget2.getSpeedModifier();
            Function1 function1 = walkTarget2 instanceof CobblemonWalkTarget ? (Function1)walkTarget2 : null;
            if (function1 == null || (function1 = function1.getNodeTypeFilter()) == null) {
                function1 = FollowHerdLeaderTask::tick$lambda$0;
            }
            Function1 function12 = function1;
            int n = (int)this.closeEnough;
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new CobblemonWalkTarget((BlockPos)moveControl3, f, n, function12, null, 16, null));
        } else if (leader.getCurrentPoseType() == PoseType.SLEEP) {
            BlockPos blockPos = entity.blockPosition().offset(0, -1, 0);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            if (entity.canSleepAt(blockPos) && BrainExtensionsKt.getMemorySafely(entity.getBrain(), CobblemonMemories.POKEMON_DROWSY).orElse(false).booleanValue() && entity.getRandom().nextFloat() < 0.025f) {
                this.applySleep(entity);
            }
        } else if (BrainExtensionsKt.getMemorySafely(entity.getBrain(), CobblemonMemories.POKEMON_SLEEPING).orElse(false).booleanValue() && entity.getRandom().nextFloat() < 0.06666667f) {
            this.removeSleep(entity);
        }
    }

    @NotNull
    public final Vec3 getRandomOffset(@NotNull PokemonEntity entity, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        PokemonEntity pokemonEntity = this.leader;
        if (pokemonEntity == null) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        PokemonEntity leader = pokemonEntity;
        double minRange = this.closeEnough;
        double maxRange = this.tooFar - this.closeEnough / (float)2;
        double randomDistance = Mth.nextDouble((RandomSource)level.random, (double)minRange, (double)maxRange);
        double randomAngle = Mth.nextDouble((RandomSource)level.random, (double)0.0, (double)(Math.PI * 2));
        Vec3 offset = new Vec3(Math.cos(randomAngle) * randomDistance, 0.0, Math.sin(randomAngle) * randomDistance);
        if (entity.isInLiquid() && leader.isInLiquid() || entity.isFlying() && leader.isFlying()) {
            double verticalRange = randomDistance * 0.5;
            double randomY = Mth.nextDouble((RandomSource)level.random, (double)(-verticalRange), (double)verticalRange);
            Vec3 vec3 = offset.add(0.0, randomY, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            offset = vec3;
        }
        return offset;
    }

    public final void applySleep(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.getBrain().setMemory(CobblemonMemories.POKEMON_SLEEPING, (Object)true);
        entity.getPokemon().setStatus(new PersistentStatusContainer(Statuses.SLEEP, 0, 2, null));
    }

    public final void removeSleep(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getBrain().hasMemoryValue(CobblemonMemories.POKEMON_SLEEPING)) {
            entity.getBrain().eraseMemory(CobblemonMemories.POKEMON_SLEEPING);
            PersistentStatusContainer status = entity.getPokemon().getStatus();
            if (status != null && Intrinsics.areEqual((Object)status.getStatus(), (Object)Statuses.SLEEP)) {
                entity.getPokemon().setStatus(null);
            }
        }
    }

    private static final UUID checkExtraStartConditions$lambda$0(Function1 $tmp0, Object p0) {
        return (UUID)$tmp0.invoke(p0);
    }

    private static final boolean tick$lambda$0(PathType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

