/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.data;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBehaviours;
import com.cobblemon.mod.common.CobblemonCallbacks;
import com.cobblemon.mod.common.CobblemonCosmeticItems;
import com.cobblemon.mod.common.CobblemonMechanics;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.CobblemonUnlockableWallpapers;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.berry.Berries;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.data.DataProvider;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.dialogue.Dialogues;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.fishing.PokeRods;
import com.cobblemon.mod.common.api.fishing.SpawnBait;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.api.fossil.Fossils;
import com.cobblemon.mod.common.api.fossil.NaturalMaterials;
import com.cobblemon.mod.common.api.interaction.PokemonInteractions;
import com.cobblemon.mod.common.api.item.HeldItems;
import com.cobblemon.mod.common.api.mark.Marks;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.moves.animations.ActionEffects;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.npc.NPCPresets;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokedex.DexAdditions;
import com.cobblemon.mod.common.api.pokedex.Dexes;
import com.cobblemon.mod.common.api.pokedex.entry.DexEntries;
import com.cobblemon.mod.common.api.pokedex.entry.DexEntryAdditions;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.feature.GlobalSpeciesFeatures;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureAssignments;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.scripting.CobblemonScripts;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnRules;
import com.cobblemon.mod.common.api.spawning.SpawnDetailPresets;
import com.cobblemon.mod.common.battles.BagItems;
import com.cobblemon.mod.common.data.StarterDataLoader;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.cobblemon.mod.common.pokemon.SpeciesAdditions;
import com.cobblemon.mod.common.pokemon.properties.PropertiesCompletionProvider;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J)\u0010\u000b\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0019j\b\u0012\u0004\u0012\u00020\u0006`\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0019j\b\u0012\u0004\u0012\u00020\u0006`\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R,\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u001f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u001e0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/data/CobblemonDataProvider;", "Lcom/cobblemon/mod/common/api/data/DataProvider;", "<init>", "()V", "", "registerDefaults", "Lcom/cobblemon/mod/common/api/data/DataRegistry;", "T", "registry", "", "reloadable", "register", "(Lcom/cobblemon/mod/common/api/data/DataRegistry;Z)Lcom/cobblemon/mod/common/api/data/DataRegistry;", "Lnet/minecraft/resources/ResourceLocation;", "registryIdentifier", "fromIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/data/DataRegistry;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lkotlin/Function0;", "action", "doAfterSync", "(Lnet/minecraft/server/level/ServerPlayer;Lkotlin/jvm/functions/Function0;)V", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "registries", "Ljava/util/LinkedHashSet;", "reloadableRegistries", "", "Ljava/util/UUID;", "synchronizedPlayerIds", "Ljava/util/List;", "", "scheduledActions", "Ljava/util/Map;", "SimpleResourceReloader", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonDataProvider.kt\ncom/cobblemon/mod/common/data/CobblemonDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1#2:172\n1869#3,2:173\n1869#3,2:175\n*S KotlinDebug\n*F\n+ 1 CobblemonDataProvider.kt\ncom/cobblemon/mod/common/data/CobblemonDataProvider\n*L\n144#1:173,2\n151#1:175,2\n*E\n"})
public final class CobblemonDataProvider
implements DataProvider {
    @NotNull
    public static final CobblemonDataProvider INSTANCE = new CobblemonDataProvider();
    @NotNull
    private static final LinkedHashSet<DataRegistry> registries = new LinkedHashSet();
    @NotNull
    private static final LinkedHashSet<DataRegistry> reloadableRegistries = new LinkedHashSet();
    @NotNull
    private static final List<UUID> synchronizedPlayerIds = new ArrayList();
    @NotNull
    private static final Map<UUID, List<Function0<Unit>>> scheduledActions = new LinkedHashMap();

    private CobblemonDataProvider() {
    }

    public final void registerDefaults() {
        this.register((DataRegistry)CobblemonScripts.INSTANCE, true);
        this.register((DataRegistry)SpeciesFeatures.INSTANCE, false);
        this.register((DataRegistry)GlobalSpeciesFeatures.INSTANCE, false);
        this.register((DataRegistry)SpeciesFeatureAssignments.INSTANCE, false);
        this.register((DataRegistry)ActionEffects.INSTANCE, true);
        this.register((DataRegistry)Moves.INSTANCE, false);
        this.register((DataRegistry)Abilities.INSTANCE, false);
        this.register((DataRegistry)CobblemonBehaviours.INSTANCE, false);
        this.register((DataRegistry)PokemonSpecies.INSTANCE, false);
        this.register((DataRegistry)SpeciesAdditions.INSTANCE, false);
        this.register((DataRegistry)PokeBalls.INSTANCE, false);
        this.register((DataRegistry)PropertiesCompletionProvider.INSTANCE, false);
        this.register((DataRegistry)SpawnDetailPresets.INSTANCE, true);
        this.register((DataRegistry)CobblemonSpawnRules.INSTANCE, true);
        this.register((DataRegistry)CobblemonMechanics.INSTANCE, true);
        this.register((DataRegistry)BagItems.INSTANCE, false);
        this.register((DataRegistry)HeldItems.INSTANCE, false);
        this.register((DataRegistry)Dialogues.INSTANCE, true);
        this.register((DataRegistry)NaturalMaterials.INSTANCE, true);
        this.register((DataRegistry)Fossils.INSTANCE, true);
        this.register((DataRegistry)NPCPresets.INSTANCE, false);
        this.register((DataRegistry)NPCClasses.INSTANCE, false);
        this.register((DataRegistry)DexEntries.INSTANCE, false);
        this.register((DataRegistry)DexEntryAdditions.INSTANCE, false);
        this.register((DataRegistry)Dexes.INSTANCE, false);
        this.register((DataRegistry)DexAdditions.INSTANCE, false);
        this.register((DataRegistry)CobblemonCosmeticItems.INSTANCE, true);
        this.register((DataRegistry)CobblemonCallbacks.INSTANCE, true);
        this.register((DataRegistry)CobblemonUnlockableWallpapers.INSTANCE, true);
        this.register((DataRegistry)Marks.INSTANCE, false);
        this.register((DataRegistry)StarterDataLoader.INSTANCE, true);
        CobblemonSpawnPools.INSTANCE.load();
        this.register((DataRegistry)PokeRods.INSTANCE, false);
        this.register((DataRegistry)Berries.INSTANCE, false);
        this.register((DataRegistry)Seasonings.INSTANCE, false);
        this.register((DataRegistry)PokemonInteractions.INSTANCE, false);
        this.register((DataRegistry)SpawnBaitEffects.INSTANCE, false);
        this.register((DataRegistry)CobblemonRideSettings.INSTANCE, true);
        SpawnBait.Effects.INSTANCE.setupEffects();
        Observable.subscribe$default(PlatformEvents.SERVER_PLAYER_LOGOUT, null, CobblemonDataProvider::registerDefaults$lambda$0, 1, null);
        DistributionUtilsKt.ifClient(CobblemonDataProvider::registerDefaults$lambda$1);
        Cobblemon.INSTANCE.getImplementation().registerResourceReloader(MiscUtilsKt.cobblemonResource("data_resources"), (PreparableReloadListener)new SimpleResourceReloader(PackType.SERVER_DATA), PackType.SERVER_DATA, CollectionsKt.emptyList());
    }

    @Override
    @NotNull
    public <T extends DataRegistry> T register(@NotNull T registry, boolean reloadable) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        if (registries.isEmpty()) {
            Cobblemon.LOGGER.info("Note: Cobblemon data registries are only loaded once per server instance as Pok\u00e9mon species are not safe to reload.");
        }
        registries.add(registry);
        if (reloadable) {
            reloadableRegistries.add(registry);
        }
        Cobblemon.LOGGER.info("Registered the {} registry", (Object)registry.getId().toString());
        Cobblemon.LOGGER.debug("Registered the {} registry of class {}", (Object)registry.getId().toString(), (Object)Reflection.getOrCreateKotlinClass(registry.getClass()).getQualifiedName());
        return registry;
    }

    @Override
    @Nullable
    public DataRegistry fromIdentifier(@NotNull ResourceLocation registryIdentifier) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)registryIdentifier, (String)"registryIdentifier");
            Iterable iterable = registries;
            for (Object t : iterable) {
                DataRegistry it = (DataRegistry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)registryIdentifier)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        ServerPlayer[] $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.connection.connection.isMemoryConnection()) {
            $this$forEach$iv = (ServerPlayer[])registries;
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                DataRegistry registry = (DataRegistry)t;
                boolean bl = false;
                registry.sync(player);
            }
        }
        $this$forEach$iv = new ServerPlayer[]{player};
        CobblemonEvents.DATA_SYNCHRONIZED.emit((ServerPlayer[])$this$forEach$iv);
        List<Function0<Unit>> list = scheduledActions.remove(player.getUUID());
        if (list == null) {
            return;
        }
        List<Function0<Unit>> waitingActions = list;
        Iterable $this$forEach$iv2 = waitingActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @Override
    public void doAfterSync(@NotNull ServerPlayer player, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (synchronizedPlayerIds.contains(player.getUUID())) {
            action.invoke();
        } else {
            scheduledActions.computeIfAbsent(player.getUUID(), arg_0 -> CobblemonDataProvider.doAfterSync$lambda$1(CobblemonDataProvider::doAfterSync$lambda$0, arg_0)).add(action);
        }
    }

    private static final Unit registerDefaults$lambda$0(ServerPlayerEvent.Logout it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        synchronizedPlayerIds.remove(it.getPlayer().getUUID());
        return Unit.INSTANCE;
    }

    private static final void registerDefaults$lambda$1() {
        Cobblemon.INSTANCE.getImplementation().registerResourceReloader(MiscUtilsKt.cobblemonResource("client_resources"), (PreparableReloadListener)new SimpleResourceReloader(PackType.CLIENT_RESOURCES), PackType.CLIENT_RESOURCES, CollectionsKt.emptyList());
    }

    private static final List doAfterSync$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List doAfterSync$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/data/CobblemonDataProvider$SimpleResourceReloader;", "Lnet/minecraft/server/packs/resources/ResourceManagerReloadListener;", "Lnet/minecraft/server/packs/PackType;", "type", "<init>", "(Lnet/minecraft/server/packs/PackType;)V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "", "onResourceManagerReload", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Lnet/minecraft/server/packs/PackType;", "common"})
    @SourceDebugExtension(value={"SMAP\nCobblemonDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonDataProvider.kt\ncom/cobblemon/mod/common/data/CobblemonDataProvider$SimpleResourceReloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n774#2:172\n865#2,2:173\n1869#2,2:175\n*S KotlinDebug\n*F\n+ 1 CobblemonDataProvider.kt\ncom/cobblemon/mod/common/data/CobblemonDataProvider$SimpleResourceReloader\n*L\n166#1:172\n166#1:173,2\n167#1:175,2\n*E\n"})
    private static final class SimpleResourceReloader
    implements ResourceManagerReloadListener {
        @NotNull
        private final PackType type;

        public SimpleResourceReloader(@NotNull PackType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
        }

        /*
         * WARNING - void declaration
         */
        public void onResourceManagerReload(@NotNull ResourceManager manager) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            boolean reloadAllowed = !(minecraftServer != null ? minecraftServer.isReady() : false);
            Iterable $this$filter$iv = registries;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DataRegistry it = (DataRegistry)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == this.type && (reloadAllowed || reloadableRegistries.contains(it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataRegistry it = (DataRegistry)element$iv;
                boolean bl = false;
                it.reload(manager);
            }
        }
    }
}

