/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/SpawnPokemon;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/world/phys/Vec3;)I", "", "NAME", "Ljava/lang/String;", "PROPERTIES", "POSITION", "ALIAS", "AT_NAME", "AT_ALIAS", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "NO_SPECIES_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "INVALID_POS_EXCEPTION", "FAILED_SPAWN_EXCEPTION", "common"})
public final class SpawnPokemon {
    @NotNull
    public static final SpawnPokemon INSTANCE = new SpawnPokemon();
    @NotNull
    private static final String NAME = "spawnpokemon";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String POSITION = "pos";
    @NotNull
    private static final String ALIAS = "pokespawn";
    @NotNull
    private static final String AT_NAME = "spawnpokemonat";
    @NotNull
    private static final String AT_ALIAS = "pokespawnat";
    @NotNull
    private static final SimpleCommandExceptionType NO_SPECIES_EXCEPTION;
    @NotNull
    private static final SimpleCommandExceptionType INVALID_POS_EXCEPTION;
    @NotNull
    private static final SimpleCommandExceptionType FAILED_SPAWN_EXCEPTION;

    private SpawnPokemon() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode contextPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getSPAWN_POKEMON(), false, 2, null)).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(SpawnPokemon::register$lambda$0)));
        Intrinsics.checkNotNull((Object)contextPositionCommand);
        dispatcher.register(CommandUtilsKt.alias(contextPositionCommand, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)AT_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        LiteralCommandNode argumentPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.getSPAWN_POKEMON(), false, 2, null)).then(Commands.argument((String)POSITION, (ArgumentType)((ArgumentType)Vec3Argument.vec3())).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(SpawnPokemon::register$lambda$1))));
        Intrinsics.checkNotNull((Object)argumentPositionCommand);
        dispatcher.register(CommandUtilsKt.alias(argumentPositionCommand, AT_ALIAS));
    }

    private final int execute(CommandContext<CommandSourceStack> context, Vec3 pos) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos blockPos = Vec3ExtensionsKt.toBlockPos(pos);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            CommandSyntaxException commandSyntaxException = INVALID_POS_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, PROPERTIES);
        if (properties.getSpecies() == null) {
            CommandSyntaxException commandSyntaxException = NO_SPECIES_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        try {
            Intrinsics.checkNotNull((Object)world);
            PokemonEntity pokemonEntity = PokemonProperties.createEntity$default(properties, (Level)world, null, 2, null);
            pokemonEntity.moveTo(pos.x, pos.y, pos.z, pokemonEntity.getYRot(), pokemonEntity.getXRot());
            pokemonEntity.getEntityData().set(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.getRandom().nextFloat() * 360.0f));
            pokemonEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(blockPos), MobSpawnType.COMMAND, null);
            if (world.addFreshEntity((Entity)pokemonEntity)) {
                return 1;
            }
            CommandSyntaxException commandSyntaxException = FAILED_SPAWN_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandSyntaxException commandSyntaxException = FAILED_SPAWN_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = ((CommandSourceStack)context.getSource()).getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3);
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = Vec3Argument.getVec3((CommandContext)context, (String)POSITION);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getVec3(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3);
    }

    static {
        MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("spawnpokemon.nospecies", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
        NO_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent));
        MutableComponent mutableComponent2 = Component.literal((String)"Invalid position");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        INVALID_POS_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent2));
        MutableComponent mutableComponent3 = Component.literal((String)"Unable to spawn at the given position");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"literal(...)");
        FAILED_SPAWN_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent3));
    }
}

