/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.net.messages.client.SetClientPlayerDataPacket;
import com.cobblemon.mod.common.net.messages.client.storage.party.InitializePartyPacket;
import com.cobblemon.mod.common.net.messages.client.storage.pc.InitializePCPacket;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0011\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00158\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/command/PokemonRestartCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "resetStarters", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;Z)I", "resetPlayerPokemonData", "(Lnet/minecraft/server/level/ServerPlayer;Z)V", "", "NAME", "Ljava/lang/String;", "NAME_OTHER", "PLAYER", "STARTERS", "ALIAS", "ALIAS_OTHER", "common"})
public final class PokemonRestartCommand {
    @NotNull
    public static final PokemonRestartCommand INSTANCE = new PokemonRestartCommand();
    @NotNull
    private static final String NAME = "pokemonrestart";
    @NotNull
    private static final String NAME_OTHER = "pokemonrestartother";
    @NotNull
    private static final String PLAYER = "player";
    @NotNull
    private static final String STARTERS = "reset_starters";
    @NotNull
    private static final String ALIAS = "pokerestart";
    @NotNull
    private static final String ALIAS_OTHER = "pokerestartother";

    private PokemonRestartCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode selfCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getPOKEMON_EDIT_SELF(), false, 2, null)).then(Commands.argument((String)STARTERS, (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(PokemonRestartCommand::register$lambda$0)));
        Intrinsics.checkNotNull((Object)selfCommand);
        dispatcher.register(CommandUtilsKt.alias(selfCommand, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)NAME_OTHER);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        LiteralCommandNode otherCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.getPOKEMON_EDIT_OTHER(), false, 2, null)).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)STARTERS, (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(PokemonRestartCommand::register$lambda$1))));
        Intrinsics.checkNotNull((Object)otherCommand);
        dispatcher.register(CommandUtilsKt.alias(otherCommand, ALIAS_OTHER));
        LiteralArgumentBuilder literalArgumentBuilder3 = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder3, (String)"literal(...)");
        LiteralCommandNode selfCommandWithoutStarters = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder3, CobblemonPermissions.getPOKEMON_EDIT_SELF(), false, 2, null)).executes(PokemonRestartCommand::register$lambda$2));
        Intrinsics.checkNotNull((Object)selfCommandWithoutStarters);
        dispatcher.register(CommandUtilsKt.alias(selfCommandWithoutStarters, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder4 = Commands.literal((String)NAME_OTHER);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder4, (String)"literal(...)");
        LiteralCommandNode otherCommandWithoutStarters = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder4, CobblemonPermissions.getPOKEMON_EDIT_OTHER(), false, 2, null)).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).executes(PokemonRestartCommand::register$lambda$3)));
        Intrinsics.checkNotNull((Object)otherCommandWithoutStarters);
        dispatcher.register(CommandUtilsKt.alias(otherCommandWithoutStarters, ALIAS_OTHER));
    }

    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player, boolean resetStarters) {
        this.resetPlayerPokemonData(player, resetStarters);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PokemonRestartCommand.execute$lambda$0(player), true);
        return 1;
    }

    private final void resetPlayerPokemonData(ServerPlayer player, boolean resetStarters) {
        PlayerExtensionsKt.party(player).clearParty();
        PlayerExtensionsKt.pc(player).clearPC();
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        CobblemonNetwork.INSTANCE.sendPacket(player, new InitializePartyPacket(true, uUID, PlayerExtensionsKt.party(player).size()));
        UUID uUID2 = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        CobblemonNetwork.INSTANCE.sendPacket(player, new InitializePCPacket(uUID2, PlayerExtensionsKt.pc(player).getBoxes().size(), false));
        GeneralPlayerData playerData = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
        playerData.setStarterPrompted(false);
        playerData.setStarterLocked(false);
        playerData.setStarterSelected(!resetStarters);
        CobblemonNetwork.INSTANCE.sendPacket(player, new SetClientPlayerDataPacket(PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL(), playerData.toClientData(), false, 4, null));
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer, BoolArgumentType.getBool((CommandContext)it, (String)STARTERS));
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer, BoolArgumentType.getBool((CommandContext)it, (String)STARTERS));
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer, false);
    }

    private static final int register$lambda$3(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer, false);
    }

    private static final Component execute$lambda$0(ServerPlayer $player) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$player.getName(), (String)"getName(...)");
        return (Component)LocalizationUtilsKt.commandLang(NAME, objectArray);
    }
}

