/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.settings.ServerSettings;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.net.messages.client.storage.RemoveClientPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ?\u0010\u0013\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R(\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u001c\u0010\u001b\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/PokeboxCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemons", "", "box", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/Collection;Ljava/lang/Integer;)I", "Lkotlin/Function1;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "BOX_DOES_NOT_EXIST", "Lkotlin/jvm/functions/Function1;", "BOX_IS_FULL_EXCEPTION", "STORAGE_IS_FULL_EXCEPTION", "Lnet/minecraft/network/chat/MutableComponent;", "LAST_POKE_MESSAGE", "common"})
@SourceDebugExtension(value={"SMAP\nPokeboxCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1869#2,2:135\n*S KotlinDebug\n*F\n+ 1 PokeboxCommand.kt\ncom/cobblemon/mod/common/command/PokeboxCommand\n*L\n103#1:135,2\n*E\n"})
public final class PokeboxCommand {
    @NotNull
    public static final PokeboxCommand INSTANCE = new PokeboxCommand();
    @NotNull
    private static final Function1<Integer, MutableComponent> BOX_DOES_NOT_EXIST = PokeboxCommand::BOX_DOES_NOT_EXIST$lambda$0;
    @NotNull
    private static final Function1<Integer, MutableComponent> BOX_IS_FULL_EXCEPTION = PokeboxCommand::BOX_IS_FULL_EXCEPTION$lambda$0;
    private static final MutableComponent STORAGE_IS_FULL_EXCEPTION = LocalizationUtilsKt.commandLang("pokebox.storage_is_full", new Object[0]);
    private static final MutableComponent LAST_POKE_MESSAGE = LocalizationUtilsKt.commandLang("pokebox.last_pokemon", new Object[0]);

    private PokeboxCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"pokebox");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getPOKEBOX(), false, 2, null)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(((RequiredArgumentBuilder)Commands.argument((String)"slot", (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$0))).executes(PokeboxCommand::register$lambda$1))));
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)"pokeboxall");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.getPOKEBOX(), false, 2, null)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(PokeboxCommand::register$lambda$2))).executes(PokeboxCommand::register$lambda$3)));
    }

    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player, Collection<? extends Pokemon> pokemons, Integer box) {
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        PlayerPartyStore playerParty = PlayerExtensionsKt.party(player);
        if (box != null) {
            if (playerPc.getBoxes().size() < box) {
                Object object = BOX_DOES_NOT_EXIST.invoke((Object)box);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            PCBox pcBox = playerPc.getBoxes().get(box - 1);
            if (pcBox.getUnoccupiedSlots() < pokemons.size()) {
                Object object = BOX_IS_FULL_EXCEPTION.invoke((Object)box);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)pokemons);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCPosition pCPosition;
            Pokemon pokemon = (Pokemon)element$iv;
            boolean bl = false;
            if (ServerSettings.INSTANCE.getPreventCompletePartyDeposit() && playerParty.occupied() == 1) {
                ((CommandSourceStack)context.getSource()).sendSuccess(PokeboxCommand::execute$lambda$0$0, false);
                return pokemons.size() - 1;
            }
            if (box == null) {
                pCPosition = playerPc.getFirstAvailablePosition();
                if (pCPosition == null) {
                    MutableComponent mutableComponent = STORAGE_IS_FULL_EXCEPTION;
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"STORAGE_IS_FULL_EXCEPTION");
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent)).create();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                    throw (Throwable)commandSyntaxException;
                }
            } else {
                PCBox pcBox = playerPc.getBoxes().get(box - 1);
                pCPosition = pcBox.getFirstAvailablePosition();
                if (pCPosition == null) {
                    Object object = BOX_IS_FULL_EXCEPTION.invoke((Object)box);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                    throw (Throwable)commandSyntaxException;
                }
            }
            PCPosition pcPosition = pCPosition;
            playerParty.remove(pokemon);
            playerPc.set(pcPosition, pokemon);
            PokemonStore pokemonStore = PlayerExtensionsKt.party(player);
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            playerParty.sendPacketToObservers(new RemoveClientPokemonPacket(pokemonStore, uUID));
        }
        return pokemons.size();
    }

    static /* synthetic */ int execute$default(PokeboxCommand pokeboxCommand, CommandContext commandContext, ServerPlayer serverPlayer, Collection collection, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return pokeboxCommand.execute((CommandContext<CommandSourceStack>)commandContext, serverPlayer, collection, n);
    }

    private static final MutableComponent BOX_DOES_NOT_EXIST$lambda$0(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_does_not_exist", objectArray);
    }

    private static final MutableComponent BOX_IS_FULL_EXCEPTION$lambda$0(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_is_full", objectArray);
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, player, CollectionsKt.listOf((Object)pokemon), box);
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, "slot", player);
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.listOf((Object)pokemon), null, 8, null);
    }

    private static final int register$lambda$2(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, player, CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player)), box);
    }

    private static final int register$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        Intrinsics.checkNotNull((Object)player);
        return PokeboxCommand.execute$default(INSTANCE, context, player, CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player)), null, 8, null);
    }

    private static final Component execute$lambda$0$0() {
        MutableComponent mutableComponent = LAST_POKE_MESSAGE;
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"LAST_POKE_MESSAGE");
        return (Component)TextKt.red(mutableComponent);
    }
}

