/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.dialogue.Dialogue;
import com.cobblemon.mod.common.api.dialogue.Dialogues;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.DialogueArgumentType;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/command/OpenDialogueCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "source", "Lnet/minecraft/resources/ResourceLocation;", "dialogueId", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerPlayer;)I", "common"})
public final class OpenDialogueCommand {
    @NotNull
    public static final OpenDialogueCommand INSTANCE = new OpenDialogueCommand();

    private OpenDialogueCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"opendialogue");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getOPEN_DIALOGUE(), false, 2, null)).then(Commands.argument((String)"dialogue", (ArgumentType)DialogueArgumentType.Companion.dialogue()).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(OpenDialogueCommand::register$lambda$0))));
        Intrinsics.checkNotNull((Object)command);
        dispatcher.register(CommandUtilsKt.alias(command, "opendialogue"));
    }

    private final int execute(CommandSourceStack source, ResourceLocation dialogueId, ServerPlayer player) {
        Dialogue dialogue = Dialogues.INSTANCE.getDialogues().get(dialogueId);
        if (dialogue == null) {
            OpenDialogueCommand $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            source.sendSystemMessage((Component)TextKt.text("Invalid dialogue ID: " + dialogueId));
            return 1;
        }
        Dialogue dialogue2 = dialogue;
        try {
            PlayerExtensionsKt.openDialogue(player, dialogue2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ResourceLocation dialogueId = DialogueArgumentType.Companion.getDialogue(it, "dialogue");
        if (!Dialogues.INSTANCE.getDialogues().containsKey(dialogueId)) {
            ((CommandSourceStack)it.getSource()).sendFailure((Component)TextKt.text("Invalid dialogue: " + dialogueId));
            return 1;
        }
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)it, (String)"player");
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.execute(commandSourceStack, dialogueId, player);
    }
}

