/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/command/GiveAllPokemon;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lkotlin/ranges/IntRange;", "range", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lkotlin/ranges/IntRange;)I", "common"})
@SourceDebugExtension(value={"SMAP\nGiveAllPokemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GiveAllPokemon.kt\ncom/cobblemon/mod/common/command/GiveAllPokemon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1056#2:56\n*S KotlinDebug\n*F\n+ 1 GiveAllPokemon.kt\ncom/cobblemon/mod/common/command/GiveAllPokemon\n*L\n45#1:56\n*E\n"})
public final class GiveAllPokemon {
    @NotNull
    public static final GiveAllPokemon INSTANCE = new GiveAllPokemon();

    private GiveAllPokemon() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"giveallpokemon");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.requiresWithPermission((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getGIVE_ALL_POKEMON(), (Function1<? super CommandSourceStack, Boolean>)((Function1)GiveAllPokemon::register$lambda$0))).then(((RequiredArgumentBuilder)Commands.argument((String)"min", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(Commands.argument((String)"max", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(GiveAllPokemon::register$lambda$1))).executes(GiveAllPokemon::register$lambda$2))).executes(GiveAllPokemon::register$lambda$3));
    }

    private final int execute(CommandContext<CommandSourceStack> context, IntRange range) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        PlayerPartyStore playerPartyStore = PlayerExtensionsKt.party(player);
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        PCStore pCStore = playerPartyStore.getOverflowPC(registryAccess);
        if (pCStore == null) {
            return 0;
        }
        PCStore pc = pCStore;
        Iterable $this$sortedBy$iv = PokemonSpecies.getImplemented();
        boolean $i$f$sortedBy = false;
        List orderedSpeces = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Species it = (Species)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getNationalPokedexNumber());
                it = (Species)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getNationalPokedexNumber()));
            }
        });
        for (Species species : orderedSpeces) {
            Pokemon pokemon = Species.create$default(species, 0, 1, null);
            UUID uUID = player.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            pokemon.setOriginalTrainer(uUID);
            pc.add(pokemon);
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayer() != null;
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(IntegerArgumentType.getInteger((CommandContext)it, (String)"min"), IntegerArgumentType.getInteger((CommandContext)it, (String)"max")));
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(IntegerArgumentType.getInteger((CommandContext)it, (String)"min"), Integer.MAX_VALUE));
    }

    private static final int register$lambda$3(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(1, Integer.MAX_VALUE));
    }
}

