/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ5\u0010\u0017\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018JC\u0010\u001c\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/command/ChangePCBoxesCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "executeQuery", "(Lcom/mojang/brigadier/context/CommandContext;)I", "executeAdd", "executeRemove", "executeSet", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "playerPc", "amount", "set", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/storage/pc/PCStore;I)V", "", "Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "emptyBoxes", "remove", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/storage/pc/PCStore;ILjava/util/List;)V", "", "NAME", "Ljava/lang/String;", "common"})
@SourceDebugExtension(value={"SMAP\nChangePCBoxesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangePCBoxesCommand.kt\ncom/cobblemon/mod/common/command/ChangePCBoxesCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n774#2:139\n865#2,2:140\n774#2:142\n865#2,2:143\n*S KotlinDebug\n*F\n+ 1 ChangePCBoxesCommand.kt\ncom/cobblemon/mod/common/command/ChangePCBoxesCommand\n*L\n76#1:139\n76#1:140,2\n101#1:142\n101#1:143,2\n*E\n"})
public final class ChangePCBoxesCommand {
    @NotNull
    public static final ChangePCBoxesCommand INSTANCE = new ChangePCBoxesCommand();
    @NotNull
    private static final String NAME = "boxcount";

    private ChangePCBoxesCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getCHANGE_BOX_COUNT(), false, 2, null)).then(Commands.literal((String)"query").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(this::executeQuery)))).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)1000))).executes(this::executeAdd))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)1000))).executes(this::executeRemove))))).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)1000))).executes(this::executeSet)))));
    }

    private final int executeQuery(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((EntitySelector)context.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)context.getSource());
        Intrinsics.checkNotNull((Object)player);
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)player.getName(), (String)"getName(...)");
        objectArray[1] = playerPc.getBoxes().size();
        commandSourceStack.sendSystemMessage((Component)LocalizationUtilsKt.lang("command.boxcount", objectArray));
        return 1;
    }

    private final int executeAdd(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((EntitySelector)context.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)context.getSource());
        Intrinsics.checkNotNull((Object)player);
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        Integer amount = (Integer)context.getArgument("amount", Integer.TYPE);
        int n = playerPc.getBoxes().size();
        Intrinsics.checkNotNull((Object)amount);
        PCStore.resize$default(playerPc, n + amount, true, null, 4, null);
        playerPc.sendTo(player);
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)player.getName(), (String)"getName(...)");
        objectArray[1] = playerPc.getBoxes().size();
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        commandSourceStack.sendSystemMessage((Component)TextKt.green(mutableComponent));
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int executeRemove(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((EntitySelector)context.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)context.getSource());
        Intrinsics.checkNotNull((Object)player);
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        Integer amount = (Integer)context.getArgument("amount", Integer.TYPE);
        if (amount < playerPc.getBoxes().size()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = playerPc.getBoxes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PCBox it = (PCBox)element$iv$iv;
                boolean bl = false;
                if (!it.getNonEmptySlots().isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List emptyBoxes = (List)destination$iv$iv;
            if (emptyBoxes.size() >= amount) {
                Intrinsics.checkNotNull((Object)amount);
                this.remove(context, player, playerPc, amount, emptyBoxes);
                return 1;
            }
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount.removing_not_empty_box", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            MutableComponent mutableComponent2 = TextKt.red(mutableComponent).append("\n");
            MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("command.changeboxcount.force_remove", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
            commandSourceStack.sendSystemMessage((Component)mutableComponent2.append((Component)TextKt.onClick(TextKt.gray(mutableComponent3), true, (Function1<? super ServerPlayer, Unit>)((Function1)arg_0 -> ChangePCBoxesCommand.executeRemove$lambda$1(context, player, playerPc, amount, emptyBoxes, arg_0)))));
            return 0;
        }
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)player.getName(), (String)"getName(...)");
        objectArray[1] = playerPc.getBoxes().size();
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount.removing_too_many_boxes", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        commandSourceStack.sendSystemMessage((Component)TextKt.red(mutableComponent));
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int executeSet(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((EntitySelector)context.getArgument("player", EntitySelector.class)).findSinglePlayer((CommandSourceStack)context.getSource());
        Intrinsics.checkNotNull((Object)player);
        PCStore playerPc = PlayerExtensionsKt.pc(player);
        Integer amount = (Integer)context.getArgument("amount", Integer.TYPE);
        if (amount < playerPc.getBoxes().size()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = playerPc.getBoxes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PCBox it = (PCBox)element$iv$iv;
                boolean bl = false;
                if (!it.getNonEmptySlots().isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List emptyBoxes = (List)destination$iv$iv;
            int n = playerPc.getBoxes().size();
            Intrinsics.checkNotNull((Object)amount);
            int deleteAmount = n - amount;
            if (emptyBoxes.size() <= deleteAmount) {
                CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
                MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount.removing_not_empty_box", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
                MutableComponent mutableComponent2 = TextKt.red(mutableComponent).append("\n");
                MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("command.changeboxcount.force_remove", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
                commandSourceStack.sendSystemMessage((Component)mutableComponent2.append((Component)TextKt.onClick(TextKt.gray(mutableComponent3), true, (Function1<? super ServerPlayer, Unit>)((Function1)arg_0 -> ChangePCBoxesCommand.executeSet$lambda$1(context, player, playerPc, deleteAmount, emptyBoxes, arg_0)))));
                return 0;
            }
            this.remove(context, player, playerPc, deleteAmount, emptyBoxes);
            return 1;
        }
        Intrinsics.checkNotNull((Object)amount);
        this.set(context, player, playerPc, amount);
        return 1;
    }

    private final void set(CommandContext<CommandSourceStack> context, ServerPlayer player, PCStore playerPc, int amount) {
        PCStore.resize$default(playerPc, amount, true, null, 4, null);
        playerPc.sendTo(player);
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)player.getName(), (String)"getName(...)");
        objectArray[1] = playerPc.getBoxes().size();
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        commandSourceStack.sendSystemMessage((Component)TextKt.green(mutableComponent));
    }

    private final void remove(CommandContext<CommandSourceStack> context, ServerPlayer player, PCStore playerPc, int amount, List<? extends PCBox> emptyBoxes) {
        if (amount <= emptyBoxes.size()) {
            PCStore.removeListOfBoxes$default(playerPc, CollectionsKt.takeLast(emptyBoxes, (int)amount), true, null, 4, null);
        } else {
            List slicedBoxes = CollectionsKt.plus((Collection)emptyBoxes, (Iterable)CollectionsKt.takeLast(playerPc.getBoxes(), (int)(amount - emptyBoxes.size())));
            PCStore.removeListOfBoxes$default(playerPc, slicedBoxes, true, null, 4, null);
        }
        playerPc.initialize();
        playerPc.sendTo(player);
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)player.getName(), (String)"getName(...)");
        objectArray[1] = playerPc.getBoxes().size();
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("command.changeboxcount", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        commandSourceStack.sendSystemMessage((Component)TextKt.green(mutableComponent));
    }

    private static final Unit executeRemove$lambda$1(CommandContext $context, ServerPlayer $player, PCStore $playerPc, Integer $amount, List $emptyBoxes, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$player);
        Intrinsics.checkNotNull((Object)$amount);
        INSTANCE.remove((CommandContext<CommandSourceStack>)$context, $player, $playerPc, $amount, $emptyBoxes);
        return Unit.INSTANCE;
    }

    private static final Unit executeSet$lambda$1(CommandContext $context, ServerPlayer $player, PCStore $playerPc, int $deleteAmount, List $emptyBoxes, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$player);
        INSTANCE.remove((CommandContext<CommandSourceStack>)$context, $player, $playerPc, $deleteAmount, $emptyBoxes);
        return Unit.INSTANCE;
    }
}

