/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.npc;

import com.cobblemon.mod.common.api.entity.NPCSideDelegate;
import com.cobblemon.mod.common.client.entity.NPCClientDelegate;
import com.cobblemon.mod.common.client.render.item.HeldItemRenderer;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableEntityModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.npc.PosableNPCModel;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u001b\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/client/render/npc/NPCRenderer;", "Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableEntityModel;", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "entity", "Lnet/minecraft/resources/ResourceLocation;", "getTextureLocation", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;)Lnet/minecraft/resources/ResourceLocation;", "livingEntity", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "", "partialTickTime", "", "scale", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;Lcom/mojang/blaze3d/vertex/PoseStack;F)V", "entityYaw", "partialTicks", "poseMatrix", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "packedLight", "render", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "", "shouldShowName", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;)Z", "Lcom/cobblemon/mod/common/client/render/item/HeldItemRenderer;", "heldItemRenderer", "Lcom/cobblemon/mod/common/client/render/item/HeldItemRenderer;", "common"})
public final class NPCRenderer
extends LivingEntityRenderer<NPCEntity, PosableEntityModel<NPCEntity>> {
    @NotNull
    private final HeldItemRenderer heldItemRenderer;

    public NPCRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, (EntityModel)new PosableNPCModel(), 0.5f);
        this.heldItemRenderer = new HeldItemRenderer();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull NPCEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ResourceLocation resourceLocation = entity.getResourceIdentifier();
        NPCSideDelegate nPCSideDelegate = entity.getDelegate();
        Intrinsics.checkNotNull((Object)nPCSideDelegate, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.entity.NPCClientDelegate");
        return VaryingModelRepository.INSTANCE.getTexture(resourceLocation, (NPCClientDelegate)nPCSideDelegate);
    }

    protected void scale(@NotNull NPCEntity livingEntity, @NotNull PoseStack poseStack, float partialTickTime) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        poseStack.scale(livingEntity.getRenderScale(), livingEntity.getRenderScale(), livingEntity.getRenderScale());
    }

    public void render(@NotNull NPCEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseMatrix, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseMatrix, (String)"poseMatrix");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Set<String> aspects2 = entity.getAspects();
        NPCSideDelegate nPCSideDelegate = entity.getDelegate();
        Intrinsics.checkNotNull((Object)nPCSideDelegate, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.entity.NPCClientDelegate");
        NPCClientDelegate clientDelegate = (NPCClientDelegate)nPCSideDelegate;
        clientDelegate.setCurrentAspects(aspects2);
        this.shadowRadius = (float)Math.min(entity.getBoundingBox().maxX - entity.getBoundingBox().minX, entity.getBoundingBox().maxZ - entity.getBoundingBox().minZ) / 1.5f;
        PosableModel model = VaryingModelRepository.INSTANCE.getPoser(entity.getResourceIdentifier(), clientDelegate);
        ((PosableEntityModel)this.model).setPosableModel(model);
        model.setContext(((PosableEntityModel)this.model).getContext());
        ((PosableEntityModel)this.model).setupEntityTypeContext((Entity)entity);
        ((PosableEntityModel)this.model).getContext().put(RenderContext.Companion.getTEXTURE(), this.getTextureLocation(entity));
        clientDelegate.updatePartialTicks(partialTicks);
        model.setLayerContext(buffer, clientDelegate, VaryingModelRepository.INSTANCE.getLayers(entity.getResourceIdentifier(), clientDelegate));
        poseMatrix.pushPose();
        poseMatrix.scale(entity.getNpc().getModelScale(), entity.getNpc().getModelScale(), entity.getNpc().getModelScale());
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseMatrix, buffer, packedLight);
        poseMatrix.popPose();
        model.setRed(1.0f);
        model.setGreen(1.0f);
        model.setBlue(1.0f);
        model.resetLayerContext();
        if (entity.deathTime < 1) {
            ItemStack itemStack = entity.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            this.heldItemRenderer.renderOnModel(itemStack, clientDelegate, poseMatrix, buffer, packedLight, false, (LivingEntity)entity);
        }
    }

    protected boolean shouldShowName(@NotNull NPCEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.getHideNameTag()) {
            return false;
        }
        return super.shouldShowName((LivingEntity)entity);
    }
}

