/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.item;

import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.client.entity.NPCClientDelegate;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J]\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/client/render/item/HeldItemRenderer;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "item", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "", "frontLight", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "", "renderOnModel", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IZLnet/minecraft/world/entity/LivingEntity;)V", "seed", "", "targetLocator", "renderAtLocator", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lnet/minecraft/world/entity/LivingEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IIZLjava/lang/String;)V", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "Lnet/minecraft/world/item/ItemDisplayContext;", "displayContext", "Lnet/minecraft/world/item/ItemDisplayContext;", "Companion", "common"})
public final class HeldItemRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemRenderer itemRenderer;
    @NotNull
    private ItemDisplayContext displayContext;
    @NotNull
    public static final String ITEM_FACE = "item_face";
    @NotNull
    public static final String ITEM_HAT = "item_hat";
    @NotNull
    public static final String ITEM = "item";

    public HeldItemRenderer() {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
        this.displayContext = ItemDisplayContext.FIXED;
    }

    public final void renderOnModel(@NotNull ItemStack item, @NotNull PosableState state, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, boolean frontLight, @Nullable LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)item, (String)ITEM);
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!item.is(CobblemonItemTags.HIDDEN_ITEMS)) {
            HeldItemRenderer.renderAtLocator$default(this, item, state, entity, poseStack, buffer, light, 0, frontLight, null, 256, null);
        }
        for (Map.Entry<String, ItemStack> entry : state.getAnimationItems().entrySet()) {
            String targetLocator = entry.getKey();
            ItemStack item2 = entry.getValue();
            this.renderAtLocator(item2, state, entity, poseStack, buffer, light, 0, frontLight, targetLocator);
        }
    }

    public static /* synthetic */ void renderOnModel$default(HeldItemRenderer heldItemRenderer, ItemStack itemStack, PosableState posableState, PoseStack poseStack, MultiBufferSource multiBufferSource, int n, boolean bl, LivingEntity livingEntity, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = LightTexture.pack((int)11, (int)7);
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            livingEntity = null;
        }
        heldItemRenderer.renderOnModel(itemStack, posableState, poseStack, multiBufferSource, n, bl, livingEntity);
    }

    private final void renderAtLocator(ItemStack item, PosableState state, LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int light, int seed, boolean frontLight, String targetLocator) {
        if (item.isEmpty() || !state.getLocatorStates().containsKey(targetLocator)) {
            return;
        }
        poseStack.pushPose();
        RenderSystem.applyModelViewMatrix();
        PosableModel posableModel = state.getCurrentModel();
        if (posableModel == null || (posableModel = posableModel.getLocatorDisplayContext(targetLocator)) == null) {
            posableModel = item.is(CobblemonItemTags.WEARABLE_FACE_ITEMS) && Intrinsics.areEqual((Object)targetLocator, (Object)ITEM_FACE) || item.is(CobblemonItemTags.WEARABLE_HAT_ITEMS) && Intrinsics.areEqual((Object)targetLocator, (Object)ITEM_HAT) ? ItemDisplayContext.HEAD : ItemDisplayContext.FIXED;
        }
        this.displayContext = posableModel;
        boolean isLeft = this.displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        MatrixWrapper matrixWrapper = state.getLocatorStates().get(targetLocator);
        Intrinsics.checkNotNull((Object)matrixWrapper);
        poseStack.mulPose(matrixWrapper.getMatrix());
        switch (WhenMappings.$EnumSwitchMapping$0[this.displayContext.ordinal()]) {
            case 1: {
                HeldItemRenderer.Companion.setOriginAndScale(poseStack, 0.0f, 0.5f, 0.0f, 0.5f);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case 2: 
            case 3: {
                if (state instanceof NPCClientDelegate) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.025f * (float)(isLeft ? 1 : -1), 0.0f, 0.0f);
                    break;
                }
                if (!(state instanceof PokemonClientDelegate) && !(state instanceof FloatingState)) break;
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f * (isLeft ? -1.0f : 1.0f)));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f * (isLeft ? -1.0f : 1.0f)));
                poseStack.translate(0.0f, 0.0f, -0.0625f);
                break;
            }
            case 4: {
                if (state instanceof NPCClientDelegate) {
                    if (item.is(CobblemonItemTags.WEARABLE_FACE_ITEMS)) {
                        HeldItemRenderer.Companion.setOriginAndScale(poseStack, 0.0f, -2.0f, 7.25f, 0.62f);
                        break;
                    }
                    if (!item.is(CobblemonItemTags.WEARABLE_HAT_ITEMS)) break;
                    HeldItemRenderer.Companion.setOriginAndScale(poseStack, 0.0f, -10.25f, 0.0f, 0.62f);
                    break;
                }
                if (item.is(CobblemonItemTags.WEARABLE_FACE_ITEMS)) {
                    HeldItemRenderer.Companion.setOriginAndScale(poseStack, 0.0f, 1.0f, 6.75f, 0.62f);
                    break;
                }
                if (!item.is(CobblemonItemTags.WEARABLE_HAT_ITEMS)) break;
                HeldItemRenderer.Companion.setOriginAndScale(poseStack, 0.0f, -6.75f, 0.0f, 0.62f);
            }
        }
        if (frontLight) {
            RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        }
        this.itemRenderer.renderStatic(entity, item, this.displayContext, isLeft, poseStack, buffer, null, light, OverlayTexture.NO_OVERLAY, seed);
        poseStack.popPose();
    }

    static /* synthetic */ void renderAtLocator$default(HeldItemRenderer heldItemRenderer, ItemStack itemStack, PosableState posableState, LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int n, int n2, boolean bl, String string, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            bl = false;
        }
        if ((n3 & 0x100) != 0) {
            string = itemStack.is(CobblemonItemTags.WEARABLE_FACE_ITEMS) && posableState.getLocatorStates().containsKey(ITEM_FACE) ? ITEM_FACE : (itemStack.is(CobblemonItemTags.WEARABLE_HAT_ITEMS) && posableState.getLocatorStates().containsKey(ITEM_HAT) ? ITEM_HAT : ITEM);
        }
        heldItemRenderer.renderAtLocator(itemStack, posableState, livingEntity, poseStack, multiBufferSource, n, n2, bl, string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000b\u001a\u00020\n*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/client/render/item/HeldItemRenderer$Companion;", "", "<init>", "()V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "", "x", "y", "z", "scale", "", "setOriginAndScale", "(Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V", "", "ITEM_FACE", "Ljava/lang/String;", "ITEM_HAT", "ITEM", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final void setOriginAndScale(PoseStack $this$setOriginAndScale, float x, float y, float z, float scale) {
            $this$setOriginAndScale.translate((double)x * 0.0625 * (double)scale, (double)y * 0.0625 * (double)scale, (double)z * 0.0625 * (double)scale);
            $this$setOriginAndScale.scale(scale, scale, scale);
        }

        static /* synthetic */ void setOriginAndScale$default(Companion companion, PoseStack poseStack, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 8) != 0) {
                f4 = 1.0f;
            }
            companion.setOriginAndScale(poseStack, f, f2, f3, f4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ItemDisplayContext.values().length];
            try {
                nArray[ItemDisplayContext.FIXED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemDisplayContext.THIRD_PERSON_RIGHT_HAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemDisplayContext.THIRD_PERSON_LEFT_HAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ItemDisplayContext.HEAD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

