/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.color;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.item.components.FoodColourComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/client/render/color/PokeBaitItemColorProvider;", "Lnet/minecraft/client/color/item/ItemColor;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "layer", "getColor", "(Lnet/minecraft/world/item/ItemStack;I)I", "common"})
public final class PokeBaitItemColorProvider
implements ItemColor {
    @NotNull
    public static final PokeBaitItemColorProvider INSTANCE = new PokeBaitItemColorProvider();

    private PokeBaitItemColorProvider() {
    }

    public int getColor(@NotNull ItemStack stack, int layer) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        FoodColourComponent foodColourComponent = (FoodColourComponent)stack.get(CobblemonItemComponents.FOOD_COLOUR);
        if (foodColourComponent == null) {
            return -1;
        }
        FoodColourComponent colourComponent = foodColourComponent;
        DyeColor primaryColor = (DyeColor)CollectionsKt.getOrNull(colourComponent.getColours(), (int)0);
        DyeColor secondaryColor = (DyeColor)CollectionsKt.getOrNull(colourComponent.getColours(), (int)1);
        DyeColor tertiaryColor = (DyeColor)CollectionsKt.getOrNull(colourComponent.getColours(), (int)2);
        Integer n = switch (layer) {
            case 0 -> {
                DyeColor v1 = primaryColor;
                if (v1 != null) {
                    yield v1.getTextureDiffuseColor();
                }
                yield null;
            }
            case 1 -> {
                DyeColor v3 = secondaryColor;
                if (v3 != null) {
                    yield v3.getTextureDiffuseColor();
                }
                yield null;
            }
            case 2 -> {
                DyeColor v4 = tertiaryColor;
                if (v4 != null) {
                    yield v4.getTextureDiffuseColor();
                }
                yield null;
            }
            default -> -1;
        };
        int colour = n != null ? n : -1;
        return colour;
    }
}

