/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.fossil.Fossil;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.block.entity.RestorationTankBlockEntity;
import com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure;
import com.cobblemon.mod.common.client.CobblemonBakingOverrides;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.fossil.FossilModel;
import com.cobblemon.mod.common.client.render.models.blockbench.fossil.FossilState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.client.render.models.blockbench.wavefunction.WaveFunctionKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J?\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/client/render/block/RestorationTankRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "ctx", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "entity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "renderFetus", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "getContext", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nRestorationTankRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestorationTankRenderer.kt\ncom/cobblemon/mod/common/client/render/block/RestorationTankRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1869#2,2:223\n1869#2,2:225\n1869#2,2:227\n*S KotlinDebug\n*F\n+ 1 RestorationTankRenderer.kt\ncom/cobblemon/mod/common/client/render/block/RestorationTankRenderer\n*L\n65#1:223,2\n85#1:225,2\n139#1:227,2\n*E\n"})
public final class RestorationTankRenderer
implements BlockEntityRenderer<RestorationTankBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderContext context;
    @NotNull
    private static final List<BakedModel> FLUID_MODELS;
    @NotNull
    private static final BakedModel CONNECTOR_MODEL;
    @NotNull
    private static final List<ResourceLocation> EMBRYO_IDENTIFIERS;
    @NotNull
    private static final Function1<Float, Float> EMBRYO_CURVE_1;
    @NotNull
    private static final Function1<Float, Float> EMBRYO_CURVE_2;
    @NotNull
    private static final Function1<Float, Float> EMBRYO_CURVE_3;
    @NotNull
    private static final Function1<Float, Float> FOSSIL_CURVE;

    /*
     * WARNING - void declaration
     */
    public RestorationTankRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        void it;
        RenderContext renderContext;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RenderContext renderContext2 = renderContext = new RenderContext();
        RestorationTankRenderer restorationTankRenderer = this;
        boolean bl = false;
        it.put(RenderContext.Companion.getDO_QUIRKS(), true);
        it.put(RenderContext.Companion.getRENDER_STATE(), RenderContext.RenderState.RESURRECTION_MACHINE);
        restorationTankRenderer.context = renderContext;
    }

    @NotNull
    public final RenderContext getContext() {
        return this.context;
    }

    public void render(@NotNull RestorationTankBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        int fillLevel;
        Direction connectionDir;
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (entity.getMultiblockStructure() == null) {
            return;
        }
        MultiblockStructure multiblockStructure = entity.getMultiblockStructure();
        Intrinsics.checkNotNull((Object)multiblockStructure, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure");
        FossilMultiblockStructure struct2 = (FossilMultiblockStructure)multiblockStructure;
        Direction direction = connectionDir = struct2.getTankConnectorDirection();
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                matrices.rotateAround(Axis.YP.rotationDegrees(0.0f), 0.5f, 0.0f, 0.5f);
                break;
            }
            case 2: {
                matrices.rotateAround(Axis.YP.rotationDegrees(270.0f), 0.5f, 0.0f, 0.5f);
                break;
            }
            case 3: {
                matrices.rotateAround(Axis.YP.rotationDegrees(180.0f), 0.5f, 0.0f, 0.5f);
                break;
            }
            case 4: {
                matrices.rotateAround(Axis.YP.rotationDegrees(90.0f), 0.5f, 0.0f, 0.5f);
            }
        }
        VertexConsumer cutoutBuffer = vertexConsumers.getBuffer(RenderType.cutout());
        if (connectionDir != null) {
            matrices.pushPose();
            Level level = entity.getLevel();
            List list = CONNECTOR_MODEL.getQuads(entity.getBlockState(), null, (RandomSource)(level != null ? level.random : null));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BakedQuad quad = (BakedQuad)element$iv;
                boolean bl = false;
                cutoutBuffer.putBulkData(matrices.last(), quad, 0.75f, 0.75f, 0.75f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            }
            matrices.popPose();
        }
        if ((fillLevel = struct2.getFillLevel()) == 0 && !struct2.getHasCreatedPokemon()) {
            return;
        }
        if (struct2.isRunning() | struct2.getHasCreatedPokemon()) {
            this.renderFetus(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        matrices.pushPose();
        VertexConsumer transparentBuffer = vertexConsumers.getBuffer(RenderType.translucent());
        BakedModel fluidModel = struct2.isRunning() ? FLUID_MODELS.get(8) : (struct2.getHasCreatedPokemon() ? FLUID_MODELS.get(7) : FLUID_MODELS.get(RangesKt.coerceAtMost((int)fillLevel, (int)(FLUID_MODELS.size() - 1)) - 1));
        BlockState blockState = entity.getBlockState();
        Level level = entity.getLevel();
        Intrinsics.checkNotNull((Object)level);
        List list = fluidModel.getQuads(blockState, null, level.random);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BakedQuad quad = (BakedQuad)element$iv;
            boolean bl = false;
            transparentBuffer.putBulkData(matrices.last(), quad, 0.75f, 0.75f, 0.75f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        }
        matrices.popPose();
    }

    private final void renderFetus(RestorationTankBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        MultiblockStructure multiblockStructure = entity.getMultiblockStructure();
        FossilMultiblockStructure fossilMultiblockStructure = multiblockStructure instanceof FossilMultiblockStructure ? (FossilMultiblockStructure)multiblockStructure : null;
        if (fossilMultiblockStructure == null) {
            return;
        }
        FossilMultiblockStructure struc = fossilMultiblockStructure;
        Fossil fossil = struc.getResultingFossil();
        if (fossil == null) {
            return;
        }
        Fossil fossil2 = fossil;
        int timeRemaining = struc.getTimeRemaining();
        Level level = entity.getLevel();
        if (level == null || (level = level.getBlockState(entity.getBlockPos())) == null) {
            return;
        }
        Level tankBlockState = level;
        if (!Intrinsics.areEqual((Object)tankBlockState.getBlock(), (Object)((Object)CobblemonBlocks.RESTORATION_TANK))) {
            return;
        }
        Direction tankDirection = (Direction)tankBlockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        MultiblockStructure multiblockStructure2 = entity.getMultiblockStructure();
        Intrinsics.checkNotNull((Object)multiblockStructure2, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure");
        FossilMultiblockStructure struct2 = (FossilMultiblockStructure)multiblockStructure2;
        Direction connectionDir = struct2.getTankConnectorDirection();
        FossilState state = struc.getFossilState();
        state.updatePartialTicks(tickDelta);
        Object object = struc.getResultingFossil();
        if (object == null || (object = ((Fossil)object).getResult()) == null || (object = ((PokemonProperties)object).getAspects()) == null) {
            object = SetsKt.emptySet();
        }
        state.setCurrentAspects((Set<String>)object);
        ResourceLocation fossilPoserId = null;
        fossilPoserId = fossil2.getIdentifier().withPath(fossil2.getIdentifier().getPath() + "_fetus");
        float completionPercentage = RangesKt.coerceIn((float)(1.0f - (float)timeRemaining / 14400.0f), (float)0.0f, (float)1.0f);
        ResourceLocation resourceLocation = fossilPoserId;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"element");
        PosableModel posableModel = VaryingModelRepository.INSTANCE.getPoser(resourceLocation, state);
        FossilModel fossilModel = posableModel instanceof FossilModel ? (FossilModel)posableModel : null;
        if (fossilModel == null) {
            RestorationTankRenderer it = this;
            boolean bl = false;
            fossilPoserId = MiscUtilsKt.cobblemonResource("substitute_fetus");
            PosableModel posableModel2 = VaryingModelRepository.INSTANCE.getPoser(fossilPoserId, state);
            Intrinsics.checkNotNull((Object)posableModel2, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.render.models.blockbench.fossil.FossilModel");
            fossilModel = (FossilModel)posableModel2;
        }
        FossilModel fossilFetusModel = fossilModel;
        fossilFetusModel.setContext(this.context);
        float embryo1Scale = ((Number)EMBRYO_CURVE_1.invoke((Object)Float.valueOf(completionPercentage))).floatValue();
        float embryo2Scale = ((Number)EMBRYO_CURVE_2.invoke((Object)Float.valueOf(completionPercentage))).floatValue();
        float embryo3Scale = ((Number)EMBRYO_CURVE_3.invoke((Object)Float.valueOf(completionPercentage))).floatValue();
        float fossilScale = ((Number)FOSSIL_CURVE.invoke((Object)Float.valueOf(completionPercentage))).floatValue();
        Object[] objectArray = new Pair[]{new Pair((Object)EMBRYO_IDENTIFIERS.get(0), (Object)Float.valueOf(embryo1Scale)), new Pair((Object)EMBRYO_IDENTIFIERS.get(1), (Object)Float.valueOf(embryo2Scale)), new Pair((Object)EMBRYO_IDENTIFIERS.get(2), (Object)Float.valueOf(embryo3Scale)), new Pair((Object)fossilPoserId, (Object)Float.valueOf(fossilScale))};
        List identifiersAndScales = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = identifiersAndScales;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ResourceLocation identifier2 = (ResourceLocation)pair.component1();
            float scale = ((Number)pair.component2()).floatValue();
            PosableModel posableModel3 = VaryingModelRepository.INSTANCE.getPoser(identifier2, state);
            Intrinsics.checkNotNull((Object)posableModel3, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.render.models.blockbench.fossil.FossilModel");
            FossilModel model = (FossilModel)posableModel3;
            ResourceLocation texture = VaryingModelRepository.INSTANCE.getTexture(identifier2, state);
            if (!(scale > 0.0f)) continue;
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
            state.setCurrentModel(model);
            PosableState.setPoseToFirstSuitable$default(state, null, 1, null);
            float scale2 = timeRemaining == 0 ? model.getMaxScale() : scale * model.getMaxScale();
            matrices.pushPose();
            matrices.translate(0.5, 1.0 + (double)fossilFetusModel.getYTranslation(), 0.5);
            matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
            if (tankDirection.getCounterClockWise(Direction.Axis.Y) == connectionDir) {
                matrices.mulPose(Axis.YP.rotationDegrees(-90.0f));
            } else if (tankDirection == connectionDir) {
                matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
            } else if (tankDirection.getOpposite() != connectionDir) {
                matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            model.setContext(this.context);
            this.context.put(RenderContext.Companion.getTEXTURE(), texture);
            this.context.put(RenderContext.Companion.getSPECIES(), fossil2.getIdentifier());
            this.context.put(RenderContext.Companion.getRENDER_STATE(), RenderContext.RenderState.RESURRECTION_MACHINE);
            this.context.put(RenderContext.Companion.getPOSABLE_STATE(), state);
            matrices.pushPose();
            matrices.scale(scale2, scale2, scale2);
            matrices.translate(0.0, (double)model.getYGrowthPoint(), 0.0);
            float f = state.getAnimationSeconds() * (float)20;
            model.applyAnimations(null, state, 0.0f, 0.0f, f, 0.0f, 0.0f);
            Intrinsics.checkNotNull((Object)vertexConsumer);
            model.render(this.context, matrices, vertexConsumer, light, overlay, -1);
            PosableState posableState = state;
            ResourceLocation resourceLocation2 = fossilPoserId;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"element");
            model.withLayerContext(vertexConsumers, posableState, VaryingModelRepository.INSTANCE.getLayers(resourceLocation2, state), (Function0<Unit>)((Function0)() -> RestorationTankRenderer.renderFetus$lambda$1$0(model, this, matrices, vertexConsumer, light)));
            model.setDefault();
            matrices.popPose();
            matrices.popPose();
        }
    }

    private static final Unit renderFetus$lambda$1$0(FossilModel $model, RestorationTankRenderer this$0, PoseStack $matrices, VertexConsumer $vertexConsumer, int $light) {
        RenderContext renderContext = this$0.context;
        Intrinsics.checkNotNull((Object)$vertexConsumer);
        $model.render(renderContext, $matrices, $vertexConsumer, $light, OverlayTexture.NO_OVERLAY, -1);
        return Unit.INSTANCE;
    }

    private static final float FOSSIL_CURVE$lambda$0(float t) {
        return -0.4f * (float)Math.pow(t - 2.5f, 2) + 1.0f;
    }

    static {
        Object[] objectArray = new BakedModel[]{CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_1().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_2().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_3().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_4().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_5().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_6().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_7().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_CHUNKED_8().getModel(), CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_FLUID_BUBBLING().getModel()};
        FLUID_MODELS = CollectionsKt.listOf((Object[])objectArray);
        CONNECTOR_MODEL = CobblemonBakingOverrides.INSTANCE.getRESTORATION_TANK_CONNECTOR().getModel();
        objectArray = new ResourceLocation[]{MiscUtilsKt.cobblemonResource("embryo_stage1"), MiscUtilsKt.cobblemonResource("embryo_stage2"), MiscUtilsKt.cobblemonResource("embryo_stage3")};
        EMBRYO_IDENTIFIERS = CollectionsKt.listOf((Object[])objectArray);
        EMBRYO_CURVE_1 = WaveFunctionKt.timeDilate(WaveFunctionKt.rerange(WaveFunctionKt.parabolaFunction(0.5f, 1.0f), 0.0f, 0.8f), 2.5f);
        EMBRYO_CURVE_2 = WaveFunctionKt.timeDilate(WaveFunctionKt.rerange(WaveFunctionKt.parabolaFunction(0.9f, 1.0f), 0.2f, 1.2f), 2.5f);
        EMBRYO_CURVE_3 = WaveFunctionKt.timeDilate(WaveFunctionKt.rerange(WaveFunctionKt.parabolaFunction(1.0f, 1.0f), 0.6f, 1.4f), 2.5f);
        FOSSIL_CURVE = WaveFunctionKt.timeDilate((Function1<? super Float, Float>)((Function1)RestorationTankRenderer::FOSSIL_CURVE$lambda$0), 2.5f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0007\u001a\u0004\b\u0010\u0010\tR'\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R'\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R'\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u001b\u0010\u0017R'\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0015\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/client/render/block/RestorationTankRenderer$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/client/resources/model/BakedModel;", "FLUID_MODELS", "Ljava/util/List;", "getFLUID_MODELS", "()Ljava/util/List;", "CONNECTOR_MODEL", "Lnet/minecraft/client/resources/model/BakedModel;", "getCONNECTOR_MODEL", "()Lnet/minecraft/client/resources/model/BakedModel;", "Lnet/minecraft/resources/ResourceLocation;", "EMBRYO_IDENTIFIERS", "getEMBRYO_IDENTIFIERS", "Lkotlin/Function1;", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/wavefunction/WaveFunction;", "EMBRYO_CURVE_1", "Lkotlin/jvm/functions/Function1;", "getEMBRYO_CURVE_1", "()Lkotlin/jvm/functions/Function1;", "EMBRYO_CURVE_2", "getEMBRYO_CURVE_2", "EMBRYO_CURVE_3", "getEMBRYO_CURVE_3", "FOSSIL_CURVE", "getFOSSIL_CURVE", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BakedModel> getFLUID_MODELS() {
            return FLUID_MODELS;
        }

        @NotNull
        public final BakedModel getCONNECTOR_MODEL() {
            return CONNECTOR_MODEL;
        }

        @NotNull
        public final List<ResourceLocation> getEMBRYO_IDENTIFIERS() {
            return EMBRYO_IDENTIFIERS;
        }

        @NotNull
        public final Function1<Float, Float> getEMBRYO_CURVE_1() {
            return EMBRYO_CURVE_1;
        }

        @NotNull
        public final Function1<Float, Float> getEMBRYO_CURVE_2() {
            return EMBRYO_CURVE_2;
        }

        @NotNull
        public final Function1<Float, Float> getEMBRYO_CURVE_3() {
            return EMBRYO_CURVE_3;
        }

        @NotNull
        public final Function1<Float, Float> getFOSSIL_CURVE() {
            return FOSSIL_CURVE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

