/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.block.campfirepot.CampfireBlock;
import com.cobblemon.mod.common.block.campfirepot.CampfirePotBlock;
import com.cobblemon.mod.common.block.entity.CampfireBlockEntity;
import com.cobblemon.mod.common.item.CampfirePotItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013JG\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J?\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u007f\u0010'\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b'\u0010(JW\u0010.\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/client/render/block/CampfireBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "ctx", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "multiBufferSource", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lcom/cobblemon/mod/common/item/CampfirePotItem;", "campfirePotItem", "renderPot", "(Lcom/cobblemon/mod/common/item/CampfirePotItem;Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "renderSeasonings", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "builder", "x0", "y0", "z0", "x1", "y1", "z1", "u0", "v0", "u1", "v1", "packedLight", "color", "drawQuad", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lcom/mojang/blaze3d/vertex/PoseStack;FFFFFFFFFFII)V", "x", "y", "z", "u", "v", "drawVertex", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lcom/mojang/blaze3d/vertex/PoseStack;FFFFFII)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCampfireBlockEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireBlockEntityRenderer.kt\ncom/cobblemon/mod/common/client/render/block/CampfireBlockEntityRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n1878#2,3:198\n*S KotlinDebug\n*F\n+ 1 CampfireBlockEntityRenderer.kt\ncom/cobblemon/mod/common/client/render/block/CampfireBlockEntityRenderer\n*L\n131#1:198,3\n*E\n"})
public final class CampfireBlockEntityRenderer
implements BlockEntityRenderer<CampfireBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final float CIRCLE_RADIUS = 0.4f;
    public static final float ROTATION_SPEED = 1.5f;
    public static final float JUMP_AMPLITUDE = 0.025f;
    public static final float JUMP_SPEED = 0.1f;

    public CampfireBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void render(@NotNull CampfireBlockEntity blockEntity, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        Direction facing;
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        ItemStack itemStack = blockEntity.getPotItem();
        CampfirePotItem campfirePotItem = (CampfirePotItem)((Object)(itemStack != null ? itemStack.getItem() : null));
        if (campfirePotItem == null) {
            return;
        }
        poseStack.pushPose();
        Direction direction = facing = (Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
        float rotationAngle = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> 180.0f;
            case 2 -> 0.0f;
            case 3 -> 90.0f;
            case 4 -> -90.0f;
            default -> 0.0f;
        };
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationAngle));
        poseStack.translate(-0.5, -0.5, -0.5);
        this.renderPot(campfirePotItem, blockEntity, tickDelta, poseStack, multiBufferSource, light, overlay);
        this.renderSeasonings(blockEntity, tickDelta, poseStack, multiBufferSource, light, overlay);
        poseStack.popPose();
    }

    private final void renderPot(CampfirePotItem campfirePotItem, CampfireBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        boolean isLidOpen = (Boolean)blockEntity.getBlockState().getValue((Property)CampfireBlock.Companion.getLID()) == false;
        float yRot = (((Direction)blockEntity.getBlockState().getValue((Property)CampfireBlock.Companion.getITEM_DIRECTION())).getOpposite().toYRot() + ((Direction)blockEntity.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot()) % (float)360;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.4375, 0.0);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = (BlockState)((BlockState)((BlockState)campfirePotItem.getBlock().defaultBlockState().setValue((Property)CampfirePotBlock.Companion.getOPEN(), (Comparable)Boolean.valueOf(isLidOpen))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.fromYRot((double)yRot))).setValue((Property)CampfirePotBlock.Companion.getOCCUPIED(), (Comparable)Boolean.valueOf(!blockEntity.getSeasonings().isEmpty() || !blockEntity.getIngredients().isEmpty()));
        BakedModel bakedModel = blockRenderer.getBlockModel(state);
        Intrinsics.checkNotNullExpressionValue((Object)bakedModel, (String)"getBlockModel(...)");
        BakedModel bakedModel2 = bakedModel;
        float red = (float)FastColor.ARGB32.red((int)blockEntity.getBrothColor()) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)blockEntity.getBrothColor()) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)blockEntity.getBrothColor()) / 255.0f;
        blockRenderer.getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false)), state, bakedModel2, red, green, blue, light, overlay);
        poseStack.popPose();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSeasonings(CampfireBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        List<ItemStack> seasonings = blockEntity.getSeasonings();
        float gameTime = (float)blockEntity.getTime() + tickDelta;
        float rotationAngle = gameTime * 1.5f % (float)360;
        Iterable $this$forEachIndexed$iv = seasonings;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void seasoning;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ItemStack itemStack = (ItemStack)item$iv;
            int index = n;
            boolean bl = false;
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            float angleOffset = (float)index * (360.0f / (float)seasonings.size());
            double angleInRadians = Math.toRadians(rotationAngle + angleOffset);
            float xOffset = (float)Math.cos(angleInRadians) * 0.4f;
            float zOffset = (float)Math.sin(angleInRadians) * 0.4f;
            float jumpOffset = (float)Math.sin(gameTime * 0.1f + (float)(index * 2)) * 0.025f;
            poseStack.translate(1.0f + xOffset, 1.24f + jumpOffset, 1.0f + zOffset);
            Vector3f lookAtDirection = new Vector3f(1.0f + xOffset - 1.0f, 0.0f, 1.0f + zOffset - 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(-Math.toDegrees(Math.atan2(lookAtDirection.z(), lookAtDirection.x()))) + (float)90));
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(22.5f));
            Minecraft.getInstance().getItemRenderer().renderStatic((ItemStack)seasoning, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
            poseStack.popPose();
        }
    }

    private final void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        this.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        this.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        this.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        this.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }

    private final void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/client/render/block/CampfireBlockEntityRenderer$Companion;", "", "<init>", "()V", "", "CIRCLE_RADIUS", "F", "ROTATION_SPEED", "JUMP_AMPLITUDE", "JUMP_SPEED", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

