/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.BakingOverride;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.berry.GrowthPoint;
import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import com.cobblemon.mod.common.client.CobblemonBakingOverrides;
import com.cobblemon.mod.common.client.render.atlas.CobblemonAtlases;
import com.cobblemon.mod.common.client.render.block.BerryBlockEntityRenderState;
import com.cobblemon.mod.common.client.render.models.blockbench.ModelPartExtensionsKt;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.BerryModelRepository;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.Axis;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ?\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J7\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ=\u0010 \u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J5\u0010\"\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\"\u0010#J5\u0010$\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b$\u0010#R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010%R%\u0010)\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(0&8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lcom/cobblemon/mod/common/client/render/block/BerryBlockRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "shouldRender", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;Lnet/minecraft/world/phys/Vec3;)Z", "entity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "drawMulch", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;II)V", "Lcom/cobblemon/mod/common/client/render/block/BerryBlockEntityRenderState;", "renderState", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "buffer", "renderToBuffer", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;IILcom/cobblemon/mod/common/client/render/block/BerryBlockEntityRenderState;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V", "renderBabyToBuffer", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;Lcom/mojang/blaze3d/vertex/PoseStack;IILcom/mojang/blaze3d/vertex/VertexConsumer;)V", "renderAdultToBuffer", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "Lcom/cobblemon/mod/common/BakingOverride;", "mulchModels", "Ljava/util/Map;", "getMulchModels", "()Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nBerryBlockRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BerryBlockRenderer.kt\ncom/cobblemon/mod/common/client/render/block/BerryBlockRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1869#2,2:174\n*S KotlinDebug\n*F\n+ 1 BerryBlockRenderer.kt\ncom/cobblemon/mod/common/client/render/block/BerryBlockRenderer\n*L\n98#1:174,2\n*E\n"})
public final class BerryBlockRenderer
implements BlockEntityRenderer<BerryBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    @NotNull
    private final Map<MulchVariant, BakingOverride> mulchModels;

    public BerryBlockRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)MulchVariant.COARSE), (Object)CobblemonBakingOverrides.INSTANCE.getCOARSE_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.GROWTH), (Object)CobblemonBakingOverrides.INSTANCE.getGROWTH_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.HUMID), (Object)CobblemonBakingOverrides.INSTANCE.getHUMID_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.LOAMY), (Object)CobblemonBakingOverrides.INSTANCE.getLOAMY_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.PEAT), (Object)CobblemonBakingOverrides.INSTANCE.getPEAT_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.RICH), (Object)CobblemonBakingOverrides.INSTANCE.getRICH_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.SANDY), (Object)CobblemonBakingOverrides.INSTANCE.getSANDY_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.SURPRISE), (Object)CobblemonBakingOverrides.INSTANCE.getSURPRISE_MULCH()), TuplesKt.to((Object)((Object)MulchVariant.NONE), null)};
        this.mulchModels = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<MulchVariant, BakingOverride> getMulchModels() {
        return this.mulchModels;
    }

    public boolean shouldRender(@NotNull BerryBlockEntity blockEntity, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return super.shouldRender((BlockEntity)blockEntity, pos) && Minecraft.getInstance().levelRenderer.cullingFrustum.isVisible(AABB.ofSize((Vec3)pos, (double)2.0, (double)4.0, (double)2.0));
    }

    public void render(@NotNull BerryBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        BlockPos blockPos = entity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        if (!this.shouldRender(entity, BlockPosExtensionsKt.toVec3d(blockPos))) {
            return;
        }
        BlockState blockState = entity.getBlockState();
        if (entity.getRenderState() == null) {
            entity.setRenderState(new BerryBlockEntityRenderState());
        }
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)CobblemonAtlases.INSTANCE.getBERRY_SPRITE_ATLAS().textureAtlas.location()));
        BerryBlockEntity.RenderState renderState = entity.getRenderState();
        Intrinsics.checkNotNull((Object)renderState, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.render.block.BerryBlockEntityRenderState");
        BerryBlockEntityRenderState renderState2 = (BerryBlockEntityRenderState)renderState;
        Intrinsics.checkNotNull((Object)buffer);
        this.renderToBuffer(entity, matrices, light, overlay, renderState2, buffer);
        this.drawMulch(matrices, vertexConsumers, entity, light, overlay);
    }

    private final void drawMulch(PoseStack matrices, MultiBufferSource vertexConsumers, BerryBlockEntity entity, int light, int overlay) {
        BakingOverride model;
        matrices.pushPose();
        VertexConsumer mulchBuf = vertexConsumers.getBuffer(RenderType.cutout());
        BakingOverride bakingOverride = model = this.mulchModels.get((Object)entity.getMulchVariant());
        if (bakingOverride != null) {
            BakingOverride it = bakingOverride;
            boolean bl = false;
            Level level = entity.getLevel();
            List list = it.getModel().getQuads(entity.getBlockState(), null, (RandomSource)(level != null ? level.random : null));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BakedQuad quad = (BakedQuad)element$iv;
                boolean bl2 = false;
                mulchBuf.putBulkData(matrices.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay);
            }
        }
        matrices.popPose();
    }

    public final void renderToBuffer(@NotNull BerryBlockEntity entity, @NotNull PoseStack matrices, int light, int overlay, @NotNull BerryBlockEntityRenderState renderState, @NotNull VertexConsumer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)renderState, (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Integer n = (Integer)entity.getBlockState().getValue((Property)BerryBlock.Companion.getAGE());
        if (n != null && n == 0) {
            this.renderBabyToBuffer(entity, matrices, light, overlay, buffer);
            renderState.setDrawVbo(true);
        } else if (((Number)((Object)entity.getBlockState().getValue((Property)BerryBlock.Companion.getAGE()))).intValue() > 3) {
            this.renderAdultToBuffer(entity, matrices, light, overlay, buffer);
            renderState.setDrawVbo(true);
        } else {
            renderState.setDrawVbo(false);
        }
    }

    public final void renderBabyToBuffer(@NotNull BerryBlockEntity entity, @NotNull PoseStack matrices, int light, int overlay, @NotNull VertexConsumer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Berry berry = entity.berry();
        if (berry == null) {
            return;
        }
        Berry berry2 = berry;
        ModelPart modelPart = BerryModelRepository.INSTANCE.modelOf(berry2.getFruitModelIdentifier());
        if (modelPart == null) {
            return;
        }
        ModelPart model = modelPart;
        Vec3 pos = berry2.getStageOnePositioning().getPosition();
        ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)pos.x);
        ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)pos.y);
        ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), (float)pos.z);
        Vec3 rot = berry2.getStageOnePositioning().getRotation();
        model.setRotation((float)Math.toRadians((double)180 - rot.x), (float)Math.toRadians((double)180 + rot.y), (float)Math.toRadians(rot.z));
        model.render(matrices, buffer, light, overlay);
    }

    public final void renderAdultToBuffer(@NotNull BerryBlockEntity entity, @NotNull PoseStack matrices, int light, int overlay, @NotNull VertexConsumer buffer) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BlockState blockState = entity.getBlockState();
        Integer age = (Integer)blockState.getValue((Property)BerryBlock.Companion.getAGE());
        if (age <= 3) {
            return;
        }
        Integer n = age;
        int n2 = 4;
        boolean isFlower = n != null && n == n2;
        for (Pair<Berry, GrowthPoint> pair : entity.berryAndGrowthPoint$common()) {
            ModelPart model;
            Berry berry = (Berry)pair.component1();
            GrowthPoint growthPoint = (GrowthPoint)pair.component2();
            if ((isFlower ? BerryModelRepository.INSTANCE.modelOf(berry.getFlowerModelIdentifier()) : BerryModelRepository.INSTANCE.modelOf(berry.getFruitModelIdentifier())) == null) continue;
            model = model;
            model.setRotation((float)Math.toRadians(180.0 - growthPoint.getRotation().x), (float)Math.toRadians(180.0 + growthPoint.getRotation().y), (float)Math.toRadians(growthPoint.getRotation().z));
            ModelPartExtensionsKt.setPosition(model, Axis.X_AXIS.ordinal(), (float)growthPoint.getPosition().x);
            ModelPartExtensionsKt.setPosition(model, Axis.Y_AXIS.ordinal(), (float)growthPoint.getPosition().y);
            ModelPartExtensionsKt.setPosition(model, Axis.Z_AXIS.ordinal(), (float)growthPoint.getPosition().z);
            model.render(matrices, buffer, light, overlay);
        }
    }
}

