/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render;

import com.cobblemon.mod.common.util.math.geometry.Matrix4fExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\b0\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR0\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "", "<init>", "()V", "Lorg/joml/Matrix4f;", "rotationMatrix", "updateMatrix", "(Lorg/joml/Matrix4f;)Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "Lnet/minecraft/world/phys/Vec3;", "position", "updatePosition", "(Lnet/minecraft/world/phys/Vec3;)Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "getOrigin", "()Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "transformPosition", "(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "transformWorldToParticle", "clone", "()Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "setPosition", "(Lnet/minecraft/world/phys/Vec3;)V", "matrix", "Lorg/joml/Matrix4f;", "getMatrix", "()Lorg/joml/Matrix4f;", "setMatrix", "(Lorg/joml/Matrix4f;)V", "Lkotlin/Function1;", "", "updateFunction", "Lkotlin/jvm/functions/Function1;", "getUpdateFunction", "()Lkotlin/jvm/functions/Function1;", "setUpdateFunction", "(Lkotlin/jvm/functions/Function1;)V", "common"})
public final class MatrixWrapper {
    @NotNull
    private Vec3 position;
    @NotNull
    private Matrix4f matrix;
    @Nullable
    private Function1<? super MatrixWrapper, Unit> updateFunction;

    public MatrixWrapper() {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.position = vec3;
        this.matrix = new Matrix4f();
    }

    @NotNull
    public final Vec3 getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.position = vec3;
    }

    @NotNull
    public final Matrix4f getMatrix() {
        return this.matrix;
    }

    public final void setMatrix(@NotNull Matrix4f matrix4f) {
        Intrinsics.checkNotNullParameter((Object)matrix4f, (String)"<set-?>");
        this.matrix = matrix4f;
    }

    @Nullable
    public final Function1<MatrixWrapper, Unit> getUpdateFunction() {
        return this.updateFunction;
    }

    public final void setUpdateFunction(@Nullable Function1<? super MatrixWrapper, Unit> function1) {
        this.updateFunction = function1;
    }

    @NotNull
    public final MatrixWrapper updateMatrix(@NotNull Matrix4f rotationMatrix) {
        MatrixWrapper matrixWrapper;
        Intrinsics.checkNotNullParameter((Object)rotationMatrix, (String)"rotationMatrix");
        MatrixWrapper $this$updateMatrix_u24lambda_u240 = matrixWrapper = this;
        boolean bl = false;
        $this$updateMatrix_u24lambda_u240.matrix = new Matrix4f((Matrix4fc)rotationMatrix);
        return matrixWrapper;
    }

    @NotNull
    public final MatrixWrapper updatePosition(@NotNull Vec3 position) {
        MatrixWrapper matrixWrapper;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        MatrixWrapper $this$updatePosition_u24lambda_u240 = matrixWrapper = this;
        boolean bl = false;
        $this$updatePosition_u24lambda_u240.position = position;
        return matrixWrapper;
    }

    @NotNull
    public final Vec3 getOrigin() {
        Function1<? super MatrixWrapper, Unit> function1 = this.updateFunction;
        if (function1 != null) {
            function1.invoke((Object)this);
        }
        Vec3 vec3 = this.position.add(Matrix4fExtensionsKt.getOrigin(this.matrix));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    public final Vec3 transformPosition(@NotNull Vec3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.position.add(Matrix4fExtensionsKt.transformPosition(this.matrix, position));
    }

    @NotNull
    public final Vec3 transformWorldToParticle(@NotNull Vec3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)this.matrix).invertAffine();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"invertAffine(...)");
        Vec3 vec3 = position.subtract(this.position);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"subtract(...)");
        return Matrix4fExtensionsKt.transformPosition(matrix4f, vec3);
    }

    @NotNull
    public final MatrixWrapper clone() {
        return new MatrixWrapper().updateMatrix(this.matrix).updatePosition(this.position);
    }
}

