/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render;

import com.cobblemon.mod.common.client.render.ModelTextureSupplier;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/client/render/AnimatedModelTextureSupplier;", "Lcom/cobblemon/mod/common/client/render/ModelTextureSupplier;", "", "loop", "", "fps", "", "Lnet/minecraft/resources/ResourceLocation;", "frames", "interpolation", "<init>", "(ZFLjava/util/List;Z)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "invoke", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/client/renderer/texture/DynamicTexture;", "interpolatedTexture", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lnet/minecraft/client/renderer/texture/DynamicTexture;", "Z", "getLoop", "()Z", "F", "getFps", "()F", "Ljava/util/List;", "getFrames", "()Ljava/util/List;", "getInterpolation", "common"})
public final class AnimatedModelTextureSupplier
implements ModelTextureSupplier {
    private final boolean loop;
    private final float fps;
    @NotNull
    private final List<ResourceLocation> frames;
    private final boolean interpolation;

    public AnimatedModelTextureSupplier(boolean loop, float fps, @NotNull List<ResourceLocation> frames, boolean interpolation) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        this.loop = loop;
        this.fps = fps;
        this.frames = frames;
        this.interpolation = interpolation;
    }

    public final boolean getLoop() {
        return this.loop;
    }

    public final float getFps() {
        return this.fps;
    }

    @NotNull
    public final List<ResourceLocation> getFrames() {
        return this.frames;
    }

    public final boolean getInterpolation() {
        return this.interpolation;
    }

    @Override
    @NotNull
    public ResourceLocation invoke(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int frameIndex = (int)Math.floor(state.getAnimationSeconds() * this.fps);
        return frameIndex >= this.frames.size() && !this.loop ? (ResourceLocation)CollectionsKt.last(this.frames) : this.frames.get(frameIndex % this.frames.size());
    }

    @Nullable
    public final DynamicTexture interpolatedTexture(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        int frameIndex = (int)Math.floor(state.getAnimationSeconds() * this.fps);
        try {
            if (frameIndex >= this.frames.size() && !this.loop) {
                return new DynamicTexture(NativeImage.read((InputStream)resourceManager.getResourceOrThrow((ResourceLocation)CollectionsKt.last(this.frames)).open()));
            }
        }
        catch (Exception e) {
            return null;
        }
        int o = frameIndex % this.frames.size();
        float i = state.getAnimationSeconds() * this.fps - (float)frameIndex;
        NativeImage texture1 = null;
        NativeImage texture2 = null;
        try {
            NativeImage nativeImage = NativeImage.read((InputStream)resourceManager.getResourceOrThrow(this.frames.get(o)).open());
            Intrinsics.checkNotNullExpressionValue((Object)nativeImage, (String)"read(...)");
            texture1 = nativeImage;
            int s = o == this.frames.size() - 1 ? 0 : o + 1;
            NativeImage nativeImage2 = NativeImage.read((InputStream)resourceManager.getResourceOrThrow(this.frames.get(s)).open());
            Intrinsics.checkNotNullExpressionValue((Object)nativeImage2, (String)"read(...)");
            texture2 = nativeImage2;
        }
        catch (Exception e) {
            return null;
        }
        int n = texture1.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = texture1.getHeight();
            for (int y = 0; y < n2; ++y) {
                Vector4f color1 = MiscUtilsKt.toRGBA(texture1.getPixelRGBA(x, y));
                Vector4f color2 = MiscUtilsKt.toRGBA(texture2.getPixelRGBA(x, y));
                int newRed = 0;
                int newGreen = 0;
                int newBlue = 0;
                int newAlpha = 0;
                if (color1.w == 0.0f && color2.w == 1.0f) {
                    newRed = (int)Math.floor(color2.x * (float)255);
                    newGreen = (int)Math.floor(color2.y * (float)255);
                    newBlue = (int)Math.floor(color2.z * (float)255);
                } else if (color1.w == 1.0f && color2.w == 0.0f) {
                    newRed = (int)Math.floor(color1.x * (float)255);
                    newGreen = (int)Math.floor(color1.y * (float)255);
                    newBlue = (int)Math.floor(color1.z * (float)255);
                } else {
                    newRed = (int)Math.floor((color1.x + (color2.x - color1.x) * i) * (float)255);
                    newGreen = (int)Math.floor((color1.y + (color2.y - color1.y) * i) * (float)255);
                    newBlue = (int)Math.floor((color1.z + (color2.z - color1.z) * i) * (float)255);
                }
                newAlpha = (int)Math.floor((color1.w + (color2.w - color1.w) * i) * (float)255);
                int finalColor = newAlpha << 24 | newRed << 16 | newGreen << 8 | newBlue;
                texture1.setPixelRGBA(x, y, finalColor);
            }
        }
        DynamicTexture newTexture = new DynamicTexture(texture1);
        newTexture.setFilter(false, false);
        return newTexture;
    }
}

