/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.keybind.keybinds;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.gui.battle.BattleGUI;
import com.cobblemon.mod.common.client.keybind.CobblemonBlockingKeyBinding;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.BattleChallengePacket;
import com.cobblemon.mod.common.net.messages.server.RequestPlayerInteractionsPacket;
import com.cobblemon.mod.common.net.messages.server.SendOutPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.riding.DismountPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0018J!\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010!\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J)\u0010#\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b%\u0010\u0003R\"\u0010&\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010\b\"\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/client/keybind/keybinds/PartySendBinding;", "Lcom/cobblemon/mod/common/client/keybind/CobblemonBlockingKeyBinding;", "<init>", "()V", "", "actioned", "", "canAction", "()Z", "onTick", "onRelease", "Lcom/cobblemon/mod/common/client/battle/ClientBattle;", "battle", "toggleBattleScreen", "(Lcom/cobblemon/mod/common/client/battle/ClientBattle;)V", "Lnet/minecraft/client/player/LocalPlayer;", "player", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "selectedPartyPokemon", "checkForTargetInteractions", "(Lnet/minecraft/client/player/LocalPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/world/entity/LivingEntity;", "target", "canSendOutPokemon", "(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/entity/LivingEntity;)Z", "pokemon", "entity", "processEntityTarget", "(Lnet/minecraft/client/player/LocalPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/world/entity/LivingEntity;)V", "canProcessEntityTarget", "canAttemptDismount", "(Lnet/minecraft/client/player/LocalPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "ignoreControlling", "isRidingPokemon", "(Lnet/minecraft/client/player/LocalPlayer;Z)Z", "isRidingSelectedPokemon", "(Lnet/minecraft/client/player/LocalPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)Z", "onPress", "canApplyChange", "Z", "getCanApplyChange", "setCanApplyChange", "(Z)V", "", "heldDownSeconds", "F", "getHeldDownSeconds", "()F", "setHeldDownSeconds", "(F)V", "common"})
public final class PartySendBinding
extends CobblemonBlockingKeyBinding {
    @NotNull
    public static final PartySendBinding INSTANCE = new PartySendBinding();
    private static boolean canApplyChange = true;
    private static float heldDownSeconds;

    private PartySendBinding() {
        super("key.cobblemon.throwpartypokemon", InputConstants.Type.KEYSYM, 82, "key.cobblemon.categories.cobblemon");
    }

    public final boolean getCanApplyChange() {
        return canApplyChange;
    }

    public final void setCanApplyChange(boolean bl) {
        canApplyChange = bl;
    }

    public final float getHeldDownSeconds() {
        return heldDownSeconds;
    }

    public final void setHeldDownSeconds(float f) {
        heldDownSeconds = f;
    }

    public final void actioned() {
        canApplyChange = false;
        this.setWasDown(true);
        heldDownSeconds = 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canAction() {
        if (!canApplyChange) return false;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) return false;
        if (PlayerExtensionsKt.isUsingPokedex((Player)localPlayer)) return false;
        return true;
    }

    @Override
    public void onTick() {
        if (this.getWasDown()) {
            if (heldDownSeconds < 100.0f) {
                heldDownSeconds += Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            }
        } else {
            heldDownSeconds = 0.0f;
        }
        super.onTick();
    }

    @Override
    public void onRelease() {
        Pokemon selectedPartyPokemon;
        boolean canAction = this.canAction();
        this.setWasDown(false);
        canApplyChange = true;
        if (!canAction) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (player.isSpectator()) {
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle != null) {
            this.toggleBattleScreen(battle);
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        Pokemon pokemon = selectedPartyPokemon = CobblemonClient.INSTANCE.getStorage().getSelectedSlot() >= 0 ? CobblemonClient.INSTANCE.getStorage().getParty().get(CobblemonClient.INSTANCE.getStorage().getSelectedSlot()) : null;
        if (PartySendBinding.isRidingPokemon$default(this, player, false, 2, null) && this.canAttemptDismount(player, selectedPartyPokemon)) {
            CobblemonNetwork.sendToServer(new DismountPokemonPacket());
        } else if (selectedPartyPokemon != null && !PartySendBinding.isRidingSelectedPokemon$default(this, player, selectedPartyPokemon, false, 4, null)) {
            this.checkForTargetInteractions(player, selectedPartyPokemon);
        }
    }

    private final void toggleBattleScreen(ClientBattle battle) {
        battle.setMinimised(!battle.getMinimised());
        if (!battle.getMinimised() && !Minecraft.getInstance().options.hideGui) {
            Minecraft.getInstance().setScreen((Screen)new BattleGUI());
        }
    }

    private final void checkForTargetInteractions(LocalPlayer player, Pokemon selectedPartyPokemon) {
        ClipContext.Fluid fluid;
        Class<LivingEntity> clazz = LivingEntity.class;
        float f = Cobblemon.INSTANCE.getConfig().getBattleSpectateMaxDistance();
        LivingEntity targetEntity = (LivingEntity)PlayerExtensionsKt.traceFirstEntityCollision$default((LivingEntity)player, f, 0.0f, clazz, (Entity)player, fluid = ClipContext.Fluid.NONE, 2, null);
        if (this.canSendOutPokemon(player, targetEntity)) {
            CobblemonNetwork.sendToServer(new SendOutPokemonPacket(CobblemonClient.INSTANCE.getStorage().getSelectedSlot()));
        } else {
            this.processEntityTarget(player, selectedPartyPokemon, targetEntity);
        }
    }

    private final boolean canSendOutPokemon(LocalPlayer player, LivingEntity target) {
        if (this.isRidingPokemon(player, true)) {
            return false;
        }
        return target == null || target instanceof PokemonEntity && Intrinsics.areEqual((Object)((PokemonEntity)target).getOwnerUUID(), (Object)player.getUUID());
    }

    private final void processEntityTarget(LocalPlayer player, Pokemon pokemon, LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (!this.canProcessEntityTarget(player, entity)) {
            return;
        }
        LivingEntity livingEntity = entity;
        if (livingEntity instanceof Player) {
            UUID uUID = ((Player)entity).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            int n = ((Player)entity).getId();
            UUID uUID2 = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
            CobblemonNetwork.sendToServer(new RequestPlayerInteractionsPacket(uUID, n, uUID2));
        } else if (livingEntity instanceof PokemonEntity) {
            if (!((PokemonEntity)entity).canBattle((Player)player) || ((PokemonEntity)entity).position().distanceToSqr(player.position()) > (double)((float)Math.pow(Cobblemon.INSTANCE.getConfig().getBattleWildMaxDistance(), 2))) {
                return;
            }
            int n = ((PokemonEntity)entity).getId();
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            CobblemonNetwork.sendToServer(new BattleChallengePacket(n, uUID, BattleFormat.Companion.getGEN_9_SINGLES()));
        }
    }

    private final boolean canProcessEntityTarget(LocalPlayer player, LivingEntity target) {
        LivingEntity livingEntity = target;
        return livingEntity instanceof Player ? !PartySendBinding.isRidingPokemon$default(this, player, false, 2, null) : (livingEntity instanceof PokemonEntity ? !this.isRidingPokemon(player, true) : true);
    }

    private final boolean canAttemptDismount(LocalPlayer player, Pokemon selectedPartyPokemon) {
        boolean bl;
        boolean hasLandRide;
        if (!(player.getVehicle() instanceof PokemonEntity)) {
            return false;
        }
        Entity entity = player.getVehicle();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
        PokemonEntity vehicle = (PokemonEntity)entity;
        if (!Intrinsics.areEqual((Object)player, (Object)vehicle.getControllingPassenger())) {
            return true;
        }
        Object object = vehicle.getRidingController();
        boolean isAirRide = (object != null && (object = ((RidingController)object).getContext()) != null ? ((ActiveRidingContext)object).getStyle() : null) == RidingStyle.AIR;
        Map<RidingStyle, RidingBehaviourSettings> map = vehicle.getRideProp().getBehaviours();
        boolean bl2 = hasLandRide = (map != null ? map.get((Object)RidingStyle.LAND) : null) != null;
        if (isAirRide && hasLandRide) {
            bl = false;
        } else {
            Pokemon pokemon = selectedPartyPokemon;
            bl = Intrinsics.areEqual((Object)vehicle.getPokemon().getUuid(), (Object)(pokemon != null ? pokemon.getUuid() : null));
        }
        return bl;
    }

    private final boolean isRidingPokemon(LocalPlayer player, boolean ignoreControlling) {
        if (!player.isPassenger()) {
            return false;
        }
        if (!(player.getVehicle() instanceof PokemonEntity)) {
            return false;
        }
        if (ignoreControlling) {
            Entity entity = player.getVehicle();
            Intrinsics.checkNotNull((Object)entity);
            if (Intrinsics.areEqual((Object)entity.getControllingPassenger(), (Object)player)) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ boolean isRidingPokemon$default(PartySendBinding partySendBinding, LocalPlayer localPlayer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return partySendBinding.isRidingPokemon(localPlayer, bl);
    }

    private final boolean isRidingSelectedPokemon(LocalPlayer player, Pokemon selectedPartyPokemon, boolean ignoreControlling) {
        if (!player.isPassenger()) {
            return false;
        }
        if (!(player.getVehicle() instanceof PokemonEntity)) {
            return false;
        }
        Entity entity = player.getVehicle();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
        PokemonEntity vehicle = (PokemonEntity)entity;
        if (ignoreControlling) {
            Entity entity2 = player.getVehicle();
            Intrinsics.checkNotNull((Object)entity2);
            if (Intrinsics.areEqual((Object)entity2.getControllingPassenger(), (Object)player)) {
                return false;
            }
        }
        return Intrinsics.areEqual((Object)vehicle.getPokemon().getUuid(), (Object)selectedPartyPokemon.getUuid());
    }

    static /* synthetic */ boolean isRidingSelectedPokemon$default(PartySendBinding partySendBinding, LocalPlayer localPlayer, Pokemon pokemon, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return partySendBinding.isRidingSelectedPokemon(localPlayer, pokemon, bl);
    }

    @Override
    public void onPress() {
    }
}

