/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.pokedex.widgets;

import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.ScrollingWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002,-B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u000e\u0010\tJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\tJ/\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017JW\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b#\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b$\u0010\tR\"\u0010&\u001a\u00020%8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget;", "Lcom/cobblemon/mod/common/client/gui/ScrollingWidget;", "Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget$DropWidgetEntry;", "", "pX", "pY", "<init>", "(II)V", "getX", "()I", "getY", "", "setEntries", "()V", "getScrollbarPosition", "getBottom", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "renderScrollbar", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "renderWidget", "index", "x", "y", "entryWidth", "entryHeight", "renderItem", "(Lnet/minecraft/client/gui/GuiGraphics;IIFIIIII)V", "getEntry", "(I)Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget$DropWidgetEntry;", "I", "getPX", "getPY", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "dropTable", "Lcom/cobblemon/mod/common/api/drop/DropTable;", "getDropTable", "()Lcom/cobblemon/mod/common/api/drop/DropTable;", "setDropTable", "(Lcom/cobblemon/mod/common/api/drop/DropTable;)V", "Companion", "DropWidgetEntry", "common"})
@SourceDebugExtension(value={"SMAP\nDropsScrollingWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropsScrollingWidget.kt\ncom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1869#2,2:209\n*S KotlinDebug\n*F\n+ 1 DropsScrollingWidget.kt\ncom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget\n*L\n54#1:209,2\n*E\n"})
public final class DropsScrollingWidget
extends ScrollingWidget<DropWidgetEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pX;
    private final int pY;
    @NotNull
    private DropTable dropTable;
    @NotNull
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public DropsScrollingWidget(int pX, int pY) {
        int n = pY + 10;
        super(n, pX, 137, 42, 10, 0, 32, null);
        this.pX = pX;
        this.pY = pY;
        this.dropTable = new DropTable();
        this.setEntries();
    }

    public final int getPX() {
        return this.pX;
    }

    public final int getPY() {
        return this.pY;
    }

    @NotNull
    public final DropTable getDropTable() {
        return this.dropTable;
    }

    public final void setDropTable(@NotNull DropTable dropTable) {
        Intrinsics.checkNotNullParameter((Object)dropTable, (String)"<set-?>");
        this.dropTable = dropTable;
    }

    public int getX() {
        return this.pX;
    }

    public int getY() {
        return this.pY;
    }

    public final void setEntries() {
        Iterable $this$forEach$iv = this.dropTable.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DropEntry it = (DropEntry)element$iv;
            boolean bl = false;
            if (!(it instanceof ItemDropEntry)) continue;
            this.addEntry((AbstractSelectionList.Entry)new DropWidgetEntry((ItemDropEntry)it));
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return this.getLeft() + this.width - this.getScrollBarWidth() - 7;
    }

    public int getBottom() {
        return this.getY() + this.height - 1;
    }

    @Override
    public void renderScrollbar(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int xLeft = this.getScrollbarPosition();
        int xRight = xLeft + 3;
        int yStart = this.getY() + 1;
        int barHeight = this.getBottom() - yStart;
        int yBottom = (int)((float)(barHeight * barHeight) / (float)this.getMaxPosition());
        yBottom = Mth.clamp((int)yBottom, (int)32, (int)(barHeight - 8));
        int yTop = (int)this.getScrollAmount() * (barHeight - yBottom) / this.getMaxScroll() + yStart;
        if (yTop < yStart) {
            yTop = yStart;
        }
        context.fill(xLeft + 1, yStart, xRight - 1, this.getBottom(), FastColor.ARGB32.color((int)255, (int)126, (int)231, (int)229));
        context.fill(xLeft, yTop, xRight, yTop + yBottom, FastColor.ARGB32.color((int)255, (int)58, (int)150, (int)182));
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("ui.pokedex.info.drops", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        RenderHelperKt.drawScaledText$default(context, resourceLocation, TextKt.bold(mutableComponent), this.pX, this.pY - 10, 0.0f, null, 0, 0, false, true, null, null, 7136, null);
        if (this.dropTable.getEntries().size() == 0) {
            MutableComponent mutableComponent2 = LocalizationUtilsKt.lang("ui.pokedex.info.drops_empty", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"lang(...)");
            MutableComponent mutableComponent3 = mutableComponent2;
            int n = this.pX + this.width / 2 - 7;
            int n2 = this.pY + this.height / 2 - 3;
            RenderHelperKt.drawScaledText$default(context, null, mutableComponent3, n, n2, 0.5f, null, 0, 6318958, true, false, null, null, 6338, null);
        } else {
            super.renderWidget(context, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void renderItem(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DropWidgetEntry entry = this.getEntry(index);
        entry.render(context, index, y + 2, x, entryWidth, entryHeight, mouseX, mouseY, Intrinsics.areEqual((Object)this.getHovered(), (Object)((Object)entry)), delta);
    }

    @NotNull
    protected DropWidgetEntry getEntry(int index) {
        Object e = this.children().get(index);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.gui.pokedex.widgets.DropsScrollingWidget.DropWidgetEntry");
        return (DropWidgetEntry)((Object)e);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget$Companion;", "", "<init>", "()V", "Ljava/text/DecimalFormat;", "df", "Ljava/text/DecimalFormat;", "getDf", "()Ljava/text/DecimalFormat;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalFormat getDf() {
            return df;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J_\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/client/gui/pokedex/widgets/DropsScrollingWidget$DropWidgetEntry;", "Lcom/cobblemon/mod/common/client/gui/ScrollingWidget$Slot;", "Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "entry", "<init>", "(Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "index", "y", "x", "entryWidth", "entryHeight", "mouseX", "mouseY", "", "hovered", "", "tickDelta", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V", "Lnet/minecraft/network/chat/Component;", "getNarration", "()Lnet/minecraft/network/chat/Component;", "Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "getEntry", "()Lcom/cobblemon/mod/common/api/drop/ItemDropEntry;", "common"})
    public static final class DropWidgetEntry
    extends ScrollingWidget.Slot<DropWidgetEntry> {
        @NotNull
        private final ItemDropEntry entry;

        public DropWidgetEntry(@NotNull ItemDropEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
        }

        @NotNull
        public final ItemDropEntry getEntry() {
            return this.entry;
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            MutableComponent mutableComponent;
            int max;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.pose().pushPose();
            context.pose().translate(0.0f, 0.0f, 100.0f);
            Item item = Minecraft.getInstance().player;
            if (item == null || (item = item.level()) == null || (item = WorldExtensionsKt.getItemRegistry((Level)item)) == null || (item = (Item)item.get(this.entry.getItem())) == null || (item = item.getDefaultInstance()) == null) {
                item = ItemStack.EMPTY;
            }
            Item itemStack = item;
            Intrinsics.checkNotNull(itemStack);
            Item item2 = itemStack;
            double d = x;
            double d2 = y;
            Object[] objectArray = context.pose();
            RenderHelperKt.renderScaledGuiItemIcon$default((ItemStack)item2, d, d2, 0.5, 0.0f, (PoseStack)objectArray, 16, null);
            context.pose().pushPose();
            IntRange intRange = this.entry.getQuantityRange();
            int min = intRange != null ? ((Number)((Object)CollectionsKt.minOrThrow((Iterable)((Iterable)intRange)))).intValue() : this.entry.getQuantity();
            IntRange intRange2 = this.entry.getQuantityRange();
            int n = max = intRange2 != null ? ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)((Iterable)intRange2)))).intValue() : this.entry.getQuantity();
            if (this.entry.getQuantityRange() != null) {
                var16_22 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)itemStack.getHoverName().copy().withStyle(ChatFormatting.BOLD), (String)"withStyle(...)");
                var18_24 = new Object[]{min, max};
                Intrinsics.checkNotNullExpressionValue((Object)LocalizationUtilsKt.lang("ui.pokedex.info.drops_range", var18_24), (String)"lang(...)");
                var15_17 = LocalizationUtilsKt.lang("ui.pokedex.info.drops_display", var16_22);
                Intrinsics.checkNotNull((Object)var15_17);
                mutableComponent = var15_17;
            } else {
                var16_22 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)itemStack.getHoverName().copy().withStyle(ChatFormatting.BOLD), (String)"withStyle(...)");
                var18_24 = new Object[]{this.entry.getQuantity()};
                Intrinsics.checkNotNullExpressionValue((Object)LocalizationUtilsKt.lang("ui.pokedex.info.drops_amount", var18_24), (String)"lang(...)");
                var15_17 = LocalizationUtilsKt.lang("ui.pokedex.info.drops_display", var16_22);
                Intrinsics.checkNotNull((Object)var15_17);
                mutableComponent = var15_17;
            }
            MutableComponent displayText = mutableComponent;
            int n2 = x + 10;
            int n3 = y + 2;
            RenderHelperKt.drawScaledText$default(context, null, displayText, n2, n3, 0.5f, null, 0, 6318958, false, false, null, null, 7874, null);
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)Companion.getDf().format(Float.valueOf(this.entry.getPercentage())), (String)"format(...)");
            MutableComponent mutableComponent2 = LocalizationUtilsKt.lang("ui.pokedex.info.drops_percentage", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"lang(...)");
            MutableComponent mutableComponent3 = mutableComponent2;
            n3 = x + 120;
            int n4 = y + 2;
            RenderHelperKt.drawScaledTextJustifiedRight$default(context, null, mutableComponent3, n3, n4, 0.5f, null, 0, 6318958, false, 706, null);
            context.pose().popPose();
            context.pose().popPose();
        }

        @NotNull
        public Component getNarration() {
            MutableComponent mutableComponent = Component.translatable((String)this.entry.getItem().toLanguageKey());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            return (Component)mutableComponent;
        }
    }
}

