/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.pc;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0012\b&\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J'\u0010)\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b)\u0010*R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u0010\u001fR\"\u00107\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/cobblemon/mod/common/client/gui/pc/TextWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "", "pX", "pY", "width", "height", "maxLength", "Lnet/minecraft/network/chat/Component;", "text", "Lkotlin/Function0;", "", "update", "<init>", "(IIIIILnet/minecraft/network/chat/Component;Lkotlin/jvm/functions/Function0;)V", "", "string", "Lnet/minecraft/network/chat/MutableComponent;", "placeholder", "applyTextCursor", "(Ljava/lang/String;Lnet/minecraft/network/chat/MutableComponent;)Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderCursor", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/MutableComponent;)V", "unfocused", "()V", "", "focused", "setFocused", "(Z)V", "", "mouseX", "mouseY", "button", "mouseClicked", "(DDI)Z", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "", "focusedTime", "J", "getFocusedTime", "()J", "setFocusedTime", "(J)V", "showCursor", "Z", "getShowCursor", "()Z", "setShowCursor", "startPosX", "I", "getStartPosX", "()I", "setStartPosX", "(I)V", "common"})
public abstract class TextWidget
extends EditBox
implements CobblemonRenderable {
    private long focusedTime;
    private boolean showCursor;
    private int startPosX;

    public TextWidget(int pX, int pY, int width, int height, int maxLength, @NotNull Component text, @NotNull Function0<Unit> update) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        super(Minecraft.getInstance().font, pX, pY, width, height, text);
        this.setMaxLength(maxLength);
        this.setResponder(arg_0 -> TextWidget._init_$lambda$0(update, arg_0));
        this.focusedTime = Util.getMillis();
        this.startPosX = this.getX();
    }

    public /* synthetic */ TextWidget(int n, int n2, int n3, int n4, int n5, Component component, Function0 function0, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 4) != 0) {
            n3 = 91;
        }
        if ((n6 & 8) != 0) {
            n4 = 14;
        }
        if ((n6 & 0x10) != 0) {
            n5 = 19;
        }
        if ((n6 & 0x20) != 0) {
            component = (Component)TextKt.text("TextWidget");
        }
        this(n, n2, n3, n4, n5, component, (Function0<Unit>)function0);
    }

    public final long getFocusedTime() {
        return this.focusedTime;
    }

    public final void setFocusedTime(long l) {
        this.focusedTime = l;
    }

    public final boolean getShowCursor() {
        return this.showCursor;
    }

    public final void setShowCursor(boolean bl) {
        this.showCursor = bl;
    }

    public final int getStartPosX() {
        return this.startPosX;
    }

    public final void setStartPosX(int n) {
        this.startPosX = n;
    }

    @NotNull
    public final MutableComponent applyTextCursor(@NotNull String string, @NotNull MutableComponent placeholder) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        boolean bl = this.showCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        return this.isFocused() ? TextKt.text(string + (this.getCursorPosition() == string.length() && this.showCursor ? "_" : "")) : (((CharSequence)string).length() == 0 ? placeholder : TextKt.text(string));
    }

    public final void renderCursor(@NotNull GuiGraphics context, @NotNull MutableComponent text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.showCursor) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (!(((CharSequence)string).length() == 0) && this.getCursorPosition() != this.getValue().length()) {
                Font font = Minecraft.getInstance().font;
                String string2 = text.getString(this.getCursorPosition());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                MutableComponent mutableComponent = TextKt.bold(TextKt.text(string2));
                ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-DEFAULT_LARGE>(...)");
                int startToCursorWidth = font.width((FormattedText)TextKt.font(mutableComponent, resourceLocation));
                context.fill(RenderType.guiTextHighlight(), this.startPosX + startToCursorWidth - 1, this.getY() + 2, this.startPosX + startToCursorWidth, this.getY() + 11, -3092272);
            }
        }
    }

    public void unfocused() {
        this.setFocused(false);
    }

    public void setFocused(boolean focused) {
        if (focused) {
            this.focusedTime = Util.getMillis();
        }
        super.setFocused(focused);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isFocused() && !this.isMouseOver(mouseX, mouseY)) {
            this.unfocused();
        }
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        Font font = Minecraft.getInstance().font;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        MutableComponent mutableComponent = TextKt.bold(TextKt.text(string));
        ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-DEFAULT_LARGE>(...)");
        if (mouseX > (double)(this.startPosX + font.width((FormattedText)TextKt.font(mutableComponent, resourceLocation)))) {
            this.moveCursorToEnd(false);
        } else {
            Object lineSubstring = "";
            String string2 = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            String string3 = string2;
            int n = string3.length();
            for (int i = 0; i < n; ++i) {
                char c = string3.charAt(i);
                lineSubstring = (String)lineSubstring + c;
                Font font2 = Minecraft.getInstance().font;
                MutableComponent mutableComponent2 = TextKt.bold(TextKt.text((String)lineSubstring));
                ResourceLocation resourceLocation2 = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"<get-DEFAULT_LARGE>(...)");
                int startToLineWidth = font2.width((FormattedText)TextKt.font(mutableComponent2, resourceLocation2));
                if (mouseX - (double)this.startPosX <= (double)startToLineWidth) break;
            }
            this.moveCursorTo(Math.max(0, ((String)lineSubstring).length() - 1), Screen.hasShiftDown());
        }
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFocused() && (keyCode == 257 || keyCode == 335)) {
            this.unfocused();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static final void _init_$lambda$0(Function0 $update, String it) {
        $update.invoke();
    }
}

