/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.npc.widgets;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014Bs\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010#\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010(R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u0013\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010)\u001a\u0004\b,\u0010+R\"\u0010.\u001a\u00020-8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/client/gui/npc/widgets/SimpleNPCTextInputWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lkotlin/Function0;", "", "getter", "Lnet/minecraft/resources/ResourceLocation;", "texture", "Lkotlin/Function1;", "", "setter", "", "posX", "posY", "width", "height", "maxLength", "", "shadow", "wrap", "<init>", "(Lkotlin/jvm/functions/Function0;Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function1;IIIIIZZ)V", "focused", "setFocused", "(Z)V", "", "mouseX", "mouseY", "button", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "Lkotlin/jvm/functions/Function1;", "Z", "getShadow", "()Z", "getWrap", "", "focusedTime", "J", "getFocusedTime", "()J", "setFocusedTime", "(J)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSimpleNPCTextInputWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleNPCTextInputWidget.kt\ncom/cobblemon/mod/common/client/gui/npc/widgets/SimpleNPCTextInputWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1878#2,3:151\n*S KotlinDebug\n*F\n+ 1 SimpleNPCTextInputWidget.kt\ncom/cobblemon/mod/common/client/gui/npc/widgets/SimpleNPCTextInputWidget\n*L\n81#1:151,3\n*E\n"})
public final class SimpleNPCTextInputWidget
extends EditBox
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ResourceLocation texture;
    @NotNull
    private final Function1<String, Unit> setter;
    private final boolean shadow;
    private final boolean wrap;
    private long focusedTime;
    public static final int TEXT_PADDING = 4;

    public SimpleNPCTextInputWidget(@NotNull Function0<String> getter, @Nullable ResourceLocation texture, @NotNull Function1<? super String, Unit> setter, int posX, int posY, int width, int height, int maxLength, boolean shadow, boolean wrap) {
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        Intrinsics.checkNotNullParameter(setter, (String)"setter");
        super(Minecraft.getInstance().font, posX + 4, posY, width, height, (Component)TextKt.text("input"));
        this.texture = texture;
        this.setter = setter;
        this.shadow = shadow;
        this.wrap = wrap;
        this.setMaxLength(maxLength);
        this.setFocused(true);
        this.focusedTime = Util.getMillis();
        this.setValue((String)getter.invoke());
        this.setResponder(arg_0 -> SimpleNPCTextInputWidget._init_$lambda$0(this, arg_0));
        this.setFocused(false);
        this.setBordered(false);
    }

    public /* synthetic */ SimpleNPCTextInputWidget(Function0 function0, ResourceLocation resourceLocation, Function1 function1, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 2) != 0) {
            resourceLocation = null;
        }
        if ((n6 & 0x80) != 0) {
            n5 = 100;
        }
        if ((n6 & 0x100) != 0) {
            bl = true;
        }
        if ((n6 & 0x200) != 0) {
            bl2 = false;
        }
        this((Function0<String>)function0, resourceLocation, (Function1<? super String, Unit>)function1, n, n2, n3, n4, n5, bl, bl2);
    }

    @Nullable
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    public final boolean getShadow() {
        return this.shadow;
    }

    public final boolean getWrap() {
        return this.wrap;
    }

    public final long getFocusedTime() {
        return this.focusedTime;
    }

    public final void setFocusedTime(long l) {
        this.focusedTime = l;
    }

    public void setFocused(boolean focused) {
        if (focused) {
            this.focusedTime = Util.getMillis();
        }
        super.setFocused(focused);
    }

    /*
     * WARNING - void declaration
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedState = super.mouseClicked(mouseX, mouseY, button);
        if (this.wrap) {
            List splitLines = Minecraft.getInstance().font.getSplitter().splitLines(this.getValue(), this.width - 8, Style.EMPTY);
            int clickedLineIndex = (int)Math.floor((mouseY - (double)this.getY()) / (double)11);
            if (clickedLineIndex >= 0 && splitLines.size() > clickedLineIndex) {
                FormattedText lineAtIndex = (FormattedText)splitLines.get(clickedLineIndex);
                Object lineSubstring = null;
                lineSubstring = "";
                String string = lineAtIndex.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String string2 = string;
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    lineSubstring = "" + lineSubstring + c;
                    int startToLineWidth = Minecraft.getInstance().font.width((FormattedText)TextKt.text((String)lineSubstring));
                    if (mouseX - (double)this.getX() <= (double)startToLineWidth) break;
                }
                Object unwrappedLine = null;
                unwrappedLine = "";
                Intrinsics.checkNotNull((Object)splitLines);
                Iterable $this$forEachIndexed$iv = splitLines;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    FormattedText formattedText = (FormattedText)item$iv;
                    int index = n2;
                    boolean bl = false;
                    if (index == clickedLineIndex) {
                        unwrappedLine = "" + unwrappedLine + lineSubstring;
                        continue;
                    }
                    if (index >= clickedLineIndex) continue;
                    unwrappedLine = unwrappedLine + line.getString();
                }
                this.moveCursorTo(Math.max(0, ((String)unwrappedLine).length() - 1), Screen.hasShiftDown());
            }
        }
        return clickedState;
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.texture != null) {
            PoseStack poseStack = context.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            PoseStack poseStack2 = poseStack;
            int n = this.getX();
            int n2 = this.getY();
            int n3 = this.width;
            int n4 = this.height;
            ResourceLocation resourceLocation = this.texture;
            GuiUtilsKt.blitk$default(poseStack2, resourceLocation, n, n2, n4, n3, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        }
        if (this.wrap) {
            boolean showCursor;
            boolean bl = showCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
            String input = this.isFocused() ? this.getValue() + (this.getCursorPosition() == this.getValue().length() && showCursor ? "_" : "") : this.getValue();
            String cursorLine = "";
            int cursorLineIndex = -1;
            int cursorLinePos = 0;
            int accumlatedLength = 0;
            List wrappedLines = Minecraft.getInstance().font.getSplitter().splitLines(input, this.width - 8, Style.EMPTY);
            Iterator iterator = ((Iterable)wrappedLines).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                FormattedText line = (FormattedText)iterator.next();
                if (cursorLineIndex < 0 && (accumlatedLength += line.getString().length()) > this.getCursorPosition()) {
                    cursorLineIndex = index;
                    Intrinsics.checkNotNullExpressionValue((Object)line.getString(), (String)"getString(...)");
                    cursorLinePos = cursorLineIndex > 0 ? this.getCursorPosition() - (accumlatedLength - line.getString().length()) : this.getCursorPosition();
                }
                String string = line.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                RenderHelperKt.drawScaledText$default(context, null, TextKt.text(string), this.getX(), this.getY() + index * 10 + 1, 0.0f, null, 0, 0xDDDDDD, false, true, null, null, 6882, null);
            }
            if (showCursor) {
                String string = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!(((CharSequence)string).length() == 0) && this.getCursorPosition() != this.getValue().length()) {
                    Font font = Minecraft.getInstance().font;
                    String string2 = cursorLine.substring(0, cursorLinePos);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int startToCursorWidth = font.width((FormattedText)TextKt.text(string2));
                    context.fill(RenderType.guiTextHighlight(), this.getX() + startToCursorWidth - 1, this.getY() + cursorLineIndex * 10 + 1, this.getX() + startToCursorWidth, this.getY() + (cursorLineIndex * 10 + 1) + 9, -3092272);
                }
            }
        } else {
            super.renderWidget(context, mouseX, mouseY, delta);
        }
    }

    private static final void _init_$lambda$0(SimpleNPCTextInputWidget this$0, String it) {
        Function1<String, Unit> function1 = this$0.setter;
        Intrinsics.checkNotNull((Object)it);
        function1.invoke((Object)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/client/gui/npc/widgets/SimpleNPCTextInputWidget$Companion;", "", "<init>", "()V", "", "TEXT_PADDING", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

