/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.battle.widgets;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.battle.ClientBattleMessageQueue;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002:;B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0010J\u000f\u0010\u001b\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u001b\u0010\u0010J/\u0010!\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J'\u0010&\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b&\u0010'J7\u0010*\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020#H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010,\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020#H\u0002\u00a2\u0006\u0004\b,\u0010-R\"\u0010.\u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0016\u00104\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0011\u00107\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0010R\u0011\u00109\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0010\u00a8\u0006<"}, d2={"Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane;", "Lnet/minecraft/client/gui/components/ObjectSelectionList;", "Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane$BattleMessageLine;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/cobblemon/mod/common/client/battle/ClientBattleMessageQueue;", "messageQueue", "<init>", "(Lcom/cobblemon/mod/common/client/battle/ClientBattleMessageQueue;)V", "", "correctSize", "()V", "entry", "", "addEntry", "(Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane$BattleMessageLine;)I", "getRowLeft", "()I", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "top", "width", "height", "outerColor", "innerColor", "renderSelection", "(Lnet/minecraft/client/gui/GuiGraphics;IIIII)V", "getRowWidth", "getScrollbarPosition", "context", "mouseX", "mouseY", "", "partialTicks", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "", "button", "", "mouseClicked", "(DDI)Z", "deltaX", "deltaY", "mouseDragged", "(DDIDD)Z", "updateScrollingState", "(DD)V", "opacity", "F", "getOpacity", "()F", "setOpacity", "(F)V", "scrolling", "Z", "getAppropriateX", "appropriateX", "getAppropriateY", "appropriateY", "Companion", "BattleMessageLine", "common"})
public final class BattleMessagePane
extends ObjectSelectionList<BattleMessageLine>
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float opacity;
    private boolean scrolling;
    public static final int LINE_HEIGHT = 10;
    public static final int LINE_WIDTH = 146;
    public static final int FRAME_WIDTH = 169;
    public static final int FRAME_HEIGHT = 55;
    public static final int FRAME_EXPANDED_HEIGHT = 101;
    public static final int TEXT_BOX_WIDTH = 153;
    public static final int TEXT_BOX_HEIGHT = 46;
    public static final int EXPAND_TOGGLE_SIZE = 5;
    @NotNull
    private static final ResourceLocation battleMessagePaneFrameResource = MiscUtilsKt.cobblemonResource("textures/gui/battle/battle_log.png");
    @NotNull
    private static final ResourceLocation battleMessagePaneFrameExpandedResource = MiscUtilsKt.cobblemonResource("textures/gui/battle/battle_log_expanded.png");
    @NotNull
    private static final ResourceLocation battleMessageHighlight = MiscUtilsKt.cobblemonResource("textures/gui/battle/battle_log_row_selected_color.png");
    private static boolean expanded;

    public BattleMessagePane(@NotNull ClientBattleMessageQueue messageQueue) {
        Intrinsics.checkNotNullParameter((Object)messageQueue, (String)"messageQueue");
        super(Minecraft.getInstance(), 169, 55, 1, 10);
        this.opacity = 1.0f;
        this.correctSize();
        messageQueue.subscribe((Function1<? super FormattedCharSequence, Unit>)((Function1)arg_0 -> BattleMessagePane._init_$lambda$0(this, arg_0)));
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final void setOpacity(float f) {
        this.opacity = f;
    }

    public final int getAppropriateX() {
        return this.minecraft.getWindow().getGuiScaledWidth() - 181;
    }

    public final int getAppropriateY() {
        return this.minecraft.getWindow().getGuiScaledHeight() - (30 + (expanded ? 101 : 55));
    }

    private final void correctSize() {
        int textBoxHeight = expanded ? 92 : 46;
        this.setRectangle(153, textBoxHeight, this.getAppropriateY() + 6, this.getAppropriateY() + 6);
        this.setX(this.getAppropriateX());
    }

    protected int addEntry(@NotNull BattleMessageLine entry) {
        Intrinsics.checkNotNullParameter((Object)((Object)entry), (String)"entry");
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public int getRowLeft() {
        return super.getRowLeft() + 4;
    }

    protected void renderSelection(@NotNull GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        PoseStack poseStack = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack, battleMessageHighlight, this.getX() + 6, top - 2, 10, 1, null, null, null, null, null, null, null, null, Float.valueOf(this.opacity), false, 0.0f, 114624, null);
        PoseStack poseStack2 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack2, battleMessageHighlight, this.getX() + 6, top - 2, 1, 146, null, null, null, null, null, null, null, null, Float.valueOf(this.opacity), false, 0.0f, 114624, null);
        PoseStack poseStack3 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack3, battleMessageHighlight, this.getX() + 6, top + 7, 1, 146, null, null, null, null, null, null, null, null, Float.valueOf(this.opacity), false, 0.0f, 114624, null);
        PoseStack poseStack4 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack4, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack4, battleMessageHighlight, this.getX() + 6 + 146 - 1, top - 2, 10, 1, null, null, null, null, null, null, null, null, Float.valueOf(this.opacity), false, 0.0f, 114624, null);
    }

    public int getRowWidth() {
        return 146;
    }

    protected int getScrollbarPosition() {
        return this.getX() + 154;
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.correctSize();
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiUtilsKt.blitk$default(poseStack, expanded ? battleMessagePaneFrameExpandedResource : battleMessagePaneFrameResource, this.getX(), this.getAppropriateY(), expanded ? 101 : 55, 169, null, null, null, null, null, null, null, null, Float.valueOf(this.opacity), false, 0.0f, 114624, null);
        int textBoxHeight = expanded ? 92 : 46;
        context.enableScissor(this.getX() + 5, this.getAppropriateY() + 6, this.getX() + 5 + this.width, this.getAppropriateY() + 6 + textBoxHeight);
        super.renderWidget(context, mouseX, mouseY, partialTicks);
        context.disableScissor();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int toggleOffsetY;
        int n = toggleOffsetY = expanded ? 92 : 46;
        if (mouseX > (double)(this.getX() + 160) && mouseX < (double)(this.getX() + 160 + 5) && mouseY > (double)(this.getAppropriateY() + toggleOffsetY) && mouseY < (double)(this.getAppropriateY() + toggleOffsetY + 5)) {
            expanded = !expanded;
        }
        this.updateScrollingState(mouseX, mouseY);
        if (this.scrolling) {
            this.setFocused((GuiEventListener)this.getEntryAtPosition(mouseX, mouseY));
            this.setDragging(true);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.getBottom()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                this.setScrollAmount(this.getScrollAmount() + deltaY);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private final void updateScrollingState(double mouseX, double mouseY) {
        this.scrolling = mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 3) && mouseY >= (double)this.getY() && mouseY < (double)this.getBottom();
    }

    private static final Unit _init_$lambda$0(BattleMessagePane this$0, FormattedCharSequence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean fullyScrolledDown = (double)this$0.getMaxScroll() - this$0.getScrollAmount() < 10.0;
        this$0.addEntry(new BattleMessageLine(this$0, it));
        if (fullyScrolledDown) {
            this$0.setScrollAmount(this$0.getMaxScroll());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ_\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane$BattleMessageLine;", "Lnet/minecraft/client/gui/components/ObjectSelectionList$Entry;", "Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane;", "pane", "Lnet/minecraft/util/FormattedCharSequence;", "line", "<init>", "(Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane;Lnet/minecraft/util/FormattedCharSequence;)V", "Lnet/minecraft/network/chat/MutableComponent;", "getNarration", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "index", "rowTop", "rowLeft", "rowWidth", "rowHeight", "mouseX", "mouseY", "", "isHovered", "", "partialTicks", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V", "Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane;", "getPane", "()Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane;", "Lnet/minecraft/util/FormattedCharSequence;", "getLine", "()Lnet/minecraft/util/FormattedCharSequence;", "common"})
    public static final class BattleMessageLine
    extends ObjectSelectionList.Entry<BattleMessageLine> {
        @NotNull
        private final BattleMessagePane pane;
        @NotNull
        private final FormattedCharSequence line;

        public BattleMessageLine(@NotNull BattleMessagePane pane, @NotNull FormattedCharSequence line) {
            Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.pane = pane;
            this.line = line;
        }

        @NotNull
        public final BattleMessagePane getPane() {
            return this.pane;
        }

        @NotNull
        public final FormattedCharSequence getLine() {
            return this.line;
        }

        @NotNull
        public MutableComponent getNarration() {
            return TextKt.text("");
        }

        public void render(@NotNull GuiGraphics context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            RenderHelperKt.drawScaledText$default(context, this.line, rowLeft, rowTop - 2, 0.0f, 0.0f, Float.valueOf(this.pane.getOpacity()), 0, false, false, 944, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/client/gui/battle/widgets/BattleMessagePane$Companion;", "", "<init>", "()V", "", "LINE_HEIGHT", "I", "LINE_WIDTH", "FRAME_WIDTH", "FRAME_HEIGHT", "FRAME_EXPANDED_HEIGHT", "TEXT_BOX_WIDTH", "TEXT_BOX_HEIGHT", "EXPAND_TOGGLE_SIZE", "Lnet/minecraft/resources/ResourceLocation;", "battleMessagePaneFrameResource", "Lnet/minecraft/resources/ResourceLocation;", "battleMessagePaneFrameExpandedResource", "battleMessageHighlight", "", "expanded", "Z", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

