/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.api.multiblock.MultiblockEntity;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.multiblock.builder.MultiblockStructureBuilder;
import com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\b\u0002\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR.\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b8V@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/block/entity/FossilMultiblockEntity;", "Lcom/cobblemon/mod/common/api/multiblock/MultiblockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;", "multiblockBuilder", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;Lnet/minecraft/world/level/block/entity/BlockEntityType;)V", "", "setRemoved", "()V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "loadAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "masterBlockPos", "Lnet/minecraft/core/BlockPos;", "getMasterBlockPos", "()Lnet/minecraft/core/BlockPos;", "setMasterBlockPos", "(Lnet/minecraft/core/BlockPos;)V", "Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "structure", "multiblockStructure", "Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "getMultiblockStructure", "()Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;", "setMultiblockStructure", "(Lcom/cobblemon/mod/common/api/multiblock/MultiblockStructure;)V", "common"})
public class FossilMultiblockEntity
extends MultiblockEntity {
    @Nullable
    private BlockPos masterBlockPos;
    @Nullable
    private MultiblockStructure multiblockStructure;

    public FossilMultiblockEntity(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull MultiblockStructureBuilder multiblockBuilder, @NotNull BlockEntityType<?> type) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)multiblockBuilder, (String)"multiblockBuilder");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type, pos, state, multiblockBuilder);
    }

    public /* synthetic */ FossilMultiblockEntity(BlockPos blockPos, BlockState blockState, MultiblockStructureBuilder multiblockStructureBuilder, BlockEntityType blockEntityType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            blockEntityType = CobblemonBlockEntities.FOSSIL_MULTIBLOCK;
        }
        this(blockPos, blockState, multiblockStructureBuilder, blockEntityType);
    }

    @Override
    @Nullable
    public BlockPos getMasterBlockPos() {
        return this.masterBlockPos;
    }

    @Override
    public void setMasterBlockPos(@Nullable BlockPos blockPos) {
        this.masterBlockPos = blockPos;
    }

    @Override
    @Nullable
    public MultiblockStructure getMultiblockStructure() {
        if (this.getMasterBlockPos() != null && !Intrinsics.areEqual((Object)this.getMasterBlockPos(), (Object)this.getBlockPos())) {
            ChunkPos chunkPos = new ChunkPos(this.getMasterBlockPos());
            Level level = this.level;
            boolean bl = level != null && (level = level.getChunkSource()) != null ? level.hasChunk(chunkPos.x, chunkPos.z) : false;
            if (bl) {
                FossilMultiblockEntity entity;
                Level level2 = this.level;
                BlockEntity blockEntity = level2 != null ? level2.getBlockEntity(this.getMasterBlockPos()) : null;
                FossilMultiblockEntity fossilMultiblockEntity = entity = blockEntity instanceof FossilMultiblockEntity ? (FossilMultiblockEntity)blockEntity : null;
                this.multiblockStructure = fossilMultiblockEntity != null ? fossilMultiblockEntity.getMultiblockStructure() : null;
            }
        }
        return this.multiblockStructure;
    }

    @Override
    public void setMultiblockStructure(@Nullable MultiblockStructure structure) {
        this.multiblockStructure = structure;
        if (structure != null) {
            this.setMasterBlockPos(structure.getControllerBlockPos());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.getMultiblockStructure() != null && this.level != null) {
            MultiblockStructure multiblockStructure = this.getMultiblockStructure();
            Intrinsics.checkNotNull((Object)multiblockStructure);
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            multiblockStructure.setRemoved(level);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        MultiblockStructure multiblockStructure;
        FossilMultiblockStructure oldMultiblockStructure;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        MultiblockStructure multiblockStructure2 = this.getMultiblockStructure();
        FossilMultiblockStructure fossilMultiblockStructure = oldMultiblockStructure = multiblockStructure2 instanceof FossilMultiblockStructure ? (FossilMultiblockStructure)multiblockStructure2 : null;
        if (nbt.contains("MultiblockStore")) {
            FossilMultiblockStructure fossilMultiblockStructure2;
            FossilMultiblockStructure fossilMultiblockStructure3 = oldMultiblockStructure;
            if ((fossilMultiblockStructure3 != null ? fossilMultiblockStructure3.getFossilState() : null) != null) {
                int animAge = oldMultiblockStructure.getFossilState().peekAge();
                float partialTicks = oldMultiblockStructure.getFossilState().getPartialTicks();
                CompoundTag compoundTag = nbt.getCompound("MultiblockStore");
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                fossilMultiblockStructure2 = FossilMultiblockStructure.Companion.fromNbt(compoundTag, registryLookup, animAge, partialTicks);
            } else {
                CompoundTag compoundTag = nbt.getCompound("MultiblockStore");
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
                fossilMultiblockStructure2 = FossilMultiblockStructure.Companion.fromNbt$default(FossilMultiblockStructure.Companion, compoundTag, registryLookup, 0, 0.0f, 12, null);
            }
            multiblockStructure = fossilMultiblockStructure2;
        } else {
            multiblockStructure = null;
        }
        this.setMultiblockStructure(multiblockStructure);
        this.setMasterBlockPos(nbt.contains("ControllerBlock") ? (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"ControllerBlock").get() : null);
    }
}

