/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.block.SaccharineLogBlock;
import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJG\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ?\u0010$\u001a\u00020#2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020!H\u0014\u00a2\u0006\u0004\b$\u0010%J#\u0010(\u001a\u00020#2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000b0&H\u0014\u00a2\u0006\u0004\b(\u0010)J5\u00100\u001a\u00020#2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101\u00a8\u00063"}, d2={"Lcom/cobblemon/mod/common/block/SaccharineLogSlatheredBlock;", "Lnet/minecraft/world/level/block/HorizontalDirectionalBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/ItemInteractionResult;", "useItemOn", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/ItemInteractionResult;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Block;", "neighborBlock", "neighborPos", "", "movedByPiston", "", "neighborChanged", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/particles/ParticleOptions;", "particle", "Lnet/minecraft/core/Direction;", "direction", "", "amount", "spawnParticlesAtBlockFace", "(Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;I)V", "Companion", "common"})
public final class SaccharineLogSlatheredBlock
extends HorizontalDirectionalBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int HONEY_TYPE_MAX = 5;
    @NotNull
    private static final MapCodec<SaccharineLogSlatheredBlock> CODEC;
    @NotNull
    private static final IntegerProperty HONEY_TYPE;

    public SaccharineLogSlatheredBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)HONEY_TYPE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<SaccharineLogSlatheredBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        ItemStack itemStack = player.getItemInHand(hand);
        Item waterBottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER).getItem();
        Direction blockFace = hitResult.getDirection();
        if (itemStack.is(waterBottle) && state.getValue((Property)HorizontalDirectionalBlock.FACING) == blockFace) {
            if (!level.isClientSide) {
                BlockState newState = (BlockState)CobblemonBlocks.SACCHARINE_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, state.getValue((Property)RotatedPillarBlock.AXIS));
                level.playSound(null, pos, SoundEvents.GENERIC_SWIM, SoundSource.BLOCKS);
                Intrinsics.checkNotNull((Object)newState);
                SaccharineLogBlock.Companion.changeLogType(level, pos, newState, player, itemStack);
            }
            SimpleParticleType simpleParticleType = ParticleTypes.SPLASH;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SPLASH");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            Intrinsics.checkNotNull((Object)blockFace);
            this.spawnParticlesAtBlockFace(particleOptions, level, pos, blockFace, 40);
            return ItemInteractionResult.SUCCESS;
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (player == null || (player = player.getDirection()) == null) {
            player = Direction.NORTH;
        }
        if ((direction = player.getOpposite()) != Direction.UP && direction != Direction.DOWN) {
            int randomType = Random.Default.nextInt(0, 6);
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).setValue((Property)HONEY_TYPE, (Comparable)Integer.valueOf(randomType));
        }
        return super.getStateForPlacement(context);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborBlock, (String)"neighborBlock");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        Direction facingDirection = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos targetPos = pos.relative(facingDirection);
        if (Intrinsics.areEqual((Object)neighborPos, (Object)targetPos) && (fluidState = level.getFluidState(neighborPos)).getAmount() > 3) {
            BlockState newState = (BlockState)CobblemonBlocks.SACCHARINE_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, state.getValue((Property)RotatedPillarBlock.AXIS));
            level.playSound(null, pos, SoundEvents.GENERIC_SWIM, SoundSource.BLOCKS);
            Intrinsics.checkNotNull((Object)newState);
            SaccharineLogBlock.Companion.changeLogType$default(SaccharineLogBlock.Companion, level, pos, newState, null, null, 24, null);
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING};
        builder.add(propertyArray);
        propertyArray = new Property[]{RotatedPillarBlock.AXIS};
        builder.add(propertyArray);
        propertyArray = new Property[]{HONEY_TYPE};
        builder.add(propertyArray);
    }

    public final void spawnParticlesAtBlockFace(@NotNull ParticleOptions particle, @NotNull Level level, @NotNull BlockPos pos, @NotNull Direction direction, int amount) {
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        RandomSource random = level.random;
        for (int i = 0; i < amount; ++i) {
            int it = i;
            boolean bl = false;
            Triple triple = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> new Triple((Object)((double)pos.getX() + random.nextDouble()), (Object)((double)pos.getY() + 1.0), (Object)((double)pos.getZ() + random.nextDouble()));
                case 2 -> new Triple((Object)((double)pos.getX() + random.nextDouble()), (Object)((double)pos.getY() + 0.0), (Object)((double)pos.getZ() + random.nextDouble()));
                case 3 -> new Triple((Object)((double)pos.getX() + random.nextDouble()), (Object)((double)pos.getY() + random.nextDouble()), (Object)((double)pos.getZ() + 0.0));
                case 4 -> new Triple((Object)((double)pos.getX() + random.nextDouble()), (Object)((double)pos.getY() + random.nextDouble()), (Object)((double)pos.getZ() + 1.0));
                case 5 -> new Triple((Object)((double)pos.getX() + 1.0), (Object)((double)pos.getY() + random.nextDouble()), (Object)((double)pos.getZ() + random.nextDouble()));
                case 6 -> new Triple((Object)((double)pos.getX() + 0.0), (Object)((double)pos.getY() + random.nextDouble()), (Object)((double)pos.getZ() + random.nextDouble()));
                default -> null;
            };
            if (triple == null) continue;
            Triple triple2 = triple;
            double posX = ((Number)triple2.component1()).doubleValue();
            double posY = ((Number)triple2.component2()).doubleValue();
            double posZ = ((Number)triple2.component3()).doubleValue();
            level.addParticle(particle, posX, posY, posZ, 0.0, 0.0, 0.0);
        }
    }

    static {
        MapCodec mapCodec = HorizontalDirectionalBlock.simpleCodec(SaccharineLogSlatheredBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        IntegerProperty integerProperty = IntegerProperty.create((String)"honey_type", (int)0, (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        HONEY_TYPE = integerProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/block/SaccharineLogSlatheredBlock$Companion;", "", "<init>", "()V", "Lnet/minecraft/core/dispenser/DispenseItemBehavior;", "createBehavior", "()Lnet/minecraft/core/dispenser/DispenseItemBehavior;", "", "HONEY_TYPE_MAX", "I", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/SaccharineLogSlatheredBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "HONEY_TYPE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getHONEY_TYPE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SaccharineLogSlatheredBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final IntegerProperty getHONEY_TYPE() {
            return HONEY_TYPE;
        }

        @NotNull
        public final DispenseItemBehavior createBehavior() {
            return Companion::createBehavior$lambda$0;
        }

        private static final ItemStack createBehavior$lambda$0(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            BlockState blockState = level.getBlockState(pos);
            Item waterBottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER).getItem();
            if (blockState.getBlock() instanceof SaccharineLogSlatheredBlock && stack.is(waterBottle)) {
                BlockState newState = (BlockState)CobblemonBlocks.SACCHARINE_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, blockState.getValue((Property)RotatedPillarBlock.AXIS));
                Intrinsics.checkNotNull((Object)level);
                Intrinsics.checkNotNull((Object)pos);
                Intrinsics.checkNotNull((Object)newState);
                Intrinsics.checkNotNull((Object)stack);
                Intrinsics.checkNotNull((Object)source);
                SaccharineLogBlock.Companion.changeLogTypeDispenser(level, pos, newState, stack, source);
            }
            return stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

