/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.world.BigRootPropagatedEvent;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.block.ShearableBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b&\u0018\u0000 L2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001LB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b!\u0010\"J?\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b(\u0010)J'\u0010*\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b*\u0010+J/\u0010,\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b,\u0010-J/\u0010.\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u0002002\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b1\u00102J%\u00103\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b3\u00104J5\u00107\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001305H\u0016\u00a2\u0006\u0004\b7\u00108J'\u00109\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0004\u00a2\u0006\u0004\b9\u0010+J'\u0010:\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000fH\u0004\u00a2\u0006\u0004\b:\u0010\"J\u0017\u0010;\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0004\u00a2\u0006\u0004\b;\u0010<JJ\u0010B\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u000f2!\u0010A\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(@\u0012\u0004\u0012\u00020\n0=H\u0004\u00a2\u0006\u0004\bB\u0010CJ\u000f\u0010D\u001a\u00020\bH$\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010G\u001a\u00020FH$\u00a2\u0006\u0004\bG\u0010HR\u001a\u0010J\u001a\b\u0012\u0004\u0012\u00020#0I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010K\u00a8\u0006M"}, d2={"Lcom/cobblemon/mod/common/block/RootBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lcom/cobblemon/mod/common/block/ShearableBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "isRandomlyTicking", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/util/RandomSource;", "random", "", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "hasReachedSpreadCap", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "isValidBonemealTarget", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "isBonemealSuccess", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "spreadFrom", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lkotlin/Function0;", "successCallback", "attemptShear", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function0;)Z", "canSpread", "canSpreadTo", "spreadingRoot", "(Lnet/minecraft/util/RandomSource;)Lnet/minecraft/world/level/block/state/BlockState;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "ceiling", "ceilingValidator", "canGoOn", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function1;)Z", "shearedResultingState", "()Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/item/ItemStack;", "shearedDrop", "()Lnet/minecraft/world/item/ItemStack;", "", "possibleDirections", "Ljava/util/Set;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nRootBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootBlock.kt\ncom/cobblemon/mod/common/block/RootBlock\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable$postThen$1\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n39#2,2:218\n41#2,2:223\n44#2,3:226\n47#2:231\n17#3,2:220\n19#3:230\n13805#4:222\n13806#4:229\n39#5:225\n1761#6,3:232\n*S KotlinDebug\n*F\n+ 1 RootBlock.kt\ncom/cobblemon/mod/common/block/RootBlock\n*L\n121#1:218,2\n121#1:223,2\n121#1:226,3\n121#1:231\n121#1:220,2\n121#1:230\n121#1:222\n121#1:229\n121#1:225\n156#1:232,3\n*E\n"})
public abstract class RootBlock
extends Block
implements BonemealableBlock,
ShearableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Direction> possibleDirections;
    public static final int MAX_PROPAGATING_LIGHT_LEVEL = 11;

    public RootBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        Object[] objectArray = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        this.possibleDirections = SetsKt.setOf((Object[])objectArray);
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (random.nextDouble() < Cobblemon.INSTANCE.getConfig().getBigRootPropagationChance() && world.getMaxLocalRawBrightness(pos) < 11 && !this.hasReachedSpreadCap((Level)world, pos)) {
            this.spreadFrom(world, pos, random);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.is(Items.SHEARS)) {
            this.attemptShear(world, state, pos, (Function0<Unit>)((Function0)() -> RootBlock.useWithoutItem$lambda$0(stack, player)));
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)world.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(state, world, pos, player, blockHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    public final boolean hasReachedSpreadCap(@NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int nearby = 0;
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!world.getBlockState(blockPos).is(CobblemonBlockTags.ROOTS) || ++nearby < Cobblemon.INSTANCE.getConfig().getMaxRootsInArea()) continue;
            return true;
        }
        return false;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.canGoOn(state, world, pos, (Function1<? super BlockState, Boolean>)((Function1)RootBlock::canSurvive$lambda$0));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == Direction.UP && !this.canSurvive(state, (LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.canSpread(world, pos, state);
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.canSpread((LevelReader)world, pos, state);
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.spreadFrom(world, pos, random);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    /*
     * WARNING - void declaration
     */
    public final void spreadFrom(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Set possibleDirections = CollectionsKt.toMutableSet((Iterable)this.possibleDirections);
        while (!((Collection)possibleDirections).isEmpty()) {
            void this_$iv$iv;
            void event$iv;
            void $this$iv;
            Direction picked = (Direction)CollectionsKt.random((Collection)possibleDirections, (Random)((Random)Random.Default));
            possibleDirections.remove(picked);
            BlockPos adjacent = pos.relative(picked);
            BlockState blockState = this.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            LevelReader levelReader = (LevelReader)world;
            Intrinsics.checkNotNull((Object)adjacent);
            if (!this.canSpreadTo(blockState, levelReader, adjacent)) continue;
            BlockState resultingSpread = this.spreadingRoot(random);
            BigRootPropagatedEvent event = new BigRootPropagatedEvent(world, pos, adjacent, resultingSpread);
            CancelableObservable<BigRootPropagatedEvent> cancelableObservable = CobblemonEvents.BIG_ROOT_PROPAGATED;
            Cancelable cancelable = event;
            boolean $i$f$postThen = false;
            EventObservable eventObservable = (EventObservable)$this$iv;
            Cancelable[] cancelableArray = new Cancelable[]{event$iv};
            Cancelable[] events$iv$iv = cancelableArray;
            boolean $i$f$post = false;
            this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
            Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                Cancelable element$iv$iv$iv;
                Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                if (it$iv.isCanceled()) {
                    Cancelable cancelable2 = it$iv;
                    boolean bl2 = false;
                    Cancelable it = cancelable2;
                    continue;
                }
                BigRootPropagatedEvent ev = (BigRootPropagatedEvent)it$iv;
                boolean bl3 = false;
                world.setBlockAndUpdate(ev.getNewRootPosition(), ev.getResultingSpread());
            }
        }
    }

    @Override
    public boolean attemptShear(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Function0<Unit> successCallback) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        world.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.setBlockAndUpdate(pos, this.shearedResultingState());
        ItemStack shearedDrop = this.shearedDrop();
        if (!shearedDrop.isEmpty()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)shearedDrop);
        }
        world.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
        successCallback.invoke();
        return true;
    }

    protected final boolean canSpread(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Iterable $this$any$iv = this.possibleDirections;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Direction direction = (Direction)element$iv;
                    boolean bl2 = false;
                    BlockPos adjacent = pos.relative(direction);
                    BlockState blockState = this.defaultBlockState();
                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
                    Intrinsics.checkNotNull((Object)adjacent);
                    if (!this.canSpreadTo(blockState, world, adjacent)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected final boolean canSpreadTo(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState existingState = world.getBlockState(pos);
        return (existingState.isAir() || existingState.canBeReplaced()) && this.canGoOn(state, world, pos, (Function1<? super BlockState, Boolean>)((Function1)RootBlock::canSpreadTo$lambda$0));
    }

    @NotNull
    protected final BlockState spreadingRoot(@NotNull RandomSource random) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if ((double)random.nextFloat() < Cobblemon.INSTANCE.getConfig().getEnergyRootChance()) {
            BlockState blockState2 = CobblemonBlocks.ENERGY_ROOT.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = CobblemonBlocks.BIG_ROOT.defaultBlockState();
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        }
        return blockState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean canGoOn(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Function1<? super BlockState, Boolean> ceilingValidator) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(ceilingValidator, (String)"ceilingValidator");
        BlockPos up = pos.above();
        BlockState upState = world.getBlockState(up);
        if (!upState.isFaceSturdy((BlockGetter)world, up, Direction.DOWN)) return false;
        Intrinsics.checkNotNull((Object)upState);
        if ((Boolean)ceilingValidator.invoke((Object)upState) == false) return false;
        return true;
    }

    @NotNull
    protected abstract BlockState shearedResultingState();

    @NotNull
    protected abstract ItemStack shearedDrop();

    private static final Unit useWithoutItem$lambda$0(ItemStack $stack, Player $player) {
        $stack.hurtAndBreak(1, (LivingEntity)$player, EquipmentSlot.MAINHAND);
        return Unit.INSTANCE;
    }

    private static final boolean canSurvive$lambda$0(BlockState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean canSpreadTo$lambda$0(BlockState ceiling) {
        Intrinsics.checkNotNullParameter((Object)ceiling, (String)"ceiling");
        return ceiling.is(CobblemonBlockTags.ROOTS_SPREADABLE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/block/RootBlock$Companion;", "", "<init>", "()V", "", "MAX_PROPAGATING_LIGHT_LEVEL", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

