/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.api.mulch.Mulchable;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0002A@B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\f\u001a\u00020\u000b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b!\u0010\"J/\u0010&\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J7\u0010*\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b/\u00100J\u000f\u00102\u001a\u000201H\u0016\u00a2\u0006\u0004\b2\u00103J/\u00104\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010)\u001a\u00020(H\u0014\u00a2\u0006\u0004\b4\u00105J%\u00109\u001a\u0002082\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b9\u0010:J'\u0010<\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020;2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b<\u0010=J/\u0010<\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020;2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010>\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b<\u0010?\u00a8\u0006B"}, d2={"Lcom/cobblemon/mod/common/block/RevivalHerbBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lcom/cobblemon/mod/common/api/mulch/Mulchable;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAgeProperty", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "state", "Lnet/minecraft/world/level/LevelReader;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/BlockGetter;", "blockGetter", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "collisionContext", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/ItemLike;", "getBaseSeedId", "()Lnet/minecraft/world/level/ItemLike;", "Lnet/minecraft/server/level/ServerLevel;", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "variant", "canHaveMulchApplied", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/mulch/MulchVariant;)Z", "Lnet/minecraft/util/RandomSource;", "random", "applyMulch", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/mulch/MulchVariant;)V", "Lcom/cobblemon/mod/common/block/RevivalHerbBlock$Mutation;", "mutationOf", "(Lnet/minecraft/world/level/block/state/BlockState;)Lcom/cobblemon/mod/common/block/RevivalHerbBlock$Mutation;", "isMutated", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "getMaxAge", "()I", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "block", "level", "", "getMoistureAmount", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F", "Lnet/minecraft/world/level/Level;", "growCrops", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "useRandomGrowthAmount", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Companion", "Mutation", "common"})
@SourceDebugExtension(value={"SMAP\nRevivalHerbBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevivalHerbBlock.kt\ncom/cobblemon/mod/common/block/RevivalHerbBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,214:1\n4244#2:215\n4344#2,2:216\n*S KotlinDebug\n*F\n+ 1 RevivalHerbBlock.kt\ncom/cobblemon/mod/common/block/RevivalHerbBlock\n*L\n74#1:215\n74#1:216,2\n*E\n"})
public final class RevivalHerbBlock
extends CropBlock
implements Mulchable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final MapCodec<RevivalHerbBlock> CODEC = CropBlock.simpleCodec(RevivalHerbBlock::new);
    public static final int MIN_AGE = 0;
    public static final int MAX_AGE = 8;
    public static final int MUTABLE_MAX_AGE = 6;
    private static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)8);
    private static final BooleanProperty IS_WILD = BooleanProperty.create((String)"is_wild");
    private static final EnumProperty<Mutation> MUTATION = EnumProperty.create((String)"mutation", Mutation.class);
    @NotNull
    private static final VoxelShape[] AGE_SHAPES;

    public RevivalHerbBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_WILD, (Comparable)Boolean.valueOf(false))).setValue((Property)MUTATION, (Comparable)((Object)Mutation.NONE)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE};
        builder.add(propertyArray);
        propertyArray = new Property[]{IS_WILD};
        builder.add(propertyArray);
        propertyArray = new Property[]{MUTATION};
        builder.add(propertyArray);
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        IntegerProperty integerProperty = AGE;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE");
        return integerProperty;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState floor = world.getBlockState(pos.below());
        BlockState block = world.getBlockState(pos);
        return (block.is(BlockTags.REPLACEABLE_BY_TREES) || block.is(BlockTags.AIR) || block.is((Block)this)) && ((Boolean)state.getValue((Property)IS_WILD) != false && floor.is(BlockTags.DIRT) || this.mayPlaceOn(floor, (BlockGetter)world, pos));
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)collisionContext, (String)"collisionContext");
        VoxelShape voxelShape = (VoxelShape)ArraysKt.getOrNull((Object[])AGE_SHAPES, (int)this.getAge(state));
        if (voxelShape == null) {
            VoxelShape voxelShape2 = Shapes.block();
            voxelShape = voxelShape2;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
        }
        return voxelShape;
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)CobblemonItems.REVIVAL_HERB;
    }

    @Override
    public boolean canHaveMulchApplied(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull MulchVariant variant) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        return variant == MulchVariant.SURPRISE && this.getAge(state) <= 6 && !this.isMutated(state);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyMulch(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull MulchVariant variant) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Mutation[] $this$filterNot$iv = Mutation.values();
        boolean $i$f$filterNot = false;
        Mutation[] mutationArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        int n = ((void)$this$filterNotTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
            boolean bl = false;
            if (it == Mutation.NONE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Mutation picked = (Mutation)((Object)CollectionsKt.random((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default)));
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MUTATION, (Comparable)((Object)picked)));
    }

    @NotNull
    public final Mutation mutationOf(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.getValue((Property)MUTATION);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Mutation)((Object)comparable);
    }

    public final boolean isMutated(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.mutationOf(state) != Mutation.NONE;
    }

    public int getMaxAge() {
        return 8;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (world.getRawBrightness(pos, 0) < 9 || this.isMaxAge(state)) {
            return;
        }
        float currentMoisture = this.getMoistureAmount((Block)this, (BlockGetter)world, pos);
        if (random.nextInt((int)(25.0f / currentMoisture) + 1) == 0) {
            this.growCrops((Level)world, pos, state, false);
        }
    }

    public final float getMoistureAmount(@NotNull Block block, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        boolean sameBlockDirectNeighborZAxis;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        float growthSpeed = 1.0f;
        BlockPos ground = pos.below();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                float nearbyFarmLandBoost = 0.0f;
                BlockState blockState = level.getBlockState(ground.offset(x, 0, z));
                if (blockState.is(Blocks.FARMLAND)) {
                    nearbyFarmLandBoost = 1.0f;
                    if (((Number)((Object)blockState.getValue((Property)FarmBlock.MOISTURE))).intValue() > 0) {
                        nearbyFarmLandBoost = 3.0f;
                    }
                }
                if (x != 0 || z != 0) {
                    nearbyFarmLandBoost /= 4.0f;
                }
                growthSpeed += nearbyFarmLandBoost;
            }
        }
        BlockPos north = pos.north();
        BlockPos south = pos.south();
        BlockPos west = pos.west();
        BlockPos east = pos.east();
        boolean sameBlockDirectNeighborXAxis = level.getBlockState(west).is(block) || level.getBlockState(east).is(block);
        boolean bl = sameBlockDirectNeighborZAxis = level.getBlockState(north).is(block) || level.getBlockState(south).is(block);
        if (sameBlockDirectNeighborZAxis && sameBlockDirectNeighborXAxis) {
            growthSpeed /= 2.0f;
        } else {
            boolean sameBlockDiagonallyPresent;
            boolean bl2 = sameBlockDiagonallyPresent = level.getBlockState(west.north()).is(block) || level.getBlockState(east.north()).is(block) || level.getBlockState(east.south()).is(block) || level.getBlockState(west.south()).is(block);
            if (sameBlockDiagonallyPresent) {
                growthSpeed /= 2.0f;
            }
        }
        return growthSpeed;
    }

    public void growCrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.growCrops(world, pos, state, true);
    }

    private final void growCrops(Level world, BlockPos pos, BlockState state, boolean useRandomGrowthAmount) {
        int growthAmount = useRandomGrowthAmount ? this.getBonemealAgeIncrease(world) : 1;
        int newAge = RangesKt.coerceAtMost((int)(this.getAge(state) + growthAmount), (int)this.getMaxAge());
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }

    static {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.1, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.2, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.3, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.4, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.5, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.7, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.7, (double)1.0), Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.9, (double)1.0), Shapes.block()};
        AGE_SHAPES = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\rR\u001f\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00100\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0016\u001a\n \u0006*\u0004\u0018\u00010\u00150\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R;\u0010\u001c\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u001b0\u001b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001a0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR%\u0010\"\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010!0!0 8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/block/RevivalHerbBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/RevivalHerbBlock;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "", "MIN_AGE", "I", "MAX_AGE", "MUTABLE_MAX_AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "IS_WILD", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getIS_WILD", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lcom/cobblemon/mod/common/block/RevivalHerbBlock$Mutation;", "MUTATION", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getMUTATION", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AGE_SHAPES", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "getAGE_SHAPES", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final MapCodec<RevivalHerbBlock> getCODEC() {
            return CODEC;
        }

        public final IntegerProperty getAGE() {
            return AGE;
        }

        public final BooleanProperty getIS_WILD() {
            return IS_WILD;
        }

        public final EnumProperty<Mutation> getMUTATION() {
            return MUTATION;
        }

        @NotNull
        public final VoxelShape[] getAGE_SHAPES() {
            return AGE_SHAPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/block/RevivalHerbBlock$Mutation;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "", "getSerializedName", "()Ljava/lang/String;", "NONE", "MENTAL", "POWER", "WHITE", "MIRROR", "common"})
    public static final class Mutation
    extends Enum<Mutation>
    implements StringRepresentable {
        public static final /* enum */ Mutation NONE = new Mutation();
        public static final /* enum */ Mutation MENTAL = new Mutation();
        public static final /* enum */ Mutation POWER = new Mutation();
        public static final /* enum */ Mutation WHITE = new Mutation();
        public static final /* enum */ Mutation MIRROR = new Mutation();
        private static final /* synthetic */ Mutation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static Mutation[] values() {
            return (Mutation[])$VALUES.clone();
        }

        public static Mutation valueOf(String value) {
            return Enum.valueOf(Mutation.class, value);
        }

        @NotNull
        public static EnumEntries<Mutation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mutationArray = new Mutation[]{Mutation.NONE, Mutation.MENTAL, Mutation.POWER, Mutation.WHITE, Mutation.MIRROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

