/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.block.MintBlock;
import com.cobblemon.mod.common.item.MintLeafItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000254B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u0017H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020#2\u0006\u0010\f\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b$\u0010%J/\u0010*\u001a\u00020)2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010(\u001a\u00020'H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b,\u0010-J/\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u0015\u0010/J\u0017\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000100H\u0016\u00a2\u0006\u0004\b1\u00102R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00103\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/block/MintBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lcom/cobblemon/mod/common/block/MintBlock$MintType;", "mintType", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lcom/cobblemon/mod/common/block/MintBlock$MintType;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/util/RandomSource;", "random", "", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/Level;", "growCrops", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/LevelReader;", "", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/ItemLike;", "getBaseSeedId", "()Lnet/minecraft/world/level/ItemLike;", "", "getBonemealAgeIncrease", "(Lnet/minecraft/world/level/Level;)I", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "isWild", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "useRandomGrowthAmount", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/MintBlock$MintType;", "Companion", "MintType", "common"})
public final class MintBlock
extends CropBlock
implements BonemealableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MintType mintType;
    @NotNull
    private static final MapCodec<MintBlock> CODEC;
    @NotNull
    private static final IntegerProperty AGE;
    public static final int MATURE_AGE = 7;
    @NotNull
    private static final BooleanProperty IS_WILD;
    private static final VoxelShape AGE_0_SHAPE;
    private static final VoxelShape AGE_1_TO_2_SHAPE;
    private static final VoxelShape AGE_3_SHAPE;
    private static final VoxelShape AGE_4_SHAPE;
    private static final VoxelShape AGE_5_SHAPE;
    private static final VoxelShape AGE_6_SHAPE;
    private static final VoxelShape AGE_7_SHAPE;
    @NotNull
    private static final VoxelShape[] AGE_TO_SHAPE;

    public MintBlock(@NotNull MintType mintType, @NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)mintType), (String)"mintType");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.mintType = mintType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_WILD, (Comparable)Boolean.valueOf(false)));
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (world.getRawBrightness(pos, 0) < 9 || this.isMaxAge(state) || random.nextInt(8) != 0) {
            return;
        }
        this.growCrops((Level)world, pos, state, false);
    }

    public void growCrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.growCrops(world, pos, state, true);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE};
        builder.add(propertyArray);
        propertyArray = new Property[]{IS_WILD};
        builder.add(propertyArray);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState floor = world.getBlockState(pos.below());
        return (world.getRawBrightness(pos, 0) >= 8 || world.canSeeSky(pos)) && (this.isWild(state) && floor.is(BlockTags.DIRT) || this.mayPlaceOn(floor, (BlockGetter)world, pos));
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)this.mintType.getSeed();
    }

    protected int getBonemealAgeIncrease(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return 1;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = AGE_TO_SHAPE[this.getAge(state)];
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"get(...)");
        return voxelShape;
    }

    public final boolean isWild(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.getValue((Property)IS_WILD);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Boolean)comparable;
    }

    private final void growCrops(Level world, BlockPos pos, BlockState state, boolean useRandomGrowthAmount) {
        int growthAmount = useRandomGrowthAmount ? this.getBonemealAgeIncrease(world) : 1;
        int newAge = RangesKt.coerceAtMost((int)(this.getAge(state) + growthAmount), (int)7);
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }

    @NotNull
    public MapCodec<? extends CropBlock> codec() {
        return CODEC;
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)MintType.Companion.getCODEC().fieldOf("mintType").forGetter(arg_0 -> MintBlock.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)CropBlock.propertiesCodec()).apply((Applicative)it, MintBlock::new);
    }

    private static final MintType CODEC$lambda$0$0(KProperty1 $tmp0, MintBlock p0) {
        return (MintType)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    public static final /* synthetic */ MintType access$getMintType$p(MintBlock $this) {
        return $this.mintType;
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(MintBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        IntegerProperty integerProperty = CropBlock.AGE;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE");
        AGE = integerProperty;
        BooleanProperty booleanProperty = BooleanProperty.create((String)"is_wild");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        IS_WILD = booleanProperty;
        AGE_0_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.1, (double)1.0);
        AGE_1_TO_2_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.2, (double)1.0);
        AGE_3_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.3, (double)1.0);
        AGE_4_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.4, (double)1.0);
        AGE_5_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        AGE_6_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.6, (double)1.0);
        AGE_7_SHAPE = Shapes.box((double)0.0, (double)-0.9, (double)0.0, (double)1.0, (double)0.7, (double)1.0);
        VoxelShape[] voxelShapeArray = new VoxelShape[]{AGE_0_SHAPE, AGE_1_TO_2_SHAPE, AGE_1_TO_2_SHAPE, AGE_3_SHAPE, AGE_4_SHAPE, AGE_5_SHAPE, AGE_6_SHAPE, AGE_7_SHAPE};
        AGE_TO_SHAPE = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u001c\u0010\u001c\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001d\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u001c\u0010\u001e\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u001c\u0010\u001f\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001aR\u001c\u0010 \u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001aR%\u0010\"\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/block/MintBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/MintBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "", "MATURE_AGE", "I", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "IS_WILD", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getIS_WILD", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "AGE_0_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AGE_1_TO_2_SHAPE", "AGE_3_SHAPE", "AGE_4_SHAPE", "AGE_5_SHAPE", "AGE_6_SHAPE", "AGE_7_SHAPE", "", "AGE_TO_SHAPE", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "getAGE_TO_SHAPE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<MintBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final IntegerProperty getAGE() {
            return AGE;
        }

        @NotNull
        public final BooleanProperty getIS_WILD() {
            return IS_WILD;
        }

        @NotNull
        public final VoxelShape[] getAGE_TO_SHAPE() {
            return AGE_TO_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \u00112\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/block/MintBlock$MintType;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "Lnet/minecraft/world/item/Item;", "getSeed", "()Lnet/minecraft/world/item/Item;", "Lcom/cobblemon/mod/common/item/MintLeafItem;", "getLeaf", "()Lcom/cobblemon/mod/common/item/MintLeafItem;", "Lcom/cobblemon/mod/common/block/MintBlock;", "getCropBlock", "()Lcom/cobblemon/mod/common/block/MintBlock;", "", "getSerializedName", "()Ljava/lang/String;", "Companion", "RED", "BLUE", "CYAN", "PINK", "GREEN", "WHITE", "common"})
    public static final class MintType
    extends Enum<MintType>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        private static final StringRepresentable.EnumCodec<MintType> CODEC;
        public static final /* enum */ MintType RED;
        public static final /* enum */ MintType BLUE;
        public static final /* enum */ MintType CYAN;
        public static final /* enum */ MintType PINK;
        public static final /* enum */ MintType GREEN;
        public static final /* enum */ MintType WHITE;
        private static final /* synthetic */ MintType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final Item getSeed() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> CobblemonItems.RED_MINT_SEEDS;
                case 2 -> CobblemonItems.BLUE_MINT_SEEDS;
                case 3 -> CobblemonItems.CYAN_MINT_SEEDS;
                case 4 -> CobblemonItems.PINK_MINT_SEEDS;
                case 5 -> CobblemonItems.GREEN_MINT_SEEDS;
                case 6 -> CobblemonItems.WHITE_MINT_SEEDS;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final MintLeafItem getLeaf() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> CobblemonItems.RED_MINT_LEAF;
                case 2 -> CobblemonItems.BLUE_MINT_LEAF;
                case 3 -> CobblemonItems.CYAN_MINT_LEAF;
                case 4 -> CobblemonItems.PINK_MINT_LEAF;
                case 5 -> CobblemonItems.GREEN_MINT_LEAF;
                case 6 -> CobblemonItems.WHITE_MINT_LEAF;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final MintBlock getCropBlock() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> CobblemonBlocks.INSTANCE.getRED_MINT();
                case 2 -> CobblemonBlocks.BLUE_MINT;
                case 3 -> CobblemonBlocks.CYAN_MINT;
                case 4 -> CobblemonBlocks.PINK_MINT;
                case 5 -> CobblemonBlocks.GREEN_MINT;
                case 6 -> CobblemonBlocks.WHITE_MINT;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static MintType[] values() {
            return (MintType[])$VALUES.clone();
        }

        public static MintType valueOf(String value) {
            return Enum.valueOf(MintType.class, value);
        }

        @NotNull
        public static EnumEntries<MintType> getEntries() {
            return $ENTRIES;
        }

        static {
            RED = new MintType();
            BLUE = new MintType();
            CYAN = new MintType();
            PINK = new MintType();
            GREEN = new MintType();
            WHITE = new MintType();
            $VALUES = mintTypeArray = new MintType[]{MintType.RED, MintType.BLUE, MintType.CYAN, MintType.PINK, MintType.GREEN, MintType.WHITE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            CODEC = StringRepresentable.fromEnum(MintType::values);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/block/MintBlock$MintType$Companion;", "", "<init>", "()V", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Lcom/cobblemon/mod/common/block/MintBlock$MintType;", "kotlin.jvm.PlatformType", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "common"})
        public static final class Companion {
            private Companion() {
            }

            public final StringRepresentable.EnumCodec<MintType> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MintType.values().length];
                try {
                    nArray[MintType.RED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MintType.BLUE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MintType.CYAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MintType.PINK.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MintType.GREEN.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MintType.WHITE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

