/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0001PB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\"\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b%\u0010&J/\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020(H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010-\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J'\u00101\u001a\u0002002\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00103\u001a\u0002002\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b3\u00104J?\u0010:\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u0002082\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u001dH\u0014\u00a2\u0006\u0004\b:\u0010;J'\u0010=\u001a\u0002002\u0006\u0010<\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b=\u00102J/\u0010>\u001a\u00020\u00142\u0006\u0010<\u001a\u00020'2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b>\u0010?J-\u0010B\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\r\u00a2\u0006\u0004\bB\u0010CJ\u0017\u0010D\u001a\u00020\r2\u0006\u0010<\u001a\u00020@H\u0014\u00a2\u0006\u0004\bD\u0010EJ'\u0010F\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014\u00a2\u0006\u0004\bF\u0010GJ5\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0012\u0018\u00010H2\u0006\u0010<\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010K\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bK\u0010LJ\u0019\u0010N\u001a\u0004\u0018\u00010M2\u0006\u0010\u001a\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\bN\u0010O\u00a8\u0006Q"}, d2={"Lcom/cobblemon/mod/common/block/HeartyGrainsBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAgeProperty", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "", "getMaxAge", "()I", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/ItemLike;", "getBaseSeedId", "()Lnet/minecraft/world/level/ItemLike;", "state", "Lnet/minecraft/world/level/BlockGetter;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/LevelReader;", "", "canGrow", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "canGrowInto", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "level", "isValidBonemealTarget", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/level/Level;", "increment", "grow", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)V", "getBonemealAgeIncrease", "(Lnet/minecraft/world/level/Level;)I", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lkotlin/Pair;", "getLowerHalf", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lkotlin/Pair;", "isLower", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/block/SoundType;", "getSoundType", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/SoundType;", "Companion", "common"})
public final class HeartyGrainsBlock
extends CropBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final MapCodec<HeartyGrainsBlock> CODEC = CropBlock.simpleCodec(HeartyGrainsBlock::new);
    public static final int MATURE_AGE = 6;
    public static final int AGE_AFTER_HARVEST = 3;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    @NotNull
    private static final IntegerProperty AGE;
    @NotNull
    private static final EnumProperty<DoubleBlockHalf> HALF;
    @NotNull
    private static final VoxelShape[] AGE_TO_SHAPE;
    @NotNull
    private static final VoxelShape[] AGE_TO_SHAPE_TOP;

    public HeartyGrainsBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public MapCodec<? extends CropBlock> codec() {
        MapCodec<HeartyGrainsBlock> mapCodec = CODEC;
        Intrinsics.checkNotNullExpressionValue(mapCodec, (String)"CODEC");
        return mapCodec;
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE, HALF, WATERLOGGED};
        builder.add(propertyArray);
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)CobblemonItems.HEARTY_GRAINS;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            VoxelShape voxelShape2 = AGE_TO_SHAPE_TOP[this.getAge(state)];
            voxelShape = voxelShape2;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"get(...)");
        } else {
            VoxelShape voxelShape3 = AGE_TO_SHAPE[this.getAge(state)];
            voxelShape = voxelShape3;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"get(...)");
        }
        return voxelShape;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.defaultFluidState();
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"defaultFluidState(...)");
        } else {
            FluidState fluidState3 = Fluids.EMPTY.defaultFluidState();
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"defaultFluidState(...)");
        }
        return fluidState;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER || !this.canGrow((LevelReader)world, pos, state)) {
            return;
        }
        if (CropBlock.hasSufficientLight((LevelReader)((LevelReader)world), (BlockPos)pos) && random.nextInt(16) == 0) {
            this.grow((Level)world, pos, state, 1);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canGrow(LevelReader world, BlockPos pos, BlockState state) {
        if (this.isMaxAge(state)) return false;
        if (!this.canSurvive(state, world, pos)) return false;
        BlockPos blockPos = pos.above();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
        if (this.canGrowInto(world, blockPos)) return true;
        if (((Number)((Object)state.getValue((Property)AGE))).intValue() >= 3) return false;
        return true;
    }

    private final boolean canGrowInto(LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || blockState.is((Block)CobblemonBlocks.HEARTY_GRAINS);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.UP && ((Number)((Object)state.getValue((Property)AGE))).intValue() > 3 && !neighborState.is((Block)CobblemonBlocks.HEARTY_GRAINS)) {
            Object object = state.setValue((Property)AGE, (Comparable)Integer.valueOf(3));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        return state;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Pair<BlockPos, BlockState> posAndState = this.getLowerHalf(level, pos, state);
        return posAndState == null ? false : this.canGrow(level, (BlockPos)posAndState.getFirst(), (BlockState)posAndState.getSecond());
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Pair<BlockPos, BlockState> posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow((Level)level, (BlockPos)posAndState.getFirst(), (BlockState)posAndState.getSecond(), this.getBonemealAgeIncrease((Level)level));
        }
    }

    public final void grow(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int increment) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canGrow((LevelReader)world, pos, state)) {
            return;
        }
        int newAge = RangesKt.coerceAtMost((int)(this.getAge(state) + increment), (int)this.getMaxAge());
        world.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
        if (newAge >= 4) {
            BlockPos abovePos = pos.above();
            BlockState stateAbove = world.getBlockState(abovePos);
            if (stateAbove.isAir()) {
                world.setBlock(abovePos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(newAge))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else if (stateAbove.hasProperty((Property)HALF) && stateAbove.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                world.setBlock(abovePos, (BlockState)stateAbove.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            }
        }
    }

    protected int getBonemealAgeIncrease(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return Mth.nextInt((RandomSource)level.random, (int)1, (int)3);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue((Property)HALF);
        switch (doubleBlockHalf == null ? -1 : WhenMappings.$EnumSwitchMapping$0[doubleBlockHalf.ordinal()]) {
            case 1: {
                BlockPos floorBlock = pos.below();
                BlockState floor = world.getBlockState(floorBlock);
                FluidState fluidState = world.getFluidState(pos);
                if (fluidState.is(FluidTags.WATER) && fluidState.isSource()) {
                    return floor.is(CobblemonBlockTags.HEARTY_GRAINS_WATER_PLANTABLE);
                }
                bl = floor.is(CobblemonBlockTags.HEARTY_GRAINS_LAND_PLANTABLE);
                break;
            }
            case 2: {
                if (this.getLowerHalf(world, pos, state) != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final Pair<BlockPos, BlockState> getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (this.isLower(state)) {
            return new Pair((Object)pos, (Object)state);
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        Intrinsics.checkNotNull((Object)blockState);
        return this.isLower(blockState) ? new Pair((Object)blockPos, (Object)blockState) : null;
    }

    private final boolean isLower(BlockState state) {
        return state.is((Block)CobblemonBlocks.HEARTY_GRAINS) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    protected SoundType getSoundType(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? CobblemonSounds.HEARTY_GRAINS_WATER_SOUNDS : CobblemonSounds.HEARTY_GRAINS_SOUNDS;
    }

    static {
        IntegerProperty integerProperty = IntegerProperty.create((String)"age", (int)0, (int)6);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        AGE = integerProperty;
        EnumProperty enumProperty = BlockStateProperties.DOUBLE_BLOCK_HALF;
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"DOUBLE_BLOCK_HALF");
        HALF = enumProperty;
        VoxelShape[] voxelShapeArray = new VoxelShape[]{CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        AGE_TO_SHAPE = voxelShapeArray;
        voxelShapeArray = new VoxelShape[]{CropBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), CropBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), CropBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), CropBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0)};
        AGE_TO_SHAPE_TOP = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u001f\u0010\u0010\u001a\n \u0006*\u0004\u0018\u00010\u000f0\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR%\u0010!\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010 0 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R%\u0010%\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010 0 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b%\u0010\"\u001a\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/block/HeartyGrainsBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/HeartyGrainsBlock;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "", "MATURE_AGE", "I", "AGE_AFTER_HARVEST", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/DoubleBlockHalf;", "HALF", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getHALF", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "AGE_TO_SHAPE", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "getAGE_TO_SHAPE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "AGE_TO_SHAPE_TOP", "getAGE_TO_SHAPE_TOP", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final MapCodec<HeartyGrainsBlock> getCODEC() {
            return CODEC;
        }

        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        @NotNull
        public final IntegerProperty getAGE() {
            return AGE;
        }

        @NotNull
        public final EnumProperty<DoubleBlockHalf> getHALF() {
            return HALF;
        }

        @NotNull
        public final VoxelShape[] getAGE_TO_SHAPE() {
            return AGE_TO_SHAPE;
        }

        @NotNull
        public final VoxelShape[] getAGE_TO_SHAPE_TOP() {
            return AGE_TO_SHAPE_TOP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DoubleBlockHalf.values().length];
            try {
                nArray[DoubleBlockHalf.LOWER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoubleBlockHalf.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

