/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.block.entity.DisplayCaseBlockEntity;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J?\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ7\u0010%\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0014\u00a2\u0006\u0004\b%\u0010&J7\u0010*\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\b2\u0006\u0010)\u001a\u00020(H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b-\u0010.J'\u00100\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000104H\u0014\u00a2\u0006\u0004\b5\u00106J\u001f\u00109\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u00108\u001a\u000207H\u0014\u00a2\u0006\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lcom/cobblemon/mod/common/block/DisplayCaseBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/BlockPos;", "pos", "state", "Lcom/cobblemon/mod/common/block/entity/DisplayCaseBlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/cobblemon/mod/common/block/entity/DisplayCaseBlockEntity;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "world", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "newState", "", "moved", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "", "getAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "hasAnalogOutputSignal", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "type", "isPathfindable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nDisplayCaseBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayCaseBlock.kt\ncom/cobblemon/mod/common/block/DisplayCaseBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,135:1\n13805#2,2:136\n*S KotlinDebug\n*F\n+ 1 DisplayCaseBlock.kt\ncom/cobblemon/mod/common/block/DisplayCaseBlock\n*L\n47#1:136,2\n*E\n"})
public final class DisplayCaseBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final MapCodec<DisplayCaseBlock> CODEC = BaseEntityBlock.simpleCodec(DisplayCaseBlock::new);
    private static final DirectionProperty ITEM_DIRECTION = DirectionProperty.create((String)"item_facing");

    public DisplayCaseBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)ITEM_DIRECTION, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = null;
        blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directionArray = ctx.getNearestLookingDirections();
        Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"getNearestLookingDirections(...)");
        Object[] $this$forEach$iv = directionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction direction = (Direction)element$iv;
            boolean bl = false;
            if (!direction.getAxis().isHorizontal()) continue;
            Object object = ((BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).setValue((Property)ITEM_DIRECTION, (Comparable)direction);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            blockState = (BlockState)object;
            if (!blockState.canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING};
        builder.add(propertyArray);
        propertyArray = new Property[]{ITEM_DIRECTION};
        builder.add(propertyArray);
    }

    @NotNull
    public DisplayCaseBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new DisplayCaseBlockEntity(pos, state);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == state.getValue((Property)HorizontalDirectionalBlock.FACING) && !state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.DisplayCaseBlockEntity");
        DisplayCaseBlockEntity entity = (DisplayCaseBlockEntity)blockEntity;
        InteractionResult result = entity.updateItem(player, InteractionHand.MAIN_HAND);
        if (blockHitResult.getDirection() != Direction.UP && blockHitResult.getDirection() != Direction.DOWN && result == InteractionResult.SUCCESS) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ITEM_DIRECTION, (Comparable)blockHitResult.getDirection().getOpposite()));
        }
        return result;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.DisplayCaseBlockEntity");
        DisplayCaseBlockEntity entity = (DisplayCaseBlockEntity)blockEntity;
        if (!entity.getStack().isEmpty()) {
            Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.DisplayCaseBlockEntity");
        ItemStack stack = ((DisplayCaseBlockEntity)blockEntity).getStack();
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof PokeBallItem) {
            return 3;
        }
        if (stack.getItem() instanceof BlockItem) {
            return 2;
        }
        return 1;
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        MapCodec<DisplayCaseBlock> mapCodec = CODEC;
        Intrinsics.checkNotNullExpressionValue(mapCodec, (String)"CODEC");
        return mapCodec;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001f\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/block/DisplayCaseBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/DisplayCaseBlock;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "ITEM_DIRECTION", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getITEM_DIRECTION", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final MapCodec<DisplayCaseBlock> getCODEC() {
            return CODEC;
        }

        public final DirectionProperty getITEM_DIRECTION() {
            return ITEM_DIRECTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

