/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.runner.socket;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ%\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\"\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010#J+\u0010'\u001a\u00020\t2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020$2\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b'\u0010(J%\u0010*\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010*\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b*\u0010,J\u0017\u0010.\u001a\u00020-2\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b2\u0010\u000bJ\u001d\u00105\u001a\u00020\t2\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u00020\t03\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b7\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010\u001dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010:\u001a\u0004\b;\u0010<R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010:\u001a\u0004\b=\u0010<R\u0016\u0010?\u001a\u00020>8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010DR\u0017\u0010F\u001a\u00020E8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\u00a8\u0006J"}, d2={"Lcom/cobblemon/mod/common/battles/runner/socket/SocketShowdownService;", "Lcom/cobblemon/mod/common/battles/runner/ShowdownService;", "", "host", "", "port", "localPort", "<init>", "(Ljava/lang/String;II)V", "", "openConnection", "()V", "closeConnection", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "messages", "startBattle", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;[Ljava/lang/String;)V", "Ljava/util/UUID;", "battleId", "send", "(Ljava/util/UUID;[Ljava/lang/String;)V", "Ljava/io/BufferedReader;", "reader", "size", "read", "(Ljava/io/BufferedReader;I)Ljava/lang/String;", "readMessage", "()Ljava/lang/String;", "", "readBattleInput", "()Ljava/util/List;", "message", "interpretMessage", "(Ljava/util/UUID;Ljava/lang/String;)V", "", "data", "type", "sendRegistryData", "(Ljava/util/Map;Ljava/lang/String;)V", "key", "sendRegistryEntry", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "Lcom/google/gson/JsonArray;", "getRegistryData", "(Ljava/lang/String;)Lcom/google/gson/JsonArray;", "resetRegistryData", "(Ljava/lang/String;)V", "resetAllRegistries", "Lkotlin/Function0;", "ifFails", "acknowledge", "(Lkotlin/jvm/functions/Function0;)V", "indicateSpeciesInitialized", "Ljava/lang/String;", "getHost", "I", "getPort", "()I", "getLocalPort", "Ljava/net/Socket;", "socket", "Ljava/net/Socket;", "Ljava/io/OutputStreamWriter;", "writer", "Ljava/io/OutputStreamWriter;", "Ljava/io/BufferedReader;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "common"})
@SourceDebugExtension(value={"SMAP\nSocketShowdownService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketShowdownService.kt\ncom/cobblemon/mod/common/battles/runner/socket/SocketShowdownService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,162:1\n1869#2,2:163\n216#3,2:165\n*S KotlinDebug\n*F\n+ 1 SocketShowdownService.kt\ncom/cobblemon/mod/common/battles/runner/socket/SocketShowdownService\n*L\n69#1:163,2\n103#1:165,2\n*E\n"})
public final class SocketShowdownService
implements ShowdownService {
    @NotNull
    private final String host;
    private final int port;
    private final int localPort;
    private Socket socket;
    private OutputStreamWriter writer;
    private BufferedReader reader;
    @NotNull
    private final Gson gson;

    public SocketShowdownService(@NotNull String host, int port, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.localPort = localPort;
        this.gson = new Gson();
    }

    public /* synthetic */ SocketShowdownService(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            string = "localhost";
        }
        if ((n3 & 2) != 0) {
            n = 18468;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(string, n, n2);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Override
    public void openConnection() {
        this.socket = new Socket(InetAddress.getLocalHost(), this.port, InetAddress.getLocalHost(), this.localPort);
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        OutputStream outputStream = socket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        Charset charset = Charset.forName("ascii");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        this.writer = new OutputStreamWriter(outputStream2, charset2);
        Socket socket2 = this.socket;
        if (socket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket2 = null;
        }
        this.reader = new BufferedReader(new InputStreamReader(socket2.getInputStream()));
    }

    @Override
    public void closeConnection() {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        socket.close();
    }

    @Override
    public void startBattle(@NotNull PokemonBattle battle, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">startbattle " + battle.getBattleId() + "\n");
        this.acknowledge((Function0<Unit>)((Function0)SocketShowdownService::startBattle$lambda$0));
        UUID uUID = battle.getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this.send(uUID, messages);
    }

    @Override
    public void send(@NotNull UUID battleId, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        for (String message : messages) {
            OutputStreamWriter outputStreamWriter = this.writer;
            if (outputStreamWriter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                outputStreamWriter = null;
            }
            outputStreamWriter.write(battleId + "~" + message + "\n");
            OutputStreamWriter outputStreamWriter2 = this.writer;
            if (outputStreamWriter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                outputStreamWriter2 = null;
            }
            outputStreamWriter2.flush();
            Iterable $this$forEach$iv = this.readBattleInput();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.interpretMessage(battleId, it);
            }
        }
    }

    private final String read(BufferedReader reader, int size) {
        char[] buffer = new char[size];
        while (reader.read(buffer) == 0) {
        }
        return new String(buffer);
    }

    private final String readMessage() {
        BufferedReader bufferedReader = this.reader;
        if (bufferedReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
            bufferedReader = null;
        }
        int payloadSize = Integer.parseInt(this.read(bufferedReader, 8));
        BufferedReader bufferedReader2 = this.reader;
        if (bufferedReader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
            bufferedReader2 = null;
        }
        String payload = this.read(bufferedReader2, payloadSize);
        return payload;
    }

    private final List<String> readBattleInput() {
        int numLines;
        List lines = new ArrayList();
        BufferedReader bufferedReader = this.reader;
        if (bufferedReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
            bufferedReader = null;
        }
        if ((numLines = Integer.parseInt(this.read(bufferedReader, 8))) != 0) {
            for (int i = 0; i < numLines; ++i) {
                lines.add(this.readMessage());
            }
        }
        return lines;
    }

    private final void interpretMessage(UUID battleId, String message) {
        ShowdownInterpreter.INSTANCE.interpretMessage(battleId, message);
    }

    @Override
    public void sendRegistryData(@NotNull Map<String, String> data, @NotNull String type) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map<String, String> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            this.sendRegistryEntry(key, value, type);
        }
    }

    public final void sendRegistryEntry(@NotNull String key, @NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CharSequence charSequence = data;
        Regex regex = new Regex("[\r\n]+");
        String string = " ";
        String payload = regex.replace(charSequence, string);
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">receiveEntry " + type + " " + key + " " + payload);
        this.acknowledge((Function0<Unit>)((Function0)() -> SocketShowdownService.sendRegistryEntry$lambda$0(type, payload)));
    }

    @Override
    public void sendRegistryEntry(@NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CharSequence charSequence = data;
        Regex regex = new Regex("[\r\n]+");
        String string = " ";
        String payload = regex.replace(charSequence, string);
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">receiveEntry " + type + " " + payload);
        this.acknowledge((Function0<Unit>)((Function0)() -> SocketShowdownService.sendRegistryEntry$lambda$1(type, payload)));
    }

    @Override
    @NotNull
    public JsonArray getRegistryData(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">getData " + type);
        OutputStreamWriter outputStreamWriter2 = this.writer;
        if (outputStreamWriter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter2 = null;
        }
        outputStreamWriter2.flush();
        String response = this.readMessage();
        Object object = this.gson.fromJson(response, JsonArray.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (JsonArray)object;
    }

    @Override
    public void resetRegistryData(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">resetData " + type);
        SocketShowdownService.acknowledge$default(this, null, 1, null);
    }

    @Override
    public void resetAllRegistries() {
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">resetAll");
        SocketShowdownService.acknowledge$default(this, null, 1, null);
    }

    public final void acknowledge(@NotNull Function0<Unit> ifFails) {
        Intrinsics.checkNotNullParameter(ifFails, (String)"ifFails");
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.flush();
        char[] ack = new char[3];
        BufferedReader bufferedReader = this.reader;
        if (bufferedReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reader");
            bufferedReader = null;
        }
        bufferedReader.read(ack);
        if (!Intrinsics.areEqual((Object)new String(ack), (Object)"ACK")) {
            ifFails.invoke();
        }
    }

    public static /* synthetic */ void acknowledge$default(SocketShowdownService socketShowdownService, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = SocketShowdownService::acknowledge$lambda$0;
        }
        socketShowdownService.acknowledge((Function0<Unit>)function0);
    }

    @Override
    public void indicateSpeciesInitialized() {
        OutputStreamWriter outputStreamWriter = this.writer;
        if (outputStreamWriter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
            outputStreamWriter = null;
        }
        outputStreamWriter.write(">afterSpeciesInit");
        SocketShowdownService.acknowledge$default(this, null, 1, null);
    }

    private static final Unit startBattle$lambda$0() {
        Cobblemon.LOGGER.error("Failed to start battle!");
        return Unit.INSTANCE;
    }

    private static final Unit sendRegistryEntry$lambda$0(String $type, String $payload) {
        Cobblemon.LOGGER.error("Failed to send " + $type + " data to Showdown: " + $payload);
        return Unit.INSTANCE;
    }

    private static final Unit sendRegistryEntry$lambda$1(String $type, String $payload) {
        Cobblemon.LOGGER.error("Failed to send " + $type + " data to Showdown: " + $payload);
        return Unit.INSTANCE;
    }

    private static final Unit acknowledge$lambda$0() {
        return Unit.INSTANCE;
    }

    public SocketShowdownService() {
        this(null, 0, 0, 7, null);
    }
}

