/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.runner.graal;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.util.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "", "<init>", "()V", "", "attemptUnbundle", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "loadShowdownMetadata", "()Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "Ljava/io/File;", "target", "readShowdownMetadata", "(Ljava/io/File;)Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "ShowdownMetadata", "common"})
@SourceDebugExtension(value={"SMAP\nGraalShowdownUnbundler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraalShowdownUnbundler.kt\ncom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler\n+ 2 GsonExtensions.kt\ncom/cobblemon/mod/common/util/GsonExtensionsKt\n*L\n1#1,99:1\n17#2:100\n17#2:101\n*S KotlinDebug\n*F\n+ 1 GraalShowdownUnbundler.kt\ncom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler\n*L\n79#1:100\n89#1:101\n*E\n"})
public final class GraalShowdownUnbundler {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public final void attemptUnbundle() {
        File showdownDir = new File("showdown");
        ShowdownMetadata metadata = this.loadShowdownMetadata();
        if (!showdownDir.exists() || Cobblemon.INSTANCE.getConfig().getAutoUpdateShowdown()) {
            showdownDir.mkdirs();
            File showdownZip = new File(showdownDir, "showdown.zip");
            File showdownMetadataFile = new File(showdownDir, "showdown.json");
            boolean extract = true;
            if (showdownMetadataFile.exists()) {
                ShowdownMetadata current = this.readShowdownMetadata(showdownMetadataFile);
                ShowdownMetadata showdownMetadata = metadata;
                Intrinsics.checkNotNull((Object)showdownMetadata);
                double d = showdownMetadata.getShowdownVersion();
                ShowdownMetadata showdownMetadata2 = current;
                Intrinsics.checkNotNull((Object)showdownMetadata2);
                if (d == showdownMetadata2.getShowdownVersion()) {
                    extract = false;
                } else {
                    Cobblemon.LOGGER.info("Updating showdown service to version " + metadata.getShowdownVersion() + ", from version " + current.getShowdownVersion() + "...");
                    File backupDir = new File("showdown-backup");
                    if (backupDir.exists() && backupDir.isDirectory()) {
                        FilesKt.deleteRecursively((File)backupDir);
                    }
                    FilesKt.copyTo$default((File)showdownDir, (File)backupDir, (boolean)false, (int)0, (int)6, null);
                }
            }
            if (extract) {
                Path path = showdownZip.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                FileUtils.INSTANCE.copyInternalToExternal("/data/cobblemon/showdown.zip", path);
                Path path2 = showdownMetadataFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                FileUtils.INSTANCE.copyInternalToExternal("/data/cobblemon/showdown.json", path2);
                Path path3 = showdownZip.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
                Path path4 = showdownDir.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
                FileUtils.INSTANCE.unzipFile(path3, path4);
                showdownZip.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ShowdownMetadata loadShowdownMetadata() {
        try {
            void $this$fromJson$iv;
            InputStream inputStream = this.getClass().getResourceAsStream("/data/cobblemon/showdown.json");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream inputStream2 = inputStream;
            Gson gson2 = this.gson;
            Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"gson");
            Gson gson3 = gson2;
            Reader reader$iv = new InputStreamReader(inputStream2);
            boolean $i$f$fromJson = false;
            return (ShowdownMetadata)$this$fromJson$iv.fromJson(reader$iv, ShowdownMetadata.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ShowdownMetadata readShowdownMetadata(File target) {
        try {
            Closeable closeable = new InputStreamReader(new FileInputStream(target));
            Throwable throwable = null;
            try {
                void $this$fromJson$iv;
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                Gson gson2 = this.gson;
                Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"gson");
                Gson gson3 = gson2;
                Reader reader$iv = it;
                boolean $i$f$fromJson = false;
                ShowdownMetadata showdownMetadata = (ShowdownMetadata)$this$fromJson$iv.fromJson(reader$iv, ShowdownMetadata.class);
                return showdownMetadata;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "", "", "showdownVersion", "<init>", "(D)V", "component1", "()D", "copy", "(D)Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler$ShowdownMetadata;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getShowdownVersion", "common"})
    private static final class ShowdownMetadata {
        private final double showdownVersion;

        public ShowdownMetadata(double showdownVersion) {
            this.showdownVersion = showdownVersion;
        }

        public final double getShowdownVersion() {
            return this.showdownVersion;
        }

        public final double component1() {
            return this.showdownVersion;
        }

        @NotNull
        public final ShowdownMetadata copy(double showdownVersion) {
            return new ShowdownMetadata(showdownVersion);
        }

        public static /* synthetic */ ShowdownMetadata copy$default(ShowdownMetadata showdownMetadata, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = showdownMetadata.showdownVersion;
            }
            return showdownMetadata.copy(d);
        }

        @NotNull
        public String toString() {
            return "ShowdownMetadata(showdownVersion=" + this.showdownVersion + ")";
        }

        public int hashCode() {
            return Double.hashCode(this.showdownVersion);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShowdownMetadata)) {
                return false;
            }
            ShowdownMetadata showdownMetadata = (ShowdownMetadata)other;
            return Double.compare(this.showdownVersion, showdownMetadata.showdownVersion) == 0;
        }
    }
}

